/*
 * Decompiled with CFR 0.152.
 */
package development;

import development.DataSets;
import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import statistics.simulators.ElasticModel;
import statistics.simulators.Model;
import statistics.simulators.SimulateDictionaryData;
import statistics.simulators.SimulateElasticData;
import statistics.simulators.SimulateIntervalData;
import statistics.simulators.SimulateMatrixProfileData;
import statistics.simulators.SimulateShapeletData;
import statistics.simulators.SimulateSpectralData;
import timeseriesweka.classifiers.BOSS;
import timeseriesweka.classifiers.BagOfPatterns;
import timeseriesweka.classifiers.DD_DTW;
import timeseriesweka.classifiers.DTD_C;
import timeseriesweka.classifiers.ElasticEnsemble;
import timeseriesweka.classifiers.FastDTW_1NN;
import timeseriesweka.classifiers.FastShapelets;
import timeseriesweka.classifiers.FlatCote;
import timeseriesweka.classifiers.HiveCote;
import timeseriesweka.classifiers.LPS;
import timeseriesweka.classifiers.LearnShapelets;
import timeseriesweka.classifiers.RISE;
import timeseriesweka.classifiers.ST_HESCA;
import timeseriesweka.classifiers.TSBF;
import timeseriesweka.classifiers.TSF;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.DTW1NN;
import timeseriesweka.filters.MatrixProfile;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import vector_classifiers.HESCA;
import vector_classifiers.TunedRandomForest;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.lazy.kNN;
import weka.classifiers.meta.RotationForest;
import weka.core.Instances;
import weka.filters.NormalizeCase;

public class SimulationExperiments {
    static boolean local = false;
    static int[] casesPerClass = new int[]{50, 50};
    static int seriesLength = 500;
    static double trainProp = 0.5;
    static boolean normalize = true;
    static String[] allClassifiers = new String[]{"ED", "RotF", "DTW", "EE", "HESCA", "TSF", "ST", "BOSS", "RISE", "FLATCOTE", "HIVECOTE"};
    static String[] allSimulators = new String[]{"WholeSeriesElastic", "Interval", "Shapelet", "Dictionary", "ARMA"};

    public static Classifier setClassifier(String str) throws RuntimeException {
        AbstractClassifier c;
        switch (str) {
            case "ED": 
            case "MP_ED": {
                c = new kNN(1);
                break;
            }
            case "HESCA": {
                c = new HESCA();
                break;
            }
            case "RandF": 
            case "MP_RotF": {
                c = new TunedRandomForest();
                break;
            }
            case "RotF": {
                c = new RotationForest();
                break;
            }
            case "DTW": 
            case "MP_DTW": {
                c = new DTW1NN();
                break;
            }
            case "DD_DTW": {
                c = new DD_DTW();
                break;
            }
            case "DTD_C": {
                c = new DTD_C();
                break;
            }
            case "EE": {
                c = new ElasticEnsemble();
                break;
            }
            case "TSF": {
                c = new TSF();
                break;
            }
            case "TSBF": {
                c = new TSBF();
                break;
            }
            case "LPS": {
                c = new LPS();
                break;
            }
            case "FastShapelets": {
                c = new FastShapelets();
                break;
            }
            case "ST": {
                c = new ST_HESCA();
                if (local) {
                    ((ST_HESCA)c).setOneMinuteLimit();
                    break;
                }
                ((ST_HESCA)c).setOneHourLimit();
                break;
            }
            case "BOP": {
                c = new BagOfPatterns();
                break;
            }
            case "BOSS": {
                c = new BOSS();
                break;
            }
            case "COTE": 
            case "FLATCOTE": {
                c = new FlatCote();
                break;
            }
            case "HIVECOTE": {
                c = new HiveCote();
                break;
            }
            case "RISE": {
                c = new RISE();
                ((RISE)c).setTransformType("PS_ACF");
                ((RISE)c).setNosBaseClassifiers(500);
                break;
            }
            case "RISE_HESCA": {
                c = new RISE();
                ((RISE)c).setTransformType("PS_ACF");
                HESCA base = new HESCA();
                ((RISE)c).setBaseClassifier(base);
                ((RISE)c).setNosBaseClassifiers(20);
                break;
            }
            default: {
                throw new RuntimeException(" UNKNOWN CLASSIFIER " + str);
            }
        }
        return c;
    }

    public static void setStandardGlobalParameters(String str) {
        switch (str) {
            case "ARMA": 
            case "AR": 
            case "Spectral": {
                casesPerClass = new int[]{200, 200};
                seriesLength = 200;
                trainProp = 0.1;
                Model.setDefaultSigma(1.0);
                break;
            }
            case "Shapelet": {
                casesPerClass = new int[]{250, 250};
                seriesLength = 300;
                trainProp = 0.1;
                Model.setDefaultSigma(1.0);
                break;
            }
            case "Dictionary": {
                casesPerClass = new int[]{200, 200};
                seriesLength = 1500;
                trainProp = 0.1;
                SimulateDictionaryData.setShapeletsPerClass(new int[]{5, 10});
                SimulateDictionaryData.setShapeletLength(29);
                Model.setDefaultSigma(1.0);
                break;
            }
            case "Interval": {
                seriesLength = 1000;
                trainProp = 0.1;
                casesPerClass = new int[]{200, 200};
                Model.setDefaultSigma(1.0);
                SimulateIntervalData.setNosIntervals(3);
                SimulateIntervalData.setNoiseToSignal(10);
                break;
            }
            case "WholeSeriesElastic": 
            case "WholeSeries": {
                seriesLength = 100;
                trainProp = 0.1;
                casesPerClass = new int[]{100, 100};
                Model.setDefaultSigma(1.0);
                ElasticModel.setBaseAndAmp(-2.0, 4.0);
                ElasticModel.setWarpPercent(0.4);
                break;
            }
            case "MatrixProfile": {
                seriesLength = 150;
                trainProp = 0.1;
                casesPerClass = new int[]{50, 50};
                Model.setDefaultSigma(1.0);
                break;
            }
            default: {
                throw new RuntimeException(" UNKNOWN SIMULATOR ");
            }
        }
    }

    public static Instances simulateData(String str, int seed) throws RuntimeException {
        Instances data;
        Model.setGlobalRandomSeed(seed);
        switch (str) {
            case "ARMA": 
            case "AR": 
            case "SPECTRAL": {
                data = SimulateSpectralData.generateSpectralEmbeddedData(seriesLength, casesPerClass);
                break;
            }
            case "Shapelet": {
                data = SimulateShapeletData.generateShapeletData(seriesLength, casesPerClass);
                break;
            }
            case "Dictionary": {
                data = SimulateDictionaryData.generateDictionaryData(seriesLength, casesPerClass);
                break;
            }
            case "Interval": {
                data = SimulateIntervalData.generateIntervalData(seriesLength, casesPerClass);
                break;
            }
            case "WholeSeries": 
            case "WholeSeriesElastic": {
                data = SimulateElasticData.generateElasticData(seriesLength, casesPerClass);
                break;
            }
            case "MatrixProfile": {
                data = SimulateMatrixProfileData.generateMatrixProfileData(seriesLength, casesPerClass);
                break;
            }
            default: {
                throw new RuntimeException(" UNKNOWN SIMULATOR " + str);
            }
        }
        return data;
    }

    public static double runSimulationExperiment(String[] args, boolean useStandard) throws Exception {
        String predictions;
        String simulator = args[0];
        if (useStandard) {
            SimulationExperiments.setStandardGlobalParameters(simulator);
        }
        String classifier = args[1];
        Classifier c = SimulationExperiments.setClassifier(classifier);
        int fold = Integer.parseInt(args[2]) - 1;
        File f = new File(DataSets.resultsPath + simulator);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = DataSets.resultsPath + simulator + "/" + classifier)).exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions + "/testFold" + fold + ".csv")).exists() || f.length() == 0L) {
            Instances data = SimulationExperiments.simulateData(args[0], fold);
            Instances[] split = InstanceTools.resampleInstances(data, fold, trainProp);
            System.out.println(" Train size =" + split[0].numInstances() + " test size =" + split[1].numInstances());
            if (classifier.contains("MP_")) {
                try {
                    System.out.println("MAtrix profile run ....");
                    MatrixProfile mp = new MatrixProfile(29);
                    split[0] = mp.process(split[0]);
                    split[1] = mp.process(split[1]);
                }
                catch (Exception ex) {
                    Logger.getLogger(SimulationExperiments.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (normalize) {
                NormalizeCase nc = new NormalizeCase();
                split[0] = nc.process(split[0]);
                split[0] = nc.process(split[1]);
            }
            double acc = SimulationExperiments.singleSampleExperiment(split[0], split[1], c, fold, predictions);
            return acc;
        }
        System.out.println(predictions + "/testFold" + fold + ".csv already exists");
        return -1.0;
    }

    public static void pairwiseTests() {
    }

    public static void combineTestResults(String classifier, String simulator) {
        int folds = 200;
        File f = new File(DataSets.resultsPath + "/" + simulator);
        if (!f.exists() || !f.isDirectory()) {
            f.mkdir();
        } else {
            boolean results = false;
            for (int i = 0; i < folds && !results; ++i) {
                f = new File(DataSets.resultsPath + "/" + simulator + "/" + classifier + "/testFold" + i + ".csv");
                if (!f.exists()) continue;
                results = true;
            }
            if (results) {
                OutFile of = new OutFile(DataSets.resultsPath + "/" + simulator + "/" + classifier + ".csv");
                for (int i = 0; i < folds; ++i) {
                    f = new File(DataSets.resultsPath + "/" + simulator + "/" + classifier + "/testFold" + i + ".csv");
                    if (!f.exists() || f.length() <= 0L) continue;
                    InFile inf = new InFile(DataSets.resultsPath + "/" + simulator + "/" + classifier + "/testFold" + i + ".csv");
                    inf.readLine();
                    inf.readLine();
                    of.writeLine(i + "," + inf.readDouble());
                }
                of.closeFile();
            }
        }
    }

    public static double singleSampleExperiment(Instances train, Instances test, Classifier c, int sample, String preds) {
        double acc = 0.0;
        OutFile p = new OutFile(preds + "/testFold" + sample + ".csv");
        if (c instanceof SaveableEnsemble) {
            ((SaveableEnsemble)((Object)c)).saveResults(preds + "/internalCV_" + sample + ".csv", preds + "/internalTestPreds_" + sample + ".csv");
        }
        try {
            int j;
            c.buildClassifier(train);
            int[][] predictions = new int[test.numInstances()][2];
            for (j = 0; j < test.numInstances(); ++j) {
                predictions[j][0] = (int)test.instance(j).classValue();
                test.instance(j).setMissing(test.classIndex());
            }
            for (j = 0; j < test.numInstances(); ++j) {
                predictions[j][1] = (int)c.classifyInstance(test.instance(j));
                if (predictions[j][0] != predictions[j][1]) continue;
                acc += 1.0;
            }
            acc /= (double)test.numInstances();
            String[] names = preds.split("/");
            p.writeLine(names[names.length - 1] + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                p.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else if (c instanceof SaveableEnsemble) {
                p.writeLine(((SaveableEnsemble)((Object)c)).getParameters());
            } else {
                p.writeLine("NoParameterInfo");
            }
            p.writeLine(acc + "");
            for (int j2 = 0; j2 < test.numInstances(); ++j2) {
                double[] dist;
                p.writeString(predictions[j2][0] + "," + predictions[j2][1] + ",");
                for (double d : dist = c.distributionForInstance(test.instance(j2))) {
                    p.writeString("," + d);
                }
                p.writeString("\n");
            }
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method simpleExperiment" + e);
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes and " + test.numInstances() + " instances");
            System.exit(0);
        }
        return acc;
    }

    public static void collateAllResults() {
        DataSets.resultsPath = "C:\\Users\\ajb\\Dropbox\\Results\\SimulationExperiments\\BasicExperiments\\";
        for (String s : allClassifiers) {
            for (String a : allSimulators) {
                SimulationExperiments.combineTestResults(s, a);
            }
        }
        int folds = 200;
        for (String a : allSimulators) {
            if (!new File(DataSets.resultsPath + a).exists()) continue;
            System.out.println(" Simulation = " + a);
            OutFile of = new OutFile(DataSets.resultsPath + a + "CombinedResults.csv");
            InFile[] ins = new InFile[allClassifiers.length];
            int count = 0;
            of.writeString(",");
            for (String s : allClassifiers) {
                InFile inf;
                int lines;
                File f = new File(DataSets.resultsPath + a + "\\" + s + ".csv");
                if (!f.exists() || (lines = (inf = new InFile(DataSets.resultsPath + a + "\\" + s + ".csv")).countLines()) < folds) continue;
                System.out.println(" Doing " + a + " and " + s);
                of.writeString(s + ",");
                ins[count++] = new InFile(DataSets.resultsPath + a + "\\" + s + ".csv");
            }
            of.writeString("\n");
            for (int i = 0; i < folds; ++i) {
                of.writeString("Rep" + i + ",");
                for (int j = 0; j < count; ++j) {
                    ins[j].readInt();
                    double acc = ins[j].readDouble();
                    of.writeString(acc + ",");
                }
                of.writeString("\n");
            }
        }
    }

    public static void runShapeletSimulatorExperiment() {
        Model.setDefaultSigma(1.0);
        seriesLength = 300;
        casesPerClass = new int[]{50, 50};
        String[] classifiers = new String[]{"RotF", "DTW", "FastShapelets", "ST", "BOSS"};
        OutFile of = new OutFile("C:\\Temp\\ShapeletSimExperiment.csv");
        SimulationExperiments.setStandardGlobalParameters("Shapelet");
        of.writeLine("Shapelet Sim, series length= " + seriesLength + " cases class 0 =" + casesPerClass[0] + " class 1" + casesPerClass[0] + " train proportion = " + trainProp);
        of.writeString("Rep");
        for (String s : classifiers) {
            of.writeString("," + s);
        }
        of.writeString("\n");
        for (int i = 0; i < 100; ++i) {
            of.writeString(i + ",");
            Model.setGlobalRandomSeed(i);
            Instances data = SimulateShapeletData.generateShapeletData(seriesLength, casesPerClass);
            Instances[] split = InstanceTools.resampleInstances(data, i, trainProp);
            String[] stringArray = classifiers;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                AbstractClassifier c;
                String str;
                switch (str = stringArray[j]) {
                    case "RotF": {
                        c = new RotationForest();
                        break;
                    }
                    case "DTW": {
                        c = new FastDTW_1NN();
                        break;
                    }
                    case "EE": {
                        c = new ElasticEnsemble();
                        break;
                    }
                    case "TSF": {
                        c = new TSF();
                        break;
                    }
                    case "TSBF": {
                        c = new TSBF();
                        break;
                    }
                    case "FastShapelets": {
                        c = new FastShapelets();
                        break;
                    }
                    case "ST": {
                        c = new ST_HESCA();
                        ((ST_HESCA)c).setOneMinuteLimit();
                        break;
                    }
                    case "LearnShapelets": {
                        c = new LearnShapelets();
                        break;
                    }
                    case "BOP": {
                        c = new BagOfPatterns();
                        break;
                    }
                    case "BOSS": {
                        c = new BOSS();
                        break;
                    }
                    case "COTE": {
                        c = new FlatCote();
                        break;
                    }
                    case "RISE": {
                        c = new RISE();
                        ((RISE)c).setTransformType("PS_ACF");
                        ((RISE)c).setNosBaseClassifiers(500);
                        break;
                    }
                    default: {
                        throw new RuntimeException(" UNKNOWN CLASSIFIER " + str);
                    }
                }
                double acc = ClassifierTools.singleTrainTestSplitAccuracy(c, split[0], split[1]);
                of.writeString(acc + ",");
                System.out.println(i + " " + str + " acc =" + acc);
            }
            of.writeString("\n");
        }
    }

    public static void runErrorExperiment(String[] args) {
        String predictions;
        String simulator = args[0];
        String classifier = args[1];
        int e = Integer.parseInt(args[2]) - 1;
        int fold = Integer.parseInt(args[3]) - 1;
        File f = new File(DataSets.resultsPath + "Error");
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(DataSets.resultsPath + "Error/" + simulator)).exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = DataSets.resultsPath + "Error/" + simulator + "/" + classifier)).exists()) {
            f.mkdir();
        }
        double error = (double)e / 10.0;
        f = new File(predictions + "/testAcc" + e + "_" + fold + ".csv");
        if (!f.exists() || f.length() == 0L) {
            SimulationExperiments.setStandardGlobalParameters(simulator);
            Model.setDefaultSigma(error);
            Instances data = SimulationExperiments.simulateData(simulator, 50 * (e + 1) * fold);
            Classifier c = SimulationExperiments.setClassifier(classifier);
            Instances[] split = InstanceTools.resampleInstances(data, fold, trainProp);
            double a = ClassifierTools.singleTrainTestSplitAccuracy(c, split[0], split[1]);
            OutFile out = new OutFile(predictions + "/testAcc" + e + "_" + fold + ".csv");
            out.writeLine(a + "");
        }
    }

    public static void runLengthExperiment(String[] args) {
        String predictions;
        String simulator = args[0];
        String classifier = args[1];
        int l = Integer.parseInt(args[2]);
        seriesLength = 10 + (1 + l) * 50;
        File f = new File(DataSets.resultsPath + simulator + "Length");
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = DataSets.resultsPath + simulator + "Length/" + classifier)).exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions + "/testAcc" + l + ".csv")).exists() || f.length() == 0L) {
            OutFile out = new OutFile(predictions + "/testAcc" + l + ".csv");
            double acc = 0.0;
            double var = 0.0;
            for (int fold = 0; fold < 100; ++fold) {
                Instances data = SimulationExperiments.simulateData(simulator, seriesLength);
                Classifier c = SimulationExperiments.setClassifier(classifier);
                Instances[] split = InstanceTools.resampleInstances(data, fold, 0.5);
                double a = ClassifierTools.singleTrainTestSplitAccuracy(c, split[0], split[1]);
                acc += a;
                var += a * a;
            }
            out.writeLine(acc / 100.0 + "," + var);
        }
    }

    public static void trainSetSizeExperiment(String[] args) {
        String predictions;
        String simulator = args[0];
        String classifier = args[1];
        int l = Integer.parseInt(args[2]);
        trainProp = (double)l / 10.0;
        File f = new File(DataSets.resultsPath + simulator + "Length");
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = DataSets.resultsPath + simulator + "Length/" + classifier)).exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions + "/testAcc" + l + ".csv")).exists() || f.length() == 0L) {
            OutFile out = new OutFile(predictions + "/testAcc" + l + ".csv");
            double acc = 0.0;
            double var = 0.0;
            for (int fold = 0; fold < 100; ++fold) {
                Instances data = SimulationExperiments.simulateData(simulator, 50 * (l + 1) * fold);
                Classifier c = SimulationExperiments.setClassifier(classifier);
                Instances[] split = InstanceTools.resampleInstances(data, fold, 0.5);
                double a = ClassifierTools.singleTrainTestSplitAccuracy(c, split[0], split[1]);
                acc += a;
                var += a * a;
            }
            out.writeLine(acc / 100.0 + "," + var);
        }
    }

    public static void collateErrorResults() {
        String path = "C:\\Users\\ajb\\Dropbox\\Results\\SimulationExperiments\\Error\\";
        double[][] means = new double[allClassifiers.length][21];
        for (String a : allSimulators) {
            OutFile out = new OutFile(path + "CollatedError" + a + "Results.csv");
            for (String s : allClassifiers) {
                out.writeString("," + s);
            }
            out.writeString("\n");
            int count = 0;
            for (String s : allClassifiers) {
                for (int i = 0; i <= 20; ++i) {
                    int x = 0;
                    for (int j = 0; j < 100; ++j) {
                        File f = new File(path + a + "\\" + s + "\\testAcc" + i + "_" + j + ".csv");
                        if (!f.exists() || f.length() <= 0L) continue;
                        InFile inf = new InFile(path + a + "\\" + s + "\\testAcc" + i + "_" + j + ".csv");
                        double aa = inf.readDouble();
                        double[] dArray = means[count];
                        int n = i;
                        dArray[n] = dArray[n] + aa;
                        ++x;
                    }
                    if (x <= 0) continue;
                    double[] dArray = means[count];
                    int n = i;
                    dArray[n] = dArray[n] / (double)x;
                }
                ++count;
            }
            for (int j = 0; j < means[0].length; ++j) {
                out.writeString(100 * (j + 1) + ",");
                for (int i = 0; i < means.length; ++i) {
                    out.writeString(means[i][j] + ",");
                }
                out.writeString("\n");
            }
        }
    }

    public static void collateLengthResults() {
        String path = "C:\\Users\\ajb\\Dropbox\\Results\\SimulationExperiments\\ShapeletLength\\";
        OutFile out = new OutFile(path + "CollatedLengthResults.csv");
        out.writeString("Error");
        for (String s : allClassifiers) {
            out.writeString("," + s);
        }
        out.writeString("\n");
        for (int i = 0; i < 10; ++i) {
            out.writeString(i * 50 + 10 + "");
            for (String s : allClassifiers) {
                File f = new File(path + s + "\\testAcc" + i + ".csv");
                if (f.exists() && f.length() > 0L) {
                    InFile inf = new InFile(path + s + "\\testAcc" + i + ".csv");
                    double a = inf.readDouble();
                    out.writeString("," + a);
                    continue;
                }
                out.writeString(",");
            }
            out.writeString("\n");
        }
    }

    public static void createBaseExperimentScripts(boolean grace) {
        String path = "C:\\Users\\ajb\\Dropbox\\Code\\Cluster Scripts\\SimulatorScripts\\BaseExperiment\\";
        File f = new File(path);
        int folds = 200;
        if (!f.isDirectory()) {
            f.mkdir();
        }
        for (String a : allSimulators) {
            OutFile of2 = grace ? new OutFile(path + a + "Grace.txt") : new OutFile(path + a + ".txt");
            for (String s : allClassifiers) {
                OutFile of = grace ? new OutFile(path + s + a + "Grace.bsub") : new OutFile(path + s + a + ".bsub");
                of.writeLine("#!/bin/csh");
                if (grace) {
                    of.writeLine("#BSUB -q short");
                } else {
                    of.writeLine("#BSUB -q long-eth");
                }
                of.writeLine("#BSUB -J " + s + a + "[1-" + folds + "]");
                of.writeLine("#BSUB -oo output/" + a + ".out");
                of.writeLine("#BSUB -eo error/" + a + ".err");
                if (grace) {
                    of.writeLine("#BSUB -R \"rusage[mem=2000]\"");
                    of.writeLine("#BSUB -M 2000");
                    of.writeLine(" module add java/jdk/1.8.0_31");
                } else {
                    of.writeLine("#BSUB -R \"rusage[mem=6000]\"");
                    of.writeLine("#BSUB -M 6000");
                    of.writeLine("module add java/jdk1.8.0_51");
                }
                of.writeLine("java -jar Simulator.jar " + a + " " + s + " $LSB_JOBINDEX");
                if (grace) {
                    of2.writeLine("bsub < Scripts/SimulatorExperiments/BaseExperiment/" + s + a + "Grace.bsub");
                    continue;
                }
                of2.writeLine("bsub < Scripts/SimulatorExperiments/BaseExperiment/" + s + a + ".bsub");
            }
        }
    }

    public static void createErrorScripts(boolean grace, String simulator) {
        String path = "C:\\Users\\ajb\\Dropbox\\Code\\Cluster Scripts\\SimulatorScripts\\Error\\";
        File f = new File(path + simulator);
        if (!f.isDirectory()) {
            f.mkdir();
        }
        String ext = grace ? "ErrorGrace" : "Error";
        for (String classifier : allClassifiers) {
            OutFile of2 = new OutFile(path + simulator + classifier + ext + ".txt");
            for (int i = 1; i <= 21; ++i) {
                OutFile of = new OutFile(path + simulator + "\\\\" + classifier + "_" + ext + "_" + i + ".bsub");
                of.writeLine("#!/bin/csh");
                if (grace) {
                    of.writeLine("#BSUB -q short");
                } else {
                    of.writeLine("#BSUB -q long-eth");
                }
                of.writeLine("#BSUB -J " + classifier + "[1-100]");
                of.writeLine("#BSUB -oo output/" + simulator + ".out");
                of.writeLine("#BSUB -eo error/" + simulator + ".err");
                of.writeLine("#BSUB -R \"rusage[mem=6000]\"");
                of.writeLine("#BSUB -M 6000");
                if (grace) {
                    of.writeLine(" module add java/jdk/1.8.0_31");
                } else {
                    of.writeLine("module add java/jdk1.8.0_51");
                }
                of.writeLine("java -jar Error.jar " + simulator + " " + classifier + " " + i + " $LSB_JOBINDEX");
                of2.writeLine("bsub < Scripts/SimulatorExperiments/Error/" + simulator + "/" + classifier + "_" + ext + "_" + i + ".bsub");
            }
        }
    }

    public static void collateSingleFoldErrorResults() {
        String classifier = "LearnShapelets";
        String path = "C:\\Users\\ajb\\Dropbox\\Results\\SimulationExperiments\\ShapeletError\\" + classifier + "\\";
        OutFile of = new OutFile(path + classifier + ".csv");
        for (int i = 0; i < 21; ++i) {
            double mean = 0.0;
            for (int folds = 0; folds < 100; ++folds) {
                int index = i * 100 + folds;
                InFile inf = new InFile(path + "testAcc" + index + "_" + folds + ".csv");
                mean += inf.readDouble();
            }
            of.writeLine(i + "," + (mean /= 100.0));
        }
    }

    public static void collateSomeStuff() {
        String[] classifiers;
        for (String str : classifiers = new String[]{"RotF", "DTW", "BOSS", "ST"}) {
            String path = "C:\\Users\\ajb\\Dropbox\\Results\\SimulationExperiments\\Dictionary\\" + str + "\\";
            OutFile of = new OutFile(path + str + ".csv");
            double mean = 0.0;
            for (int folds = 0; folds < 200; ++folds) {
                File f = new File(path + "testFold" + folds + ".csv");
                if (!f.exists() || f.length() <= 0L) continue;
                InFile inf = new InFile(path + "testFold" + folds + ".csv");
                inf.readLine();
                inf.readLine();
                double x = inf.readDouble();
                of.writeLine(folds + "," + x);
            }
        }
    }

    public static void generateAllProblemFiles() {
        for (String sim : allSimulators) {
            SimulationExperiments.generateProblemFile(sim);
        }
    }

    public static void generateProblemFile(String sim) {
        SimulationExperiments.setStandardGlobalParameters(sim);
        int s = 22;
        Model.setGlobalRandomSeed(s);
        Model.setDefaultSigma(0.2);
        casesPerClass = new int[]{50, 50};
        try {
            Instances data = SimulationExperiments.simulateData(sim, s);
            Instances[] split = InstanceTools.resampleInstances(data, 0L, trainProp);
            OutFile train = new OutFile("c:\\temp\\" + sim + "SimLowNoise.csv");
            train.writeString(split[0].toString());
            Model.setDefaultSigma(1.0);
            data = SimulationExperiments.simulateData(sim, 1);
            split = InstanceTools.resampleInstances(data, 0L, trainProp);
            train = new OutFile("c:\\temp\\" + sim + "SimNormalNoise.csv");
            train.writeString(split[0].toString());
        }
        catch (Exception e) {
            System.out.println("should do something really ....");
        }
    }

    public static void main(String[] args) throws Exception {
        block5: {
            int j;
            block3: {
                block4: {
                    if (args.length <= 0) break block3;
                    DataSets.resultsPath = DataSets.clusterPath + "Results/SimulationExperiments/";
                    if (args.length != 3) break block4;
                    double b = SimulationExperiments.runSimulationExperiment(args, true);
                    System.out.println(args[0] + "," + args[1] + ",," + args[2] + " Acc =" + b);
                    break block5;
                }
                if (args.length != 4) break block5;
                SimulationExperiments.runErrorExperiment(args);
                break block5;
            }
            local = true;
            DataSets.resultsPath = "C:\\temp\\";
            String[] algos = new String[]{"ED", "MP_ED"};
            double[] meanAcc = new double[algos.length];
            for (int i = 1; i <= 10; ++i) {
                j = 0;
                while (j < algos.length) {
                    String[] para = new String[]{"MatrixProfile", algos[j], i + ""};
                    double b = SimulationExperiments.runSimulationExperiment(para, true);
                    int n = j++;
                    meanAcc[n] = meanAcc[n] + b;
                    System.out.println(para[0] + "," + para[1] + ",," + para[2] + " Acc =" + b);
                }
            }
            DecimalFormat df = new DecimalFormat("##.####");
            for (j = 0; j < algos.length; ++j) {
                System.out.println(algos[j] + " mean acc =" + df.format(meanAcc[j] / 10.0));
            }
        }
    }
}

