/*
 * Decompiled with CFR 0.152.
 */
package development;

import development.CollateResults;
import development.DataSets;
import fileIO.OutFile;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import timeseriesweka.classifiers.BOSS;
import timeseriesweka.classifiers.BagOfPatterns;
import timeseriesweka.classifiers.DD_DTW;
import timeseriesweka.classifiers.DTD_C;
import timeseriesweka.classifiers.ElasticEnsemble;
import timeseriesweka.classifiers.FastDTW_1NN;
import timeseriesweka.classifiers.FastShapelets;
import timeseriesweka.classifiers.FlatCote;
import timeseriesweka.classifiers.HiveCote;
import timeseriesweka.classifiers.LPS;
import timeseriesweka.classifiers.LearnShapelets;
import timeseriesweka.classifiers.NN_CID;
import timeseriesweka.classifiers.ParameterSplittable;
import timeseriesweka.classifiers.RISE;
import timeseriesweka.classifiers.SAXVSM;
import timeseriesweka.classifiers.ST_HESCA;
import timeseriesweka.classifiers.TSBF;
import timeseriesweka.classifiers.TSF;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.DTW1NN;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.ED1NN;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.MSM1NN;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.WDTW1NN;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.CrossValidator;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.HESCA;
import vector_classifiers.RotationForestBootstrap;
import vector_classifiers.RotationForestLimitedAttributes;
import vector_classifiers.SaveEachParameter;
import vector_classifiers.TunedMLP;
import vector_classifiers.TunedRandomForest;
import vector_classifiers.TunedRotationForest;
import vector_classifiers.TunedSVM;
import vector_classifiers.TunedTwoLayerMLP;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.RandomForest;
import weka.core.Instances;

public class Experiments
implements Runnable {
    String[] args;
    public static int folds = 30;
    static int numCVFolds = 10;
    static boolean debug = true;
    static boolean checkpoint = false;
    static boolean generateTrainFiles = true;
    static Integer parameterNum = 0;
    static boolean singleFile = false;
    static boolean foldsInFile = false;
    public static String[] cmpv2202398 = new String[]{"miniboone"};
    public static String[] cmpv2264419 = new String[]{"miniboone"};
    public static String[] ajb17pc = new String[]{"connect-4", "miniboone"};

    public static Classifier setClassifier(String classifier, int fold) {
        AbstractClassifier c = null;
        TunedSVM svm = null;
        switch (classifier) {
            case "ED": {
                c = new ED1NN();
                break;
            }
            case "C45": {
                c = new J48();
                break;
            }
            case "NB": {
                c = new NaiveBayes();
                break;
            }
            case "SVML": {
                c = new SMO();
                PolyKernel p = new PolyKernel();
                p.setExponent(1.0);
                ((SMO)c).setKernel(p);
                ((SMO)c).setRandomSeed(fold);
                ((SMO)c).setBuildLogisticModels(true);
                break;
            }
            case "SVMQ": 
            case "SVMQuad": {
                c = new SMO();
                PolyKernel p2 = new PolyKernel();
                p2.setExponent(2.0);
                ((SMO)c).setKernel(p2);
                ((SMO)c).setRandomSeed(fold);
                ((SMO)c).setBuildLogisticModels(true);
                break;
            }
            case "SVMRBF": {
                c = new SMO();
                RBFKernel rbf = new RBFKernel();
                rbf.setGamma(0.5);
                ((SMO)c).setC(5.0);
                ((SMO)c).setKernel(rbf);
                ((SMO)c).setRandomSeed(fold);
                ((SMO)c).setBuildLogisticModels(true);
                break;
            }
            case "BN": {
                c = new BayesNet();
                break;
            }
            case "MLP": {
                c = new MultilayerPerceptron();
                break;
            }
            case "RandFOOB": {
                c = new TunedRandomForest();
                ((RandomForest)c).setNumTrees(500);
                ((TunedRandomForest)c).tuneParameters(false);
                ((TunedRandomForest)c).setCrossValidate(false);
                ((TunedRandomForest)c).setEstimateAcc(true);
                ((TunedRandomForest)c).setSeed(fold);
                ((TunedRandomForest)c).setDebug(debug);
                break;
            }
            case "RandF": {
                c = new TunedRandomForest();
                ((RandomForest)c).setNumTrees(500);
                ((TunedRandomForest)c).tuneParameters(false);
                ((TunedRandomForest)c).setCrossValidate(true);
                ((TunedRandomForest)c).setSeed(fold);
                break;
            }
            case "RotF": {
                c = new TunedRotationForest();
                ((RotationForest)c).setNumIterations(200);
                ((TunedRotationForest)c).tuneParameters(false);
                ((TunedRotationForest)c).setSeed(fold);
                ((TunedRotationForest)c).estimateAccFromTrain(false);
                break;
            }
            case "RotFBootstrap": {
                c = new RotationForestBootstrap();
                ((RotationForestBootstrap)c).setNumIterations(200);
                ((RotationForestBootstrap)c).setSeed(fold);
                ((RotationForestBootstrap)c).tuneParameters(false);
                ((RotationForestBootstrap)c).setSeed(fold);
                ((RotationForestBootstrap)c).estimateAccFromTrain(false);
                break;
            }
            case "RotFLimited": {
                c = new RotationForestLimitedAttributes();
                ((RotationForestLimitedAttributes)c).setNumIterations(200);
                ((RotationForestLimitedAttributes)c).tuneParameters(false);
                ((RotationForestLimitedAttributes)c).setSeed(fold);
                ((RotationForestLimitedAttributes)c).estimateAccFromTrain(false);
                break;
            }
            case "TunedRandF": {
                c = new TunedRandomForest();
                ((TunedRandomForest)c).tuneParameters(true);
                ((TunedRandomForest)c).setCrossValidate(true);
                ((TunedRandomForest)c).setSeed(fold);
                ((TunedRandomForest)c).setDebug(debug);
                break;
            }
            case "TunedRandFOOB": {
                c = new TunedRandomForest();
                ((TunedRandomForest)c).tuneParameters(true);
                ((TunedRandomForest)c).setCrossValidate(false);
                ((TunedRotationForest)c).setSeed(fold);
                break;
            }
            case "TunedRotF": {
                c = new TunedRotationForest();
                ((TunedRotationForest)c).tuneParameters(true);
                ((TunedRotationForest)c).setSeed(fold);
                break;
            }
            case "TunedSVMRBF": {
                svm = new TunedSVM();
                svm.setKernelType(TunedSVM.KernelType.RBF);
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                c = svm;
                break;
            }
            case "TunedSVMQuad": {
                svm = new TunedSVM();
                svm.setKernelType(TunedSVM.KernelType.QUADRATIC);
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                svm.setLargePolynomialParameterSpace(1089);
                c = svm;
                break;
            }
            case "TunedSVMLinear": {
                svm = new TunedSVM();
                svm.setKernelType(TunedSVM.KernelType.LINEAR);
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                svm.setLargePolynomialParameterSpace(1089);
                c = svm;
                break;
            }
            case "TunedSVMPolynomial": {
                svm = new TunedSVM();
                svm.setKernelType(TunedSVM.KernelType.POLYNOMIAL);
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                c = svm;
                break;
            }
            case "TunedSVMKernel": {
                svm = new TunedSVM();
                svm.optimiseParas(true);
                svm.optimiseKernel(true);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                c = svm;
                break;
            }
            case "TunedSingleLayerMLP": {
                TunedMLP mlp = new TunedMLP();
                mlp.setParamSearch(true);
                mlp.setSeed(fold);
                c = mlp;
                break;
            }
            case "TunedTwoLayerMLP": {
                TunedTwoLayerMLP mlp2 = new TunedTwoLayerMLP();
                mlp2.setParamSearch(true);
                mlp2.setSeed(fold);
                c = mlp2;
                break;
            }
            case "RandomRotationForest1": {
                c = new RotationForestLimitedAttributes();
                ((RotationForestLimitedAttributes)c).setNumIterations(200);
                ((RotationForestLimitedAttributes)c).setMaxNumAttributes(100);
                break;
            }
            case "Logistic": {
                c = new Logistic();
                break;
            }
            case "HESCA": {
                c = new HESCA();
                ((HESCA)c).setRandSeed(fold);
                break;
            }
            case "EE": 
            case "ElasticEnsemble": {
                c = new ElasticEnsemble();
                break;
            }
            case "DTW": {
                c = new DTW1NN();
                ((DTW1NN)c).setWindow(1.0);
                break;
            }
            case "DTWCV": {
                c = new FastDTW_1NN();
                ((FastDTW_1NN)c).optimiseWindow(true);
                break;
            }
            case "DD_DTW": {
                c = new DD_DTW();
                break;
            }
            case "DTD_C": {
                c = new DTD_C();
                break;
            }
            case "CID_DTW": {
                c = new NN_CID();
                ((NN_CID)c).useDTW();
                break;
            }
            case "MSM": {
                c = new MSM1NN();
                break;
            }
            case "TWE": {
                c = new MSM1NN();
                break;
            }
            case "WDTW": {
                c = new WDTW1NN();
                break;
            }
            case "LearnShapelets": 
            case "LS": {
                c = new LearnShapelets();
                break;
            }
            case "FastShapelets": 
            case "FS": {
                c = new FastShapelets();
                break;
            }
            case "ShapeletTransform": 
            case "ST": 
            case "ST_Ensemble": {
                c = new ST_HESCA();
                ((ST_HESCA)c).setOneDayLimit();
                break;
            }
            case "TSF": {
                c = new TSF();
                break;
            }
            case "RISE": {
                c = new RISE();
                break;
            }
            case "TSBF": {
                c = new TSBF();
                break;
            }
            case "BOP": 
            case "BoP": 
            case "BagOfPatterns": {
                c = new BagOfPatterns();
                break;
            }
            case "BOSS": 
            case "BOSSEnsemble": {
                c = new BOSS();
                break;
            }
            case "SAXVSM": 
            case "SAX": {
                c = new SAXVSM();
                break;
            }
            case "LPS": {
                c = new LPS();
                break;
            }
            case "FlatCOTE": {
                c = new FlatCote();
                break;
            }
            case "HiveCOTE": {
                c = new HiveCote();
                break;
            }
            default: {
                System.out.println("UNKNOWN CLASSIFIER " + classifier);
                System.exit(0);
            }
        }
        return c;
    }

    @Override
    public void run() {
        try {
            System.out.print("Running ");
            for (String str : this.args) {
                System.out.print(str + " ");
            }
            System.out.print("\n");
            Experiments.singleClassifierAndFoldTrainTestSplit(this.args);
        }
        catch (Exception ex) {
            System.out.println("ERROR, cannot run experiment :");
            for (String str : this.args) {
                System.out.print(str + ",");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        debug = false;
        for (String str : args) {
            System.out.println(str);
        }
        if (args.length < 6) {
            if (debug) {
                System.out.println("Num args passed =" + args.length);
                for (String str : args) {
                    System.out.println(str);
                }
                DataSets.problemPath = "C:\\Users\\ajb\\Dropbox\\UCI Problems\\";
                DataSets.resultsPath = "C:\\Temp\\";
                File f = new File(DataSets.resultsPath);
                if (!f.isDirectory()) {
                    f.mkdirs();
                }
                generateTrainFiles = true;
                checkpoint = false;
                parameterNum = 0;
                debug = true;
                System.exit(0);
            } else {
                Experiments.threadedExperiment("ajb17pc");
            }
        } else {
            Experiments.singleExperiment(args);
        }
    }

    public static void threadedExperiment(String dataSet) throws Exception {
        String[] problems;
        folds = 30;
        int cores = Runtime.getRuntime().availableProcessors();
        System.out.println("# cores =" + cores);
        ExecutorService executor = Executors.newFixedThreadPool(cores);
        DataSets.problemPath = "//cmptscsvr.cmp.uea.ac.uk/ueatsc/Data/" + dataSet + "/";
        DataSets.resultsPath = "//cmptscsvr.cmp.uea.ac.uk/ueatsc/Results/" + dataSet + "/";
        parameterNum = 0;
        String classifier = "TunedRotF";
        if (dataSet.equals("UCIContinuous")) {
            problems = DataSets.UCIContinuousFileNames;
        } else if (dataSet.equals("TSCProblems")) {
            problems = DataSets.fileNames;
        } else if (dataSet.equals("LargeProblems")) {
            problems = DataSets.largeProblems;
        } else if (dataSet.equals("cmpv2202398")) {
            DataSets.problemPath = "//cmptscsvr.cmp.uea.ac.uk/ueatsc/Data/UCIContinuous/";
            DataSets.resultsPath = "//cmptscsvr.cmp.uea.ac.uk/ueatsc/Results/UCIContinuous/";
            problems = cmpv2202398;
        } else if (dataSet.equals("cmpv2264419")) {
            DataSets.problemPath = "//cmptscsvr.cmp.uea.ac.uk/ueatsc/Data/UCIContinuous/";
            DataSets.resultsPath = "//cmptscsvr.cmp.uea.ac.uk/ueatsc/Results/UCIContinuous/";
            problems = cmpv2264419;
        } else if (dataSet.equals("ajb17pc")) {
            DataSets.problemPath = "//cmptscsvr.cmp.uea.ac.uk/ueatsc/Data/UCIContinuous/";
            DataSets.resultsPath = "//cmptscsvr.cmp.uea.ac.uk/ueatsc/Results/UCIContinuous/";
            problems = ajb17pc;
        } else {
            throw new Exception(" data set = " + dataSet);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String str : problems) {
            names.add(str);
        }
        generateTrainFiles = true;
        checkpoint = true;
        for (int i = 0; i < names.size(); ++i) {
            if (Experiments.isPig((String)names.get(i))) continue;
            for (int j = 1; j <= folds; ++j) {
                String[] args = new String[]{classifier, (String)names.get(i), "" + j};
                Experiments exp = new Experiments();
                exp.args = args;
                executor.execute(exp);
            }
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        System.out.println("Finished all threads");
    }

    public static boolean isPig(String str) {
        return false;
    }

    public static void singleExperiment(String[] args) throws Exception {
        String s;
        DataSets.problemPath = args[0];
        DataSets.resultsPath = args[1];
        generateTrainFiles = Boolean.parseBoolean(args[2]);
        File f = new File(DataSets.resultsPath);
        if (!f.isDirectory()) {
            f.mkdirs();
            f.setWritable(true, false);
        }
        String[] newArgs = new String[3];
        for (int i = 0; i < 3; ++i) {
            newArgs[i] = args[i + 3];
        }
        checkpoint = false;
        if (args.length >= 7 && (s = args[args.length - 1].toLowerCase()).equals("true")) {
            checkpoint = true;
        }
        parameterNum = 0;
        if (args.length >= 8) {
            parameterNum = Integer.parseInt(args[7]);
        }
        System.out.println("Checkpoint =" + checkpoint + " param number =" + parameterNum);
        Experiments.singleClassifierAndFoldTrainTestSplit(newArgs);
    }

    public static void singleClassifierAndFoldTrainTestSplit(String[] args) throws Exception {
        String classifier = args[0];
        String problem = args[1];
        int fold = Integer.parseInt(args[2]) - 1;
        String predictions = DataSets.resultsPath + classifier + "/Predictions/" + problem;
        File f = new File(predictions);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!CollateResults.validateSingleFoldFile(predictions + "/testFold" + fold + ".csv")) {
            Instances[] data;
            File f2;
            Classifier c = Experiments.setClassifier(classifier, fold);
            if (foldsInFile) {
                f = new File(DataSets.problemPath + problem + "/" + problem + fold + "_TRAIN.arff");
                f2 = new File(DataSets.problemPath + problem + "/" + problem + fold + "_TEST.arff");
                if (!f.exists() || !f2.exists()) {
                    throw new Exception(" Problem files " + DataSets.problemPath + problem + "/" + problem + fold + "_TRAIN.arff not found");
                }
                Instances train = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem + fold + "_TRAIN");
                Instances test = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem + fold + "_TEST");
                data = new Instances[]{train, test};
            } else {
                f = new File(DataSets.problemPath + problem + "/" + problem + "_TRAIN.arff");
                f2 = new File(DataSets.problemPath + problem + "/" + problem + "_TEST.arff");
                if (!f.exists() || !f2.exists()) {
                    singleFile = true;
                }
                if (singleFile) {
                    Instances all = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem);
                    data = InstanceTools.resampleInstances(all, fold, 0.5);
                } else {
                    Instances train = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem + "_TRAIN");
                    Instances test = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem + "_TEST");
                    data = InstanceTools.resampleTrainAndTestInstances(train, test, fold);
                }
            }
            if (parameterNum > 0 && c instanceof ParameterSplittable) {
                checkpoint = false;
                if (CollateResults.validateSingleFoldFile(predictions + "/fold" + fold + "_" + parameterNum + ".csv")) {
                    System.out.println("Fold " + predictions + "/fold" + fold + "_" + parameterNum + ".csv  already exists");
                    return;
                }
            }
            double acc = Experiments.singleClassifierAndFoldTrainTestSplit(data[0], data[1], c, fold, predictions);
            System.out.println(classifier + "," + problem + "," + fold + ",test acc," + acc);
        }
    }

    public static double singleClassifierAndFoldTrainTestSplit(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        String testFoldPath = "/testFold" + fold + ".csv";
        String trainFoldPath = "/trainFold" + fold + ".csv";
        ClassifierResults trainResults = null;
        ClassifierResults testResults = null;
        if (parameterNum > 0 && c instanceof ParameterSplittable) {
            if (c instanceof TunedRandomForest) {
                ((TunedRandomForest)c).setNumFeaturesInProblem(train.numAttributes() - 1);
            }
            checkpoint = false;
            ((ParameterSplittable)((Object)c)).setParametersFromIndex(parameterNum);
            trainFoldPath = "/fold" + fold + "_" + parameterNum + ".csv";
            generateTrainFiles = true;
        } else {
            if (c instanceof SaveableEnsemble) {
                ((SaveableEnsemble)((Object)c)).saveResults(resultsPath + "/internalCV_" + fold + ".csv", resultsPath + "/internalTestPreds_" + fold + ".csv");
            }
            if (checkpoint && c instanceof SaveEachParameter) {
                ((SaveEachParameter)((Object)c)).setPathToSaveParameters(resultsPath + "/fold" + fold + "_");
            }
        }
        try {
            if (generateTrainFiles) {
                if (c instanceof TrainAccuracyEstimate) {
                    ((TrainAccuracyEstimate)((Object)c)).writeCVTrainToFile(resultsPath + trainFoldPath);
                    File f = new File(resultsPath + trainFoldPath);
                    if (f.exists()) {
                        f.setWritable(true, false);
                    }
                } else {
                    int numFolds = Math.min(train.numInstances(), numCVFolds);
                    CrossValidator cv = new CrossValidator();
                    cv.setSeed(fold);
                    cv.setNumFolds(numFolds);
                    trainResults = cv.crossValidateWithStats(c, train);
                }
            }
            long buildTime = System.currentTimeMillis();
            c.buildClassifier(train);
            buildTime = System.currentTimeMillis() - buildTime;
            if (generateTrainFiles && !(c instanceof TrainAccuracyEstimate)) {
                OutFile trainOut = new OutFile(resultsPath + trainFoldPath);
                trainOut.writeLine(train.relationName() + "," + c.getClass().getName() + ",train");
                if (c instanceof SaveParameterInfo) {
                    trainOut.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
                } else {
                    trainOut.writeLine("BuildTime," + buildTime + ",No Parameter Info");
                }
                trainOut.writeLine(trainResults.acc + "");
                trainOut.writeLine(trainResults.writeInstancePredictions());
                trainOut.closeFile();
                File f = new File(resultsPath + trainFoldPath);
                if (f.exists()) {
                    f.setWritable(true, false);
                }
            }
            if (parameterNum == 0) {
                int numInsts = test.numInstances();
                testResults = new ClassifierResults(test.numClasses());
                double[] trueClassValues = test.attributeToDoubleArray(test.classIndex());
                for (int testInstIndex = 0; testInstIndex < numInsts; ++testInstIndex) {
                    test.instance(testInstIndex).setClassMissing();
                    double[] probs = c.distributionForInstance(test.instance(testInstIndex));
                    testResults.storeSingleResult(probs);
                }
                testResults.finaliseResults(trueClassValues);
                OutFile testOut = new OutFile(resultsPath + testFoldPath);
                testOut.writeLine(test.relationName() + "," + c.getClass().getName() + ",test");
                if (c instanceof SaveParameterInfo) {
                    testOut.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
                } else {
                    testOut.writeLine("No parameter info");
                }
                testOut.writeLine(testResults.acc + "");
                testOut.writeString(testResults.writeInstancePredictions());
                testOut.closeFile();
                File f = new File(resultsPath + testFoldPath);
                if (f.exists()) {
                    f.setWritable(true, false);
                }
                return testResults.acc;
            }
            return 0.0;
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method simpleExperiment");
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes and " + test.numInstances() + " instances");
            System.out.println(" Classifier =" + c.getClass().getName() + " fold = " + fold);
            System.out.println(" Results path is " + resultsPath);
            return Double.NaN;
        }
    }

    public static void tonyTest() throws Exception {
        Instances all = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\UCI Problems\\hayes-roth\\hayes-roth");
        Instances[] data = InstanceTools.resampleInstances(all, 0L, 0.5);
        RandomForest rf = new RandomForest();
        rf.setMaxDepth(0);
        rf.setNumFeatures(1);
        rf.setNumTrees(10);
        CrossValidator cv = new CrossValidator();
        ClassifierResults tempResults = cv.crossValidateWithStats(rf, data[0]);
        tempResults.setName("RandFPara");
        tempResults.setParas("maxDepth," + rf.getMaxDepth() + ",numFeatures," + rf.getNumFeatures() + ",numTrees," + rf.getNumTrees());
        System.out.println(tempResults.writeResultsFileToString());
    }
}

