/*
 * Decompiled with CFR 0.152.
 */
package development;

import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import timeseriesweka.filters.SummaryStats;
import utilities.ClassifierTools;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class DataSets {
    public static String clusterPath = "/gpfs/home/ajb/";
    public static String dropboxPath = "C:/Users/ajb/Dropbox/";
    public static String beastPath;
    public static String path;
    public static String problemPath;
    public static String resultsPath;
    public static String uciPath;
    public static String[] fileNames;
    public static String[][] fiveSplits;
    public static String[] ucrNames;
    public static String[] ucrSmall;
    public static String[] spectral;
    public static String[] smallTSCProblems;
    public static String[] largeProblems;
    public static String[] fastShapeletProblems;
    public static String[] marteau09stiffness;
    public static String[] stefan13movesplit;
    static int[] testSizes;
    public static String[] uciFileNames;
    public static String[] UCIContinuousFileNames;
    public static String[] datasetsForDAMI2014_Lines;
    public static String[] notNormalised;

    public static void processUCRData() {
        System.out.println(" nos files =" + ucrNames.length);
        for (int str = 39; str < 43; ++str) {
            double v;
            int j;
            String[] split;
            String line;
            int i;
            String s = ucrNames[str];
            InFile trainF = new InFile(problemPath + s + "/" + s + "_TRAIN");
            InFile testF = new InFile(problemPath + s + "/" + s + "_TEST");
            Instances train = ClassifierTools.loadData(problemPath + s + "/" + s + "_TRAIN");
            Instances test = ClassifierTools.loadData(problemPath + s + "/" + s + "_TEST");
            int trainSize = trainF.countLines();
            int testSize = testF.countLines();
            Attribute a = train.classAttribute();
            String tt = a.value(0);
            int first = Integer.parseInt(tt);
            System.out.println(s + " First value =" + tt + " first =" + first);
            if (trainSize != train.numInstances() || testSize != test.numInstances()) {
                System.out.println(" ERROR MISMATCH SIZE TRAIN=" + trainSize + "," + train.numInstances() + " TEST =" + testSize + "," + test.numInstances());
                System.exit(0);
            }
            trainF = new InFile(problemPath + s + "/" + s + "_TRAIN");
            testF = new InFile(problemPath + s + "/" + s + "_TEST");
            File dir = new File(problemPath + s);
            if (!dir.exists()) {
                dir.mkdir();
            }
            OutFile newTrain = new OutFile(problemPath + s + "/" + s + "_TRAIN.arff");
            OutFile newTest = new OutFile(problemPath + s + "/" + s + "_TEST.arff");
            Instances header = new Instances(train, 0);
            newTrain.writeLine(header.toString());
            newTest.writeLine(header.toString());
            for (i = 0; i < trainSize; ++i) {
                line = trainF.readLine();
                line = line.trim();
                split = line.split("/s+");
                try {
                    double c = Double.valueOf(split[0]);
                    if ((int)(c - 1.0) != (int)train.instance(i).classValue() && (int)c != (int)train.instance(i).classValue() && (int)(c + 1.0) != (int)train.instance(i).classValue()) {
                        System.out.println(" ERROR MISMATCH IN CLASS " + s + " from instance " + i + " ucr =" + (int)c + " mine =" + (int)train.instance(i).classValue());
                        System.exit(0);
                    }
                    for (j = 1; j < train.numAttributes(); ++j) {
                        v = Double.valueOf(split[j]);
                        newTrain.writeString(v + ",");
                    }
                    if (first <= 0) {
                        newTrain.writeString((int)train.instance(i).classValue() + "\n");
                        continue;
                    }
                    newTrain.writeString((int)(train.instance(i).classValue() + 1.0) + "\n");
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Error problem " + s + " instance =" + i + " length =" + split.length + " val =" + split[0]);
                    System.exit(0);
                }
            }
            for (i = 0; i < testSize; ++i) {
                line = testF.readLine();
                line = line.trim();
                split = line.split("/s+");
                try {
                    double c = Double.valueOf(split[0]);
                    if ((int)(c - 1.0) != (int)test.instance(i).classValue() && (int)c != (int)test.instance(i).classValue() && (int)(c + 1.0) != (int)test.instance(i).classValue()) {
                        System.out.println(" ERROR MISMATCH IN CLASS " + s + " from instance " + i + " ucr =" + (int)c + " mine =" + (int)test.instance(i).classValue());
                        System.exit(0);
                    }
                    for (j = 1; j < test.numAttributes(); ++j) {
                        v = Double.valueOf(split[j]);
                        newTest.writeString(v + ",");
                    }
                    if (first <= 0) {
                        newTest.writeString((int)test.instance(i).classValue() + "\n");
                        continue;
                    }
                    newTest.writeString((int)(test.instance(i).classValue() + 1.0) + "\n");
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Error problem " + s + " instance =" + i + " length =" + split.length + " val =" + split[0]);
                    System.exit(0);
                }
            }
        }
    }

    public static void listNotNormalisedList() throws Exception {
        TreeSet<String> notNormed = new TreeSet<String>();
        DecimalFormat df = new DecimalFormat("###.######");
        block0: for (String s : fileNames) {
            double stdev;
            Instances train = ClassifierTools.loadData(problemPath + s + "/" + s + "_TRAIN");
            Instances test = ClassifierTools.loadData(problemPath + s + "/" + s + "_TEST");
            SummaryStats ss = new SummaryStats();
            train = ss.process(train);
            test = ss.process(test);
            int i = 1;
            for (Instance ins : train) {
                stdev = ins.value(1) * ins.value(1);
                if (!(Math.abs(ins.value(0)) > 0.01) && !(Math.abs(1.0 - stdev) > 0.01)) continue;
                System.out.println(" Not normalised train series =" + s + " index " + i + " mean = " + df.format(ins.value(0)) + " var =" + df.format(stdev));
                notNormed.add(s);
                break;
            }
            for (Instance ins : test) {
                stdev = ins.value(1) * ins.value(1);
                if (!(Math.abs(ins.value(0)) > 0.01) && !(Math.abs(1.0 - stdev) > 0.01)) continue;
                System.out.println(" Not normalised test series =" + s + " index " + i + " mean = " + df.format(ins.value(0)) + " var =" + df.format(stdev));
                notNormed.add(s);
                continue block0;
            }
        }
        System.out.print("String[] notNormalised={");
        for (String s : notNormed) {
            System.out.print("\"" + s + "\",");
        }
        System.out.println("}");
        System.out.println("TOTAL NOT NORMED =" + notNormed.size());
    }

    public static void dataDescription(String[] fileNames) {
        OutFile f = new OutFile(problemPath + "DataDimensions.csv");
        Object[] all = new MetaData[fileNames.length];
        TreeSet<String> nm = new TreeSet<String>();
        nm.addAll(Arrays.asList(notNormalised));
        try {
            for (int i = 0; i < fileNames.length; ++i) {
                Instances test = ClassifierTools.loadData(problemPath + fileNames[i] + "/" + fileNames[i] + "_TEST");
                Instances train = ClassifierTools.loadData(problemPath + fileNames[i] + "/" + fileNames[i] + "_TRAIN");
                Instances allData = new Instances(test);
                for (int j = 0; j < train.numInstances(); ++j) {
                    allData.add(train.instance(j));
                }
                boolean normalised = true;
                if (nm.contains(fileNames[i])) {
                    normalised = false;
                }
                int[] classCounts = new int[allData.numClasses() * 2];
                for (Instance ins : train) {
                    int n = (int)ins.classValue();
                    classCounts[n] = classCounts[n] + 1;
                }
                for (Instance ins : test) {
                    int n = allData.numClasses() + (int)ins.classValue();
                    classCounts[n] = classCounts[n] + 1;
                }
                all[i] = new MetaData(fileNames[i], train.numInstances(), test.numInstances(), test.numAttributes() - 1, test.numClasses(), classCounts, normalised);
                f.writeLine(((MetaData)all[i]).toString());
            }
        }
        catch (Exception e) {
            System.out.println(" ERRROR" + e);
        }
        Arrays.sort(all);
        f = new OutFile(dropboxPath + "DataDimensionsBySeriesLength.csv");
        for (Object m : all) {
            f.writeLine(((MetaData)m).toString());
        }
        Arrays.sort(all, new MetaData.CompareByTrain());
        f = new OutFile(dropboxPath + "DataDimensionsByTrainSize.csv");
        for (Object m : all) {
            f.writeLine(((MetaData)m).toString());
        }
        Arrays.sort(all, new MetaData.CompareByClasses());
        f = new OutFile(dropboxPath + "DataDimensionsByNosClasses.csv");
        for (Object m : all) {
            f.writeLine(((MetaData)m).toString());
        }
        Arrays.sort(all, new MetaData.CompareByTotalSize());
        f = new OutFile(dropboxPath + "DataDimensionsByTotalSize.csv");
        for (Object m : all) {
            f.writeLine(((MetaData)m).toString());
        }
    }

    public static void dataDescriptionDataNotSplit(String[] fileNames) {
        OutFile f = new OutFile(problemPath + "DataDimensions.csv");
        f.writeLine("problem,numinstances,numAttributes,numClasses,classDistribution");
        try {
            for (int i = 0; i < fileNames.length; ++i) {
                Instances allData = ClassifierTools.loadData(problemPath + fileNames[i] + "/" + fileNames[i]);
                int[] classCounts = new int[allData.numClasses()];
                for (Instance ins : allData) {
                    int n = (int)ins.classValue();
                    classCounts[n] = classCounts[n] + 1;
                }
                f.writeString(fileNames[i] + "," + allData.numInstances() + "," + (allData.numAttributes() - 1) + "," + allData.numClasses());
                for (Object c : (Object)classCounts) {
                    f.writeString("," + (double)c / (double)allData.numInstances());
                }
                f.writeString("\n");
            }
        }
        catch (Exception e) {
            System.out.println(" ERRROR" + e);
        }
    }

    public static void makeTable(String means, String stdDev, String outfile) {
        InFile m = new InFile(means);
        InFile sd = new InFile(stdDev);
        int lines = m.countLines();
        m = new InFile(means);
        String s = m.readLine();
        int columns = s.split(",").length;
        m = new InFile(means);
        OutFile out = new OutFile(outfile);
        DecimalFormat meanF = new DecimalFormat(".###");
        DecimalFormat sdF = new DecimalFormat(".##");
    }

    public static void main(String[] args) throws Exception {
        DataSets.dataDescription(fileNames);
        System.exit(0);
        DataSets.listNotNormalisedList();
        DataSets.processUCRData();
        Instances train = ClassifierTools.loadData(problemPath + "wafer/wafer_TRAIN");
        Instances test = ClassifierTools.loadData(problemPath + "wafer/wafer_TEST");
        for (String s : fileNames) {
            Instances all = ClassifierTools.loadData(problemPath + s + "/" + s);
            train = ClassifierTools.loadData(problemPath + s + "/" + s + "_TRAIN");
            test = ClassifierTools.loadData(problemPath + s + "/" + s + "_TEST");
            System.out.println(s + " load ok ");
        }
        System.exit(0);
    }

    public static void renameClasses() {
    }

    static {
        path = beastPath = "//cmptscsvr.cmp.uea.ac.uk/ueatsc/Data/";
        problemPath = path + "/TSC Problems/";
        resultsPath = path + "Results/";
        uciPath = path + "UCIContinuous";
        fileNames = new String[]{"Adiac", "ArrowHead", "Beef", "BeetleFly", "BirdChicken", "Car", "CBF", "ChlorineConcentration", "CinCECGtorso", "Coffee", "Computers", "CricketX", "CricketY", "CricketZ", "DiatomSizeReduction", "DistalPhalanxOutlineCorrect", "DistalPhalanxOutlineAgeGroup", "DistalPhalanxTW", "Earthquakes", "ECG200", "ECG5000", "ECGFiveDays", "ElectricDevices", "FaceAll", "FaceFour", "FacesUCR", "FiftyWords", "Fish", "FordA", "FordB", "GunPoint", "Ham", "HandOutlines", "Haptics", "Herring", "InlineSkate", "InsectWingbeatSound", "ItalyPowerDemand", "LargeKitchenAppliances", "Lightning2", "Lightning7", "Mallat", "Meat", "MedicalImages", "MiddlePhalanxOutlineCorrect", "MiddlePhalanxOutlineAgeGroup", "MiddlePhalanxTW", "MoteStrain", "NonInvasiveFetalECGThorax1", "NonInvasiveFetalECGThorax2", "OliveOil", "OSULeaf", "PhalangesOutlinesCorrect", "Phoneme", "Plane", "ProximalPhalanxOutlineCorrect", "ProximalPhalanxOutlineAgeGroup", "ProximalPhalanxTW", "RefrigerationDevices", "ScreenType", "ShapeletSim", "ShapesAll", "SmallKitchenAppliances", "SonyAIBORobotSurface1", "SonyAIBORobotSurface2", "StarlightCurves", "Strawberry", "SwedishLeaf", "Symbols", "SyntheticControl", "ToeSegmentation1", "ToeSegmentation2", "Trace", "TwoLeadECG", "TwoPatterns", "UWaveGestureLibraryX", "UWaveGestureLibraryY", "UWaveGestureLibraryZ", "UWaveGestureLibraryAll", "Wafer", "Wine", "WordSynonyms", "Worms", "WormsTwoClass", "Yoga"};
        fiveSplits = new String[][]{{"Adiac", "ArrowHead", "Beef", "BeetleFly", "BirdChicken", "Car", "CBF", "ChlorineConcentration", "CinCECGtorso", "Coffee", "Computers", "CricketX", "CricketY", "CricketZ", "DiatomSizeReduction", "DistalPhalanxOutlineCorrect", "DistalPhalanxOutlineAgeGroup", "DistalPhalanxTW", "Earthquakes"}, {"ECG200", "ECG5000", "ECGFiveDays", "FaceFour", "FacesUCR", "FiftyWords", "Fish", "GunPoint", "Ham", "Haptics", "Herring", "ItalyPowerDemand", "LargeKitchenAppliances", "Lightning2", "Lightning7", "Mallat", "Meat", "MedicalImages"}, {"MiddlePhalanxOutlineCorrect", "MiddlePhalanxOutlineAgeGroup", "MiddlePhalanxTW", "MoteStrain", "OliveOil", "OSULeaf", "Plane", "ProximalPhalanxOutlineCorrect", "ProximalPhalanxOutlineAgeGroup", "ProximalPhalanxTW", "RefrigerationDevices", "ScreenType", "ShapeletSim", "SmallKitchenAppliances", "SonyAIBORobotSurface1", "SonyAIBORobotSurface2", "Strawberry", "SwedishLeaf", "Symbols", "SyntheticControl"}, {"ToeSegmentation1", "ToeSegmentation2", "Trace", "TwoLeadECG", "TwoPatterns", "UWaveGestureLibraryX", "UWaveGestureLibraryY", "UWaveGestureLibraryZ", "Wafer", "Wine", "WordSynonyms", "Worms", "WormsTwoClass", "Yoga", "InlineSkate", "InsectWingbeatSound", "FaceAll", "PhalangesOutlinesCorrect", "Phoneme", "ShapesAll"}, {"ElectricDevices", "FordA", "FordB", "HandOutlines", "NonInvasiveFetalECGThorax1", "NonInvasiveFetalECGThorax2", "StarlightCurves", "UWaveGestureLibraryAll"}};
        ucrNames = new String[]{"Adiac", "Beef", "Car", "CBF", "ChlorineConcentration", "CinCECGtorso", "Coffee", "CricketX", "CricketY", "CricketZ", "DiatomSizeReduction", "ECGFiveDays", "FaceAll", "FaceFour", "FacesUCR", "FiftyWords", "Fish", "GunPoint", "Haptics", "InlineSkate", "ItalyPowerDemand", "Lightning2", "Lightning7", "Mallat", "MedicalImages", "MoteStrain", "NonInvasiveFetalECGThorax1", "NonInvasiveFetalECGThorax2", "OliveOil", "OSULeaf", "Plane", "SonyAIBORobotSurface1", "SonyAIBORobotSurface2", "StarLightCurves", "SwedishLeaf", "Symbols", "SyntheticControl", "Trace", "TwoLeadECG", "TwoPatterns", "UWaveGestureLibraryX", "UWaveGestureLibraryY", "UWaveGestureLibraryZ", "Wafer", "WordSynonyms", "Yoga"};
        ucrSmall = new String[]{"Beef", "Car", "Coffee", "Cricket_X", "Cricket_Y", "Cricket_Z", "DiatomSizeReduction", "fish", "GunPoint", "ItalyPowerDemand", "MoteStrain", "OliveOil", "Plane", "SonyAIBORobotSurface", "SonyAIBORobotSurfaceII", "SyntheticControl", "Trace", "TwoLeadECG"};
        spectral = new String[]{"Beef", "Coffee", "Ham", "Meat", "OliveOil", "Strawberry", "Wine"};
        smallTSCProblems = new String[]{"Beef", "BeetleFly", "BirdChicken", "FaceFour", "Plane", "FacesUCR"};
        largeProblems = new String[]{"HeartbeatBIDMC", "MNIST"};
        fastShapeletProblems = new String[]{"ItalyPowerDemand", "MoteStrain", "SonyAIBORobotSurfaceII", "SonyAIBORobotSurface", "Beef", "GunPoint", "TwoLeadECG", "Adiac", "CBF", "ChlorineConcentration", "Coffee", "DiatomSizeReduction", "ECGFiveDays", "FaceFour", "FacesUCR", "fish", "Lighting2", "Lighting7", "FaceAll", "MALLAT", "MedicalImages", "OliveOil", "OSULeaf", "SwedishLeaf", "Symbols", "SyntheticControl", "Trace", "wafer", "yoga", "FaceAll", "TwoPatterns", "CinC_ECG_torso"};
        marteau09stiffness = new String[]{"SyntheticControl", "GunPoint", "CBF", "FaceAll", "OSULeaf", "SwedishLeaf", "fiftywords", "Trace", "TwoPatterns", "wafer", "FaceFour", "Lightning2", "Lightning7", "ECG200", "Adiac", "yoga", "fish", "Coffee", "OliveOil", "Beef"};
        stefan13movesplit = new String[]{"Coffee", "CBF", "ECG200", "SyntheticControl", "GunPoint", "FaceFour", "Lightning7", "Trace", "Adiac", "Beef", "Lightning2", "OliveOil", "OSULeaf", "SwedishLeaf", "fish", "FaceAll", "fiftywords", "TwoPatterns", "wafer", "yoga"};
        testSizes = new int[]{391, 175, 30, 20, 20, 60, 900, 3840, 1380, 28, 250, 390, 390, 390, 306, 276, 139, 139, 139, 100, 4500, 861, 7711, 1690, 88, 2050, 455, 175, 1320, 810, 150, 105, 370, 308, 64, 550, 1980, 1029, 375, 61, 73, 2345, 60, 760, 291, 154, 154, 1252, 1965, 1965, 30, 242, 858, 1896, 105, 291, 205, 205, 375, 375, 180, 600, 375, 601, 953, 8236, 370, 625, 995, 300, 228, 130, 100, 1139, 4000, 3582, 3582, 3582, 3582, 6164, 54, 638, 77, 77, 3000};
        uciFileNames = new String[]{"abalone", "banana", "cancer", "clouds", "concentric", "diabetes", "ecoli", "german", "glass2", "glass6", "haberman", "heart", "ionosphere", "liver", "magic", "pendigitis", "phoneme", "ringnorm", "satimage", "segment", "sonar", "thyroid", "twonorm", "vehicle", "vowel", "waveform", "wdbc", "wins", "yeast"};
        UCIContinuousFileNames = new String[]{"abalone", "acute-inflammation", "acute-nephritis", "adult", "annealing", "arrhythmia", "audiology-std", "balance-scale", "balloons", "bank", "blood", "breast-cancer", "breast-cancer-wisc", "breast-cancer-wisc-diag", "breast-cancer-wisc-prog", "breast-tissue", "car", "cardiotocography-10clases", "cardiotocography-3clases", "chess-krvk", "chess-krvkp", "congressional-voting", "conn-bench-sonar-mines-rocks", "conn-bench-vowel-deterding", "connect-4", "contrac", "credit-approval", "cylinder-bands", "dermatology", "echocardiogram", "ecoli", "energy-y1", "energy-y2", "fertility", "flags", "glass", "haberman-survival", "hayes-roth", "heart-cleveland", "heart-hungarian", "heart-switzerland", "heart-va", "hepatitis", "hill-valley", "horse-colic", "ilpd-indian-liver", "image-segmentation", "ionosphere", "iris", "led-display", "lenses", "letter", "libras", "low-res-spect", "lung-cancer", "lymphography", "magic", "mammographic", "miniboone", "molec-biol-promoter", "molec-biol-splice", "monks-1", "monks-2", "monks-3", "mushroom", "musk-1", "musk-2", "nursery", "oocytes_merluccius_nucleus_4d", "oocytes_merluccius_states_2f", "oocytes_trisopterus_nucleus_2f", "oocytes_trisopterus_states_5b", "optical", "ozone", "page-blocks", "parkinsons", "pendigits", "pima", "pittsburg-bridges-MATERIAL", "pittsburg-bridges-REL-L", "pittsburg-bridges-SPAN", "pittsburg-bridges-T-OR-D", "pittsburg-bridges-TYPE", "planning", "plant-margin", "plant-shape", "plant-texture", "post-operative", "primary-tumor", "ringnorm", "seeds", "semeion", "soybean", "spambase", "spect", "spectf", "statlog-australian-credit", "statlog-german-credit", "statlog-heart", "statlog-image", "statlog-landsat", "statlog-shuttle", "statlog-vehicle", "steel-plates", "synthetic-control", "teaching", "thyroid", "tic-tac-toe", "titanic", "trains", "twonorm", "vertebral-column-2clases", "vertebral-column-3clases", "wall-following", "waveform", "waveform-noise", "wine", "wine-quality-red", "wine-quality-white", "yeast", "zoo"};
        datasetsForDAMI2014_Lines = new String[]{"Adiac", "ArrowHead", "Beef", "BeetleFly", "BirdChicken", "Car", "CBF", "ChlorineConcentration", "CinC_ECG_torso", "Coffee", "Computers", "Cricket_X", "Cricket_Y", "Cricket_Z", "DiatomSizeReduction", "DistalPhalanxOutlineCorrect", "DistalPhalanxOutlineAgeGroup", "DistalPhalanxTW", "Earthquakes", "ECGFiveDays", "ElectricDevices", "FaceAll", "FaceFour", "FacesUCR", "fiftywords", "fish", "FordA", "FordB", "GunPoint", "HandOutlines", "Haptics", "Herring", "InlineSkate", "ItalyPowerDemand", "LargeKitchenAppliances", "Lightning2", "Lightning7", "MALLAT", "MedicalImages", "MiddlePhalanxOutlineCorrect", "MiddlePhalanxOutlineAgeGroup", "MiddlePhalanxTW", "MoteStrain", "NonInvasiveFetalECG_Thorax1", "NonInvasiveFetalECG_Thorax2", "OliveOil", "OSULeaf", "PhalangesOutlinesCorrect", "Plane", "ProximalPhalanxOutlineCorrect", "ProximalPhalanxOutlineAgeGroup", "ProximalPhalanxTW", "RefrigerationDevices", "ScreenType", "ShapeletSim", "ShapesAll", "SmallKitchenAppliances", "SonyAIBORobotSurface", "SonyAIBORobotSurfaceII", "StarLightCurves", "SwedishLeaf", "Symbols", "SyntheticControl", "ToeSegmentation1", "ToeSegmentation2", "Trace", "TwoLeadECG", "TwoPatterns", "UWaveGestureLibrary_X", "UWaveGestureLibrary_Y", "UWaveGestureLibrary_Z", "wafer", "WordSynonyms", "yoga"};
        notNormalised = new String[]{"ArrowHead", "Beef", "BeetleFly", "BirdChicken", "Coffee", "Computers", "Cricket_X", "Cricket_Y", "Cricket_Z", "DistalPhalanxOutlineAgeGroup", "DistalPhalanxOutlineCorrect", "DistalPhalanxTW", "ECG200", "Earthquakes", "ElectricDevices", "FordA", "FordB", "Ham", "Herring", "LargeKitchenAppliances", "Meat", "MiddlePhalanxOutlineAgeGroup", "MiddlePhalanxOutlineCorrect", "MiddlePhalanxTW", "OliveOil", "PhalangesOutlinesCorrect", "Plane", "ProximalPhalanxOutlineAgeGroup", "ProximalPhalanxOutlineCorrect", "ProximalPhalanxTW", "RefrigerationDevices", "ScreenType", "ShapeletSim", "ShapesAll", "SmallKitchenAppliances", "Strawberry", "ToeSegmentation1", "ToeSegmentation2", "UWaveGestureLibraryAll", "UWaveGestureLibrary_Z", "Wine", "Worms", "WormsTwoClass", "fish"};
    }

    public static class MetaData
    implements Comparable<MetaData> {
        String fileName;
        int trainSetSize;
        int testSetSize;
        int seriesLength;
        int nosClasses;
        int[] classDistribution;
        boolean normalised = true;

        public MetaData(String n, int t1, int t2, int s, int c, int[] dist, boolean norm) {
            this.fileName = n;
            this.trainSetSize = t1;
            this.testSetSize = t2;
            this.seriesLength = s;
            this.nosClasses = c;
            this.classDistribution = dist;
            this.normalised = norm;
        }

        public String toString() {
            String str = this.fileName + "," + this.trainSetSize + "," + this.testSetSize + "," + this.seriesLength + "," + this.nosClasses + "," + this.normalised;
            for (int i : this.classDistribution) {
                str = str + "," + i;
            }
            return str;
        }

        @Override
        public int compareTo(MetaData o) {
            return this.seriesLength - o.seriesLength;
        }

        public static class CompareByTotalSize
        implements Comparator<MetaData> {
            @Override
            public int compare(MetaData a, MetaData b) {
                return a.seriesLength * a.trainSetSize - b.seriesLength * b.trainSetSize;
            }
        }

        public static class CompareByClasses
        implements Comparator<MetaData> {
            @Override
            public int compare(MetaData a, MetaData b) {
                return a.nosClasses - b.nosClasses;
            }
        }

        public static class CompareByTrainSetSize
        implements Comparator<MetaData> {
            @Override
            public int compare(MetaData a, MetaData b) {
                return a.trainSetSize - b.trainSetSize;
            }
        }

        public static class CompareByTrain
        implements Comparator<MetaData> {
            @Override
            public int compare(MetaData a, MetaData b) {
                return a.trainSetSize - b.trainSetSize;
            }
        }
    }
}

