/*
 * Decompiled with CFR 0.152.
 */
package ResultsProcessing;

import ResultsProcessing.CreateCriticalDifference;
import ResultsProcessing.CreatePairwiseScatter;
import ResultsProcessing.CreateTexasSharpShooter;
import ResultsProcessing.ResultColumn;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ResultTable {
    List<ResultColumn> columns;
    List<String> columnNames;
    Map<String, List<OptionalDouble>> data = new TreeMap<String, List<OptionalDouble>>();
    int numColumns = 0;

    public List<ResultColumn> getColumns() {
        return this.columns;
    }

    public ResultTable() {
        this.columnNames = new LinkedList<String>();
        this.columns = new LinkedList<ResultColumn>();
    }

    public ResultTable(List<ResultColumn> cols) {
        this();
        this.numColumns = 0;
        for (ResultColumn col : cols) {
            this.addColumn(col);
        }
    }

    public ResultTable(String fileName) throws IOException {
        this();
        Path path = Paths.get(fileName, new String[0]);
        Files.lines(path).forEachOrdered(this::processLine);
        if (this.columnNames.isEmpty()) {
            for (int i = 0; i < this.numColumns; ++i) {
                this.columnNames.add(String.valueOf(i));
            }
        }
        this.columns = this.createColumns();
    }

    public static List<ResultColumn> createColumns(String[] columnNames, String[] datasetNames, double[][] results) {
        LinkedList<ResultColumn> columns = new LinkedList<ResultColumn>();
        for (int index = 0; index < results.length; ++index) {
            HashMap<String, Double> rc = new HashMap<String, Double>();
            for (int i = 0; i < results[index].length; ++i) {
                if (!(results[index][i] >= 0.0)) continue;
                rc.put(datasetNames[i], results[index][i]);
            }
            columns.add(new ResultColumn(columnNames[index], rc));
        }
        return columns;
    }

    private List<ResultColumn> createColumns() {
        return this.createColumns(false);
    }

    private List<ResultColumn> createErrorColumns() {
        return this.createColumns(true);
    }

    private List<ResultColumn> createColumns(boolean makeError) {
        ArrayList protoColumns = new ArrayList(this.numColumns);
        for (int i = 0; i < this.numColumns; ++i) {
            protoColumns.add(new HashMap());
        }
        for (Map.Entry<String, List<OptionalDouble>> entry : this.data.entrySet()) {
            int index = 0;
            List<OptionalDouble> vals = entry.getValue();
            for (OptionalDouble val : vals) {
                if (val.isPresent()) {
                    double putVal = makeError ? 1.0 - val.getAsDouble() : val.getAsDouble();
                    ((Map)protoColumns.get(index)).put(entry.getKey(), putVal);
                }
                ++index;
            }
        }
        LinkedList<ResultColumn> cols = new LinkedList<ResultColumn>();
        for (int index = 0; index < protoColumns.size(); ++index) {
            cols.add(new ResultColumn(this.columnNames.get(index), (Map)protoColumns.get(index)));
        }
        return cols;
    }

    private void appendMissingValues() {
        for (Map.Entry<String, List<OptionalDouble>> entry : this.data.entrySet()) {
            List<OptionalDouble> list = entry.getValue();
            if (this.numColumns <= list.size()) continue;
            list.add(OptionalDouble.empty());
        }
    }

    public void addColumn(ResultColumn col) {
        this.columns.add(col);
        this.columnNames.add(col.name);
        for (Map.Entry<String, Double> entry : col.getEntrySet()) {
            List list = this.data.getOrDefault(entry.getKey(), new LinkedList());
            this.data.putIfAbsent(entry.getKey(), list);
            while (this.numColumns > list.size()) {
                list.add(OptionalDouble.empty());
            }
            list.add(OptionalDouble.of(entry.getValue()));
        }
        ++this.numColumns;
        this.appendMissingValues();
    }

    public Optional<ResultColumn> getColumn(String colName) {
        for (ResultColumn rc : this.columns) {
            if (!rc.name.equalsIgnoreCase(colName)) continue;
            return Optional.of(rc);
        }
        return Optional.empty();
    }

    void processLine(String line) {
        String[] lineData = line.split(",");
        if (this.data.isEmpty() && (lineData[0].isEmpty() || lineData[0].contains("data"))) {
            for (int i = 1; i < lineData.length; ++i) {
                this.columnNames.add(lineData[i]);
            }
        } else {
            LinkedList<OptionalDouble> accs = new LinkedList<OptionalDouble>();
            for (int i = 1; i < lineData.length; ++i) {
                if (lineData[i].isEmpty() || lineData[i].contains("#N/A")) {
                    accs.add(OptionalDouble.empty());
                    continue;
                }
                accs.add(OptionalDouble.of(Double.parseDouble(lineData[i])));
                this.numColumns = Integer.max(this.numColumns, lineData.length - 1);
            }
            this.data.put(lineData[0], accs);
        }
        this.appendMissingValues();
    }

    public ResultTable createTableOfErrors() {
        return new ResultTable(this.createErrorColumns());
    }

    public ResultColumn averageTable(String newColumnName) {
        Map<String, Double> averageTable = this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().filter(OptionalDouble::isPresent).mapToDouble(OptionalDouble::getAsDouble).average())).entrySet().stream().filter(e -> ((OptionalDouble)e.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((OptionalDouble)e.getValue()).getAsDouble()));
        return new ResultColumn(newColumnName, averageTable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("datasets");
        for (String string : this.columnNames) {
            sb.append(",").append(string);
        }
        sb.append("\n");
        for (Map.Entry entry : this.data.entrySet()) {
            List list = (List)entry.getValue();
            sb.append((String)entry.getKey()).append(",");
            for (OptionalDouble val : list) {
                val.ifPresent(sb::append);
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toStringValues(boolean includeDatasets) {
        StringBuilder sb = new StringBuilder();
        if (includeDatasets) {
            sb.append("datasets");
            for (String string : this.columnNames) {
                sb.append(",").append(string);
            }
            sb.append("\n");
        }
        for (Map.Entry entry : this.data.entrySet()) {
            StringBuilder lineBuilder = new StringBuilder();
            if (includeDatasets) {
                lineBuilder.append((String)entry.getKey()).append(",");
            }
            List list = (List)entry.getValue();
            int appends = 0;
            for (OptionalDouble val : list) {
                if (!val.isPresent()) continue;
                ++appends;
                lineBuilder.append(val.getAsDouble()).append(",");
            }
            if (appends != this.columnNames.size()) continue;
            lineBuilder.deleteCharAt(lineBuilder.length() - 1);
            lineBuilder.append("\n");
            sb.append(lineBuilder.toString());
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        ResultTable.useCase3();
    }

    public static void useCase1() throws IOException {
        ResultTable shapeletFolds = new ResultTable("..\\..\\Dropbox\\Big TSC Bake Off\\New Results\\shapelet\\ST.csv");
        ResultColumn stAverage = shapeletFolds.averageTable("ST_Mean");
        ResultTable fsFolds = new ResultTable("..\\..\\Dropbox\\Big TSC Bake Off\\New Results\\shapelet\\FS.csv");
        ResultColumn fsAverage = fsFolds.averageTable("FS_Mean");
        ResultTable lsFolds = new ResultTable("..\\..\\Dropbox\\Big TSC Bake Off\\New Results\\shapelet\\LS.csv");
        ResultColumn lsAverage = lsFolds.averageTable("LS_Mean");
        ResultTable rs = new ResultTable(Arrays.asList(stAverage, fsAverage, lsAverage));
        CreateCriticalDifference cd = new CreateCriticalDifference(rs);
        cd.createDiagram("CD_1");
        ResultTable rt = new ResultTable(Arrays.asList(stAverage, lsAverage));
        CreatePairwiseScatter ps = new CreatePairwiseScatter(rt);
        ps.createDiagram("ST compared with LS");
    }

    public static void useCase2() {
        String[] cols = new String[]{"ST", "BOSS", "DTW"};
        String[] datasets = new String[]{"Adiac", "ItalyPowerDemand", "StarlightCurves"};
        double[][] dat = new double[][]{{1.0, 0.8, 0.9}, {0.9, 0.9, 0.7}, {0.8, 0.8, 0.8}};
        ResultTable rt = new ResultTable(ResultTable.createColumns(cols, datasets, dat));
        System.out.println(rt);
    }

    public static void useCase3() {
        String[] cols = new String[]{"ST_train", "ST_test", "LS_train", "LS_test"};
        String[] datasets = new String[]{"Adiac", "ItalyPowerDemand", "StarlightCurves"};
        double[][] dat = new double[][]{{1.0, 0.8, 0.9}, {0.9, 0.9, 0.7}, {0.8, 0.8, 0.8}, {0.8, 0.8, 0.9}};
        List<ResultColumn> rls = ResultTable.createColumns(cols, datasets, dat);
        CreateTexasSharpShooter tss = new CreateTexasSharpShooter(rls.get(0), rls.get(1), rls.get(2), rls.get(3));
        tss.createDiagram("ST vs. LS");
    }
}

