/*
 * Decompiled with CFR 0.152.
 */
package ResultsProcessing;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ResultColumn {
    String name;
    Map<String, Double> data = new LinkedHashMap<String, Double>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    ResultColumn() {
    }

    public ResultColumn(String filename) throws IOException {
        this();
        Path path = Paths.get(filename, new String[0]);
        this.name = path.getFileName().toString();
        this.name = this.name.substring(0, this.name.length() - 4);
        Files.lines(path).forEachOrdered(this::processLine);
    }

    public ResultColumn(String nme, Map<String, Double> input) {
        this();
        this.name = nme;
        this.data.putAll(input);
    }

    void processLine(String line) {
        String[] lineData = line.split(",");
        this.data.put(lineData[0], Double.parseDouble(lineData[1]));
    }

    public Set<Map.Entry<String, Double>> getEntrySet() {
        return this.data.entrySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dataset,").append(this.name).append("\n");
        for (Map.Entry<String, Double> entry : this.data.entrySet()) {
            sb.append(entry.getKey()).append(",");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        ResultColumn rc = new ResultColumn("..\\..\\TabuSearch\\day_tabu_search.csv");
        System.out.println(rc);
    }

    String toStringValues() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Double> entry : this.data.entrySet()) {
            sb.append(entry.getValue());
            sb.append(" ");
        }
        return sb.toString();
    }

    public double[] toDoubleArray() {
        return this.getEntrySet().stream().mapToDouble(Map.Entry::getValue).toArray();
    }
}

