/*
 * Decompiled with CFR 0.152.
 */
package ResultsProcessing;

import java.nio.file.Paths;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactory;
import matlabcontrol.MatlabProxyFactoryOptions;

public class MatlabController {
    private static MatlabController Instance;
    final MatlabProxyFactory factory;
    Optional<MatlabProxy> proxy = Optional.empty();

    public static MatlabController getInstance() {
        if (Instance == null) {
            Instance = new MatlabController();
        }
        return Instance;
    }

    protected MatlabController() {
        MatlabProxyFactoryOptions options = new MatlabProxyFactoryOptions.Builder().setHidden(true).build();
        this.factory = new MatlabProxyFactory(options);
        try {
            this.connectMatlab();
        }
        catch (MatlabConnectionException ex) {
            Logger.getLogger(MatlabController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setProxy(MatlabProxy mp) {
        this.proxy = Optional.of(mp);
        mp.addDisconnectionListener(e -> this.closeProxy());
        this.eval("cd " + Paths.get("", new String[0]).toAbsolutePath());
    }

    private void closeProxy() {
        this.proxy = Optional.empty();
    }

    void connectMatlab() throws MatlabConnectionException {
        this.setProxy(this.factory.getProxy());
    }

    public void discconnectMatlab() {
        if (this.proxy.isPresent()) {
            this.proxy.get().disconnect();
        }
    }

    public void eval(String evalString) {
        if (this.proxy.isPresent()) {
            try {
                this.proxy.get().eval(evalString);
            }
            catch (MatlabInvocationException ex) {
                Logger.getLogger(MatlabController.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            System.out.println("not present");
        }
    }
}

