/*
 * Decompiled with CFR 0.152.
 */
package ResultsProcessing;

import ResultsProcessing.MatlabController;
import ResultsProcessing.MatlabDiagram;
import ResultsProcessing.ResultColumn;
import java.util.Arrays;

public class CreateTexasSharpShooter
implements MatlabDiagram {
    double[] expectedGainRatio;
    double[] actualGainRatio;
    String[] columnNames;

    public CreateTexasSharpShooter(ResultColumn trainAcc1, ResultColumn testAcc1, ResultColumn trainAcc2, ResultColumn testAcc2) {
        double[] trainAccuracy1 = trainAcc1.toDoubleArray();
        double[] trainAccuracy2 = trainAcc2.toDoubleArray();
        double[] testAccuracy1 = testAcc1.toDoubleArray();
        double[] testAccuracy2 = testAcc2.toDoubleArray();
        this.expectedGainRatio = new double[trainAccuracy1.length];
        this.actualGainRatio = new double[testAccuracy1.length];
        for (int i = 0; i < trainAccuracy1.length; ++i) {
            this.expectedGainRatio[i] = trainAccuracy1[i] / trainAccuracy2[i];
            this.actualGainRatio[i] = testAccuracy1[i] / testAccuracy2[i];
        }
    }

    @Override
    public void createDiagram(String name) {
        MatlabController proxy = MatlabController.getInstance();
        proxy.eval("x = " + Arrays.toString(this.expectedGainRatio) + ";");
        proxy.eval("y = " + Arrays.toString(this.actualGainRatio) + ";");
        proxy.eval("texassharpshooter('" + name + "',x,y)");
    }
}

