/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sizeof.test;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sourceforge.sizeof.SizeOf;
import net.sourceforge.sizeof.test.Dummy;

public class TestSizeOf {
    public static void main(String[] args) throws FileNotFoundException {
        TestSizeOf.print("Starting test...");
        SizeOf.skipStaticField(true);
        SizeOf.skipFinalField(true);
        SizeOf.skipFlyweightObject(true);
        SizeOf.setLogOutputStream(new FileOutputStream("log.txt"));
        Integer x = 1;
        int _int = 0;
        long _long = 0L;
        Dummy dummy = new Dummy();
        ArrayList<Integer> aList = new ArrayList<Integer>();
        Object[] oArray = new Object[200];
        dummy.dummy = dummy;
        dummy.dummy2 = dummy;
        TestSizeOf.print("simple obj: \t", SizeOf.deepSizeOf(dummy));
        TestSizeOf.print("int: \t\t", SizeOf.sizeOf(_int));
        TestSizeOf.print("long: \t\t", SizeOf.sizeOf(_long));
        TestSizeOf.print("char: \t\t", SizeOf.sizeOf(Character.valueOf('a')));
        TestSizeOf.print("double: \t\t", SizeOf.deepSizeOf(0.3));
        TestSizeOf.print("boolean: \t\t", SizeOf.sizeOf(true));
        TestSizeOf.print("Integer: \t\t", SizeOf.sizeOf(2));
        TestSizeOf.print("empty string: \t", SizeOf.sizeOf(""));
        TestSizeOf.print("not empty string: \t", SizeOf.sizeOf("aaaa"));
        TestSizeOf.print("not empty string: \t", SizeOf.sizeOf("aaaaaaaa"));
        TestSizeOf.print("simple obj: \t", SizeOf.sizeOf(dummy));
        TestSizeOf.print("simple obj: \t", SizeOf.deepSizeOf(dummy));
        TestSizeOf.print("empty list: \t", SizeOf.sizeOf(aList));
        int i = 1;
        while (i < 10) {
            aList.add(i);
            ++i;
        }
        TestSizeOf.print("10 list: \t", SizeOf.sizeOf(aList));
        i = 11;
        while (i < 20) {
            aList.add(i);
            ++i;
        }
        TestSizeOf.print("20 list no static: \t", SizeOf.sizeOf(aList));
        TestSizeOf.print("1000 o arr: \t", SizeOf.deepSizeOf(oArray));
    }

    public static void print(String msg, long n) {
        TestSizeOf.print(String.valueOf(msg) + SizeOf.humanReadable(n));
    }

    public static void print(String msg) {
        System.out.println(msg);
    }

    public static void heinz() throws IllegalArgumentException, IllegalAccessException, IOException {
        TestSizeOf.measureSize(new Object());
        TestSizeOf.measureSize(new HashMap());
        TestSizeOf.measureSize(new LinkedHashMap());
        TestSizeOf.measureSize(new ReentrantReadWriteLock());
        TestSizeOf.measureSize(new byte[1000]);
        TestSizeOf.measureSize(new boolean[1000]);
        TestSizeOf.measureSize(new String("Hello World".toCharArray()));
        TestSizeOf.measureSize("Hello World");
        TestSizeOf.measureSize(10);
        TestSizeOf.measureSize(100);
        TestSizeOf.measureSize(1000);
        TestSizeOf.measureSize(new Parent(null, null));
        TestSizeOf.measureSize(new Kid());
        TestSizeOf.measureSize((Object)Thread.State.TERMINATED);
        TestSizeOf.measureSize(Boolean.TRUE);
    }

    private static void measureSize(Object object) {
        TestSizeOf.print(String.valueOf(object.getClass().getSimpleName()) + ", shallow=" + SizeOf.sizeOf(object) + ", deep=" + SizeOf.deepSizeOf(object));
    }

    private static class Parent {
        private int i;
        private boolean b;
        private long l;

        private Parent() {
        }

        /* synthetic */ Parent(Parent parent, Parent parent2) {
            this();
        }
    }

    private static class Kid
    extends Parent {
        private boolean b;
        private float f;

        private Kid() {
        }
    }
}

