/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class MergeInfrequentNominalValues
extends SimpleBatchFilter
implements UnsupervisedFilter {
    static final long serialVersionUID = 4444337331921333847L;
    protected int m_MinimumFrequency = 2;
    protected Range m_SelectCols = new Range();
    protected int[] m_SelectedAttributes;
    protected boolean[] m_AttToBeModified;
    protected int[][] m_NewValues;

    @Override
    public String globalInfo() {
        return "Merges all values of the specified nominal attribute that are sufficiently infrequent.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement((Option)enm.nextElement());
        }
        result.addElement(new Option("\tThe minimum frequency for a value to remain (default: 2).\n", "-N", 1, "-N <int>"));
        result.addElement(new Option("\tSets list of attributes to act on (or its inverse). 'first and 'last' are accepted as well.'\n\tE.g.: first-5,7,9,20-last\n\t(default: 1,2)", "R", 1, "-R <range>"));
        result.addElement(new Option("\tInvert matching sense (i.e. act on all attributes not specified in list)", "V", 0, "-V"));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-N");
        result.add("" + this.getMinimumFrequency());
        result.add("-R");
        result.add(this.getAttributeIndices());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String minFrequencyString = Utils.getOption('N', options);
        if (minFrequencyString.length() != 0) {
            this.setMinimumFrequency(Integer.parseInt(minFrequencyString));
        } else {
            this.setMinimumFrequency(2);
        }
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices("");
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        super.setOptions(options);
    }

    public String minimumFrequencyTipText() {
        return "The minimum frequency for a value to remain.";
    }

    public int getMinimumFrequency() {
        return this.m_MinimumFrequency;
    }

    public void setMinimumFrequency(int minF) {
        this.m_MinimumFrequency = minF;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on (or its inverse). This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_SelectCols.getRanges();
    }

    public void setAttributeIndices(String rangeList) {
        this.m_SelectCols.setRanges(rangeList);
    }

    public void setAttributeIndicesArray(int[] attributes) {
        this.setAttributeIndices(Range.indicesToRangeList(attributes));
    }

    public String invertSelectionTipText() {
        return "Determines whether selected attributes are to be acted on or all other attributes are used instead.";
    }

    public boolean getInvertSelection() {
        return this.m_SelectCols.getInvert();
    }

    public void setInvertSelection(boolean invert) {
        this.m_SelectCols.setInvert(invert);
    }

    @Override
    public boolean allowAccessToFullInputFormat() {
        return true;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) {
        int i;
        this.m_SelectCols.setUpper(inputFormat.numAttributes() - 1);
        this.m_SelectedAttributes = this.m_SelectCols.getSelection();
        int[][] freqs = new int[inputFormat.numAttributes()][];
        for (int i2 = 0; i2 < this.m_SelectedAttributes.length; ++i2) {
            int current = this.m_SelectedAttributes[i2];
            Attribute att = inputFormat.attribute(current);
            if (current == inputFormat.classIndex() || !att.isNominal()) continue;
            freqs[current] = new int[att.numValues()];
        }
        for (Instance inst : inputFormat) {
            for (int i3 = 0; i3 < this.m_SelectedAttributes.length; ++i3) {
                int current = this.m_SelectedAttributes[i3];
                if (current == inputFormat.classIndex() || !inputFormat.attribute(current).isNominal() || inst.isMissing(current)) continue;
                int[] nArray = freqs[current];
                int n = (int)inst.value(current);
                nArray[n] = nArray[n] + 1;
            }
        }
        int[] numInfrequentValues = new int[inputFormat.numAttributes()];
        for (i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int current = this.m_SelectedAttributes[i];
            Attribute att = inputFormat.attribute(current);
            if (current == inputFormat.classIndex() || !att.isNominal()) continue;
            for (int k = 0; k < att.numValues(); ++k) {
                if (this.m_Debug) {
                    System.err.println("Attribute: " + att.name() + " Value: " + att.value(k) + " Freq.: " + freqs[current][k]);
                }
                if (freqs[current][k] >= this.m_MinimumFrequency) continue;
                int n = current;
                numInfrequentValues[n] = numInfrequentValues[n] + 1;
            }
        }
        this.m_AttToBeModified = new boolean[inputFormat.numAttributes()];
        this.m_NewValues = new int[inputFormat.numAttributes()][];
        for (i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int current = this.m_SelectedAttributes[i];
            Attribute att = inputFormat.attribute(current);
            if (numInfrequentValues[current] <= 1) continue;
            this.m_AttToBeModified[current] = true;
            int j = 1;
            this.m_NewValues[current] = new int[att.numValues()];
            for (int k = 0; k < att.numValues(); ++k) {
                this.m_NewValues[current][k] = freqs[current][k] < this.m_MinimumFrequency ? 0 : j++;
            }
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i4 = 0; i4 < inputFormat.numAttributes(); ++i4) {
            int current = i4;
            Attribute att = inputFormat.attribute(current);
            if (this.m_AttToBeModified[i4]) {
                ArrayList<String> vals = new ArrayList<String>();
                StringBuilder sb = new StringBuilder();
                vals.add("");
                int[] map = new int[att.numValues()];
                for (int j = 0; j < att.numValues(); ++j) {
                    if (this.m_NewValues[current][j] == 0) {
                        if (sb.length() != 0) {
                            sb.append("_or_");
                        }
                        sb.append(att.value(j));
                        continue;
                    }
                    vals.add(att.value(j));
                }
                vals.set(0, sb.toString());
                atts.add(new Attribute(att.name() + "_merged_infrequent_values", vals));
                continue;
            }
            atts.add((Attribute)att.copy());
        }
        Instances data = new Instances(inputFormat.relationName(), atts, 0);
        data.setClassIndex(inputFormat.classIndex());
        return data;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public Instances process(Instances instances) throws Exception {
        Instances result = new Instances(this.getOutputFormat(), instances.numInstances());
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance inst = instances.instance(i);
            double[] newData = new double[instances.numAttributes()];
            for (int j = 0; j < instances.numAttributes(); ++j) {
                newData[j] = this.m_AttToBeModified[j] && !inst.isMissing(j) ? (double)this.m_NewValues[j][(int)inst.value(j)] : inst.value(j);
            }
            DenseInstance instNew = new DenseInstance(1.0, newData);
            instNew.setDataset(result);
            this.copyValues(instNew, false, inst.dataset(), this.getOutputFormat());
            result.add(instNew);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        MergeInfrequentNominalValues.runFilter(new MergeInfrequentNominalValues(), args);
    }
}

