/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.AbstractDensityBasedClusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.EM;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;

public class ClusterMembership
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 6675702504667714026L;
    protected DensityBasedClusterer m_clusterer = new EM();
    protected DensityBasedClusterer[] m_clusterers;
    protected Range m_ignoreAttributesRange;
    protected Filter m_removeAttributes;
    protected double[] m_priors;

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.m_clusterer.getCapabilities();
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public Capabilities getCapabilities(Instances data) {
        Instances newData = new Instances(data, 0);
        newData.setClassIndex(-1);
        return super.getCapabilities(newData);
    }

    @Override
    protected void testInputFormat(Instances instanceInfo) throws Exception {
        this.getCapabilities(instanceInfo).testWithFail(this.removeIgnored(instanceInfo));
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_removeAttributes = null;
        this.m_priors = null;
        return false;
    }

    protected Instances removeIgnored(Instances data) throws Exception {
        Instances result = data;
        if (this.m_ignoreAttributesRange != null || data.classIndex() >= 0) {
            result = new Instances(data);
            this.m_removeAttributes = new Remove();
            String rangeString = "";
            if (this.m_ignoreAttributesRange != null) {
                rangeString = rangeString + this.m_ignoreAttributesRange.getRanges();
            }
            if (data.classIndex() >= 0) {
                rangeString = rangeString.length() > 0 ? rangeString + "," + (data.classIndex() + 1) : "" + (data.classIndex() + 1);
            }
            ((Remove)this.m_removeAttributes).setAttributeIndices(rangeString);
            ((Remove)this.m_removeAttributes).setInvertSelection(false);
            this.m_removeAttributes.setInputFormat(data);
            result = Filter.useFilter(data, this.m_removeAttributes);
        }
        return result;
    }

    @Override
    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.outputFormatPeek() == null) {
            int i;
            int i2;
            Instances[] toFilterIgnoringAttributes;
            Instances toFilter = this.getInputFormat();
            if (toFilter.classIndex() >= 0 && toFilter.classAttribute().isNominal()) {
                toFilterIgnoringAttributes = new Instances[toFilter.numClasses()];
                for (i2 = 0; i2 < toFilter.numClasses(); ++i2) {
                    toFilterIgnoringAttributes[i2] = new Instances(toFilter, toFilter.numInstances());
                }
                for (i2 = 0; i2 < toFilter.numInstances(); ++i2) {
                    toFilterIgnoringAttributes[(int)toFilter.instance(i2).classValue()].add(toFilter.instance(i2));
                }
                this.m_priors = new double[toFilter.numClasses()];
                for (i2 = 0; i2 < toFilter.numClasses(); ++i2) {
                    toFilterIgnoringAttributes[i2].compactify();
                    this.m_priors[i2] = toFilterIgnoringAttributes[i2].sumOfWeights();
                }
                Utils.normalize(this.m_priors);
            } else {
                toFilterIgnoringAttributes = new Instances[]{toFilter};
                this.m_priors = new double[1];
                this.m_priors[0] = 1.0;
            }
            for (i2 = 0; i2 < toFilterIgnoringAttributes.length; ++i2) {
                toFilterIgnoringAttributes[i2] = this.removeIgnored(toFilterIgnoringAttributes[i2]);
            }
            if (toFilter.classIndex() <= 0 || !toFilter.classAttribute().isNominal()) {
                this.m_clusterers = AbstractDensityBasedClusterer.makeCopies(this.m_clusterer, 1);
                this.m_clusterers[0].buildClusterer(toFilterIgnoringAttributes[0]);
            } else {
                this.m_clusterers = AbstractDensityBasedClusterer.makeCopies(this.m_clusterer, toFilter.numClasses());
                for (i2 = 0; i2 < this.m_clusterers.length; ++i2) {
                    if (toFilterIgnoringAttributes[i2].numInstances() == 0) {
                        this.m_clusterers[i2] = null;
                        continue;
                    }
                    this.m_clusterers[i2].buildClusterer(toFilterIgnoringAttributes[i2]);
                }
            }
            FastVector<Attribute> attInfo = new FastVector<Attribute>();
            for (int j = 0; j < this.m_clusterers.length; ++j) {
                if (this.m_clusterers[j] == null) continue;
                for (i = 0; i < this.m_clusterers[j].numberOfClusters(); ++i) {
                    attInfo.addElement(new Attribute("pCluster_" + j + "_" + i));
                }
            }
            if (toFilter.classIndex() >= 0) {
                attInfo.addElement((Attribute)toFilter.classAttribute().copy());
            }
            attInfo.trimToSize();
            Instances filtered = new Instances(toFilter.relationName() + "_clusterMembership", attInfo, 0);
            if (toFilter.classIndex() >= 0) {
                filtered.setClassIndex(filtered.numAttributes() - 1);
            }
            this.setOutputFormat(filtered);
            for (i = 0; i < toFilter.numInstances(); ++i) {
                this.convertInstance(toFilter.instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.outputFormatPeek() != null) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    protected double[] logs2densities(int j, Instance in) throws Exception {
        double[] logs = this.m_clusterers[j].logJointDensitiesForInstance(in);
        int i = 0;
        while (i < logs.length) {
            int n = i++;
            logs[n] = logs[n] + Math.log(this.m_priors[j]);
        }
        return logs;
    }

    protected void convertInstance(Instance instance) throws Exception {
        double[] instanceVals = new double[this.outputFormatPeek().numAttributes()];
        double[] tempvals = instance.classIndex() >= 0 ? new double[this.outputFormatPeek().numAttributes() - 1] : new double[this.outputFormatPeek().numAttributes()];
        int pos = 0;
        for (int j = 0; j < this.m_clusterers.length; ++j) {
            double[] probs;
            if (this.m_clusterers[j] == null) continue;
            if (this.m_removeAttributes != null) {
                this.m_removeAttributes.input(instance);
                probs = this.logs2densities(j, this.m_removeAttributes.output());
            } else {
                probs = this.logs2densities(j, instance);
            }
            System.arraycopy(probs, 0, tempvals, pos, probs.length);
            pos += probs.length;
        }
        tempvals = Utils.logs2probs(tempvals);
        System.arraycopy(tempvals, 0, instanceVals, 0, tempvals.length);
        if (instance.classIndex() >= 0) {
            instanceVals[instanceVals.length - 1] = instance.classValue();
        }
        this.push(new DenseInstance(instance.weight(), instanceVals));
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tFull name of clusterer to use. eg:\n\t\tweka.clusterers.EM\n\tAdditional options after the '--'.\n\t(default: weka.clusterers.EM)", "W", 1, "-W <clusterer name>"));
        newVector.addElement(new Option("\tThe range of attributes the clusterer should ignore.\n\t(the class attribute is automatically ignored)", "I", 1, "-I <att1,att2-att4,...>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String clustererString = Utils.getOption('W', options);
        if (clustererString.length() == 0) {
            clustererString = EM.class.getName();
        }
        this.setDensityBasedClusterer((DensityBasedClusterer)Utils.forName(DensityBasedClusterer.class, clustererString, Utils.partitionOptions(options)));
        this.setIgnoredAttributeIndices(Utils.getOption('I', options));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] clustererOptions = new String[]{};
        if (this.m_clusterer != null && this.m_clusterer instanceof OptionHandler) {
            clustererOptions = ((OptionHandler)((Object)this.m_clusterer)).getOptions();
        }
        String[] options = new String[clustererOptions.length + 5];
        int current = 0;
        if (!this.getIgnoredAttributeIndices().equals("")) {
            options[current++] = "-I";
            options[current++] = this.getIgnoredAttributeIndices();
        }
        if (this.m_clusterer != null) {
            options[current++] = "-W";
            options[current++] = this.getDensityBasedClusterer().getClass().getName();
        }
        options[current++] = "--";
        System.arraycopy(clustererOptions, 0, options, current, clustererOptions.length);
        current += clustererOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String globalInfo() {
        return "A filter that uses a density-based clusterer to generate cluster membership values; filtered instances are composed of these values plus the class attribute (if set in the input data). If a (nominal) class attribute is set, the clusterer is run separately for each class. The class attribute (if set) and any user-specified attributes are ignored during the clustering operation";
    }

    public String densityBasedClustererTipText() {
        return "The clusterer that will generate membership values for the instances.";
    }

    public void setDensityBasedClusterer(DensityBasedClusterer newClusterer) {
        this.m_clusterer = newClusterer;
    }

    public DensityBasedClusterer getDensityBasedClusterer() {
        return this.m_clusterer;
    }

    public String ignoredAttributeIndicesTipText() {
        return "The range of attributes to be ignored by the clusterer. eg: first-3,5,9-last";
    }

    public String getIgnoredAttributeIndices() {
        if (this.m_ignoreAttributesRange == null) {
            return "";
        }
        return this.m_ignoreAttributesRange.getRanges();
    }

    public void setIgnoredAttributeIndices(String rangeList) {
        if (rangeList == null || rangeList.length() == 0) {
            this.m_ignoreAttributesRange = null;
        } else {
            this.m_ignoreAttributesRange = new Range();
            this.m_ignoreAttributesRange.setRanges(rangeList);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        ClusterMembership.runFilter(new ClusterMembership(), argv);
    }
}

