/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class ChangeDateFormat
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = -1609344074013448737L;
    private static final SimpleDateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private SingleIndex m_AttIndex = new SingleIndex("last");
    private SimpleDateFormat m_DateFormat = DEFAULT_FORMAT;
    private Attribute m_OutputAttribute;

    public String globalInfo() {
        return "Changes the date format used by a date attribute. This is most useful for converting to a format with less precision, for example, from an absolute date to day of year, etc. This changes the format string, and changes the date values to those that would be parsed by the new format.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(instanceInfo.numAttributes() - 1);
        if (!instanceInfo.attribute(this.m_AttIndex.getIndex()).isDate()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not date.");
        }
        this.setOutputFormat();
        return true;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        int index;
        Instance newInstance;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (!(newInstance = (Instance)instance.copy()).isMissing(index = this.m_AttIndex.getIndex())) {
            double value = instance.value(index);
            try {
                value = this.m_OutputAttribute.parseDate(this.m_OutputAttribute.formatDate(value));
            }
            catch (ParseException pe) {
                throw new RuntimeException("Output date format couldn't parse its own output!!");
            }
            newInstance.setValue(index, value);
        }
        this.push(newInstance);
        return true;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tSets the attribute index (default last).", "C", 1, "-C <col>"));
        newVector.addElement(new Option("\tSets the output date format string (default corresponds to ISO-8601).", "F", 1, "-F <value index>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String attIndex = Utils.getOption('C', options);
        if (attIndex.length() != 0) {
            this.setAttributeIndex(attIndex);
        } else {
            this.setAttributeIndex("last");
        }
        String formatString = Utils.getOption('F', options);
        if (formatString.length() != 0) {
            this.setDateFormat(formatString);
        } else {
            this.setDateFormat(DEFAULT_FORMAT);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[4];
        int current = 0;
        options[current++] = "-C";
        options[current++] = "" + this.getAttributeIndex();
        options[current++] = "-F";
        options[current++] = "" + this.getDateFormat().toPattern();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be of type date (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_AttIndex.setSingleIndex(attIndex);
    }

    public String dateFormatTipText() {
        return "The date format to change to. This should be a format understood by Java's SimpleDateFormat class.";
    }

    public SimpleDateFormat getDateFormat() {
        return this.m_DateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.setDateFormat(new SimpleDateFormat(dateFormat));
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException();
        }
        this.m_DateFormat = dateFormat;
    }

    private void setOutputFormat() {
        FastVector<Attribute> newAtts = new FastVector<Attribute>(this.getInputFormat().numAttributes());
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (j == this.m_AttIndex.getIndex()) {
                newAtts.addElement(new Attribute(att.name(), this.getDateFormat().toPattern()));
                continue;
            }
            newAtts.addElement((Attribute)att.copy());
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.m_OutputAttribute = newData.attribute(this.m_AttIndex.getIndex());
        this.setOutputFormat(newData);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        ChangeDateFormat.runFilter(new ChangeDateFormat(), argv);
    }
}

