/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class NormalizeCase
extends SimpleBatchFilter {
    NormType norm = NormType.STD_NORMAL;
    static String[] fileNames = new String[]{"Beef", "Coffee", "OliveOil", "Earthquakes", "Ford_A", "Ford_B"};
    static String path = "C:\\Research\\Data\\Time Series Data\\Time Series Classification\\";

    public void setNormType(NormType n) {
        this.norm = n;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) {
        Instances result = new Instances(inputFormat, 0);
        return result;
    }

    @Override
    public Instances process(Instances inst) throws Exception {
        Instances result = new Instances(inst);
        switch (this.norm) {
            case INTERVAL: {
                this.intervalNorm(result);
                break;
            }
            case STD: {
                this.standard(result);
                break;
            }
            case STD_NORMAL: {
                this.standardNorm(result);
                break;
            }
        }
        return result;
    }

    public void intervalNorm(Instances r) {
        for (int i = 0; i < r.numInstances(); ++i) {
            double x;
            int j;
            double max = Double.MIN_VALUE;
            double min = Double.MAX_VALUE;
            for (j = 0; j < r.numAttributes(); ++j) {
                if (j == r.classIndex() || r.attribute(j).isNominal()) continue;
                x = r.instance(i).value(j);
                if (x > max) {
                    max = x;
                }
                if (!(x < min)) continue;
                min = x;
            }
            for (j = 0; j < r.numAttributes(); ++j) {
                if (j == r.classIndex() || r.attribute(j).isNominal()) continue;
                x = r.instance(i).value(j);
                r.instance(i).setValue(j, (x - min) / (max - min));
            }
        }
    }

    public void standard(Instances r) throws Exception {
        int size = r.numAttributes();
        int classIndex = r.classIndex();
        if (classIndex > 0) {
            --size;
        }
        for (int i = 0; i < r.numInstances(); ++i) {
            double x;
            int j;
            double stdev = 0.0;
            double mean = 0.0;
            double sumSq = 0.0;
            double sum = 0.0;
            for (j = 0; j < r.numAttributes(); ++j) {
                if (j != classIndex && !r.attribute(j).isNominal()) {
                    x = r.instance(i).value(j);
                    sum += x;
                }
                mean = sum / (double)size;
            }
            for (j = 0; j < r.numAttributes(); ++j) {
                if (j == classIndex || r.attribute(j).isNominal()) continue;
                x = r.instance(i).value(j);
                r.instance(i).setValue(j, x - mean);
            }
        }
    }

    public static void standardNorm(double[] r) throws Exception {
        int i;
        double sum = 0.0;
        double sumSq = 0.0;
        double mean = 0.0;
        double stdev = 0.0;
        for (i = 0; i < r.length; ++i) {
            sum += r[i];
            sumSq += r[i] * r[i];
        }
        stdev = (sumSq - sum * sum / (double)r.length) / (double)r.length;
        mean = sum / (double)r.length;
        if (stdev == 0.0) {
            throw new Exception("Cannot normalise a series with zero variance! mean =" + mean + " sum = " + sum + " sum sq = " + sumSq);
        }
        stdev = Math.sqrt(stdev);
        for (i = 0; i < r.length; ++i) {
            r[i] = (r[i] - mean) / stdev;
        }
    }

    public void standardNorm(Instances r) throws Exception {
        int size = r.numAttributes();
        int classIndex = r.classIndex();
        if (classIndex >= 0) {
            --size;
        }
        for (int i = 0; i < r.numInstances(); ++i) {
            double x;
            int j;
            double stdev = 0.0;
            double mean = 0.0;
            double sumSq = 0.0;
            double sum = 0.0;
            for (j = 0; j < r.numAttributes(); ++j) {
                if (j == classIndex || r.attribute(j).isNominal()) continue;
                x = r.instance(i).value(j);
                sum += x;
                sumSq += x * x;
            }
            stdev = (sumSq - sum * sum / (double)size) / (double)size;
            mean = sum / (double)size;
            if ((stdev = Math.sqrt(stdev)) == 0.0) {
                throw new Exception("Cannot normalise a series with zero variance! Instance number =" + i + " mean =" + mean + " sum = " + sum + " sum sq = " + sumSq + " instance =" + r.instance(i));
            }
            for (j = 0; j < r.numAttributes(); ++j) {
                if (j == classIndex || r.attribute(j).isNominal()) continue;
                x = r.instance(i).value(j);
                r.instance(i).setValue(j, (x - mean) / stdev);
            }
        }
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public static void main(String[] args) {
    }

    public static enum NormType {
        INTERVAL,
        STD,
        STD_NORMAL;

    }
}

