/*
 * Decompiled with CFR 0.152.
 */
package weka.core.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.regex.Matcher;
import weka.core.RevisionUtils;
import weka.core.logging.ConsoleLogger;
import weka.core.logging.Logger;

public class FileLogger
extends ConsoleLogger {
    protected File m_LogFile;
    protected String m_LineFeed;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_LogFile = this.getLogFile();
        try {
            if (this.m_LogFile != null && this.m_LogFile.exists()) {
                this.m_LogFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_LineFeed = System.getProperty("line.separator");
    }

    protected File getLogFile() {
        String filename = m_Properties.getProperty("LogFile", "%w" + File.separator + "weka.log");
        filename = filename.replaceAll("%t", Matcher.quoteReplacement(System.getProperty("java.io.tmpdir")));
        filename = filename.replaceAll("%h", Matcher.quoteReplacement(System.getProperty("user.home")));
        filename = filename.replaceAll("%c", Matcher.quoteReplacement(System.getProperty("user.dir")));
        if (System.getProperty("%") != null && System.getProperty("%").length() > 0) {
            filename = filename.replaceAll("%%", Matcher.quoteReplacement(System.getProperty("%")));
        }
        File result = new File(filename);
        return result;
    }

    protected void append(String s) {
        if (this.m_LogFile == null) {
            return;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_LogFile, true));
            writer.write(s);
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void doLog(Logger.Level level, String msg, String cls, String method, int lineno) {
        super.doLog(level, msg, cls, method, lineno);
        this.append(m_DateFormat.format(new Date()) + " " + cls + " " + method + this.m_LineFeed + (Object)((Object)level) + ": " + msg + this.m_LineFeed);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

