/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.sortinghandler;

import java.util.Vector;
import weka.classifiers.rules.sortinghandler.Comparator;
import weka.classifiers.rules.sortinghandler.VectorSort;

public class QuicksortVector
implements VectorSort {
    @Override
    public final void sort(Vector v, Comparator c) {
        QuicksortVector.execute(v, c);
    }

    public static void execute(Vector v, Comparator c) {
        QuicksortVector.quicksort(v, 0, v.size() - 1, c);
    }

    private static void swap(Vector v, int a, int b) {
        Object temp = v.elementAt(a);
        v.setElementAt(v.elementAt(b), a);
        v.setElementAt(temp, b);
    }

    private static int partition(Vector v, int lower, int upper, Comparator c) {
        Object pivotValue = v.elementAt((upper + lower + 1) / 2);
        while (lower <= upper) {
            while (c.relation(v.elementAt(lower), pivotValue)) {
                ++lower;
            }
            while (c.relation(pivotValue, v.elementAt(upper))) {
                --upper;
            }
            if (lower > upper) continue;
            if (lower < upper) {
                QuicksortVector.swap(v, lower, upper);
            }
            ++lower;
            --upper;
        }
        return upper;
    }

    private static void quicksort(Vector v, int lower, int upper, Comparator c) {
        int sliceLength = upper - lower + 1;
        if (sliceLength > 1) {
            if (sliceLength == 2) {
                if (c.relation(v.elementAt(upper), v.elementAt(lower))) {
                    QuicksortVector.swap(v, lower, upper);
                }
            } else {
                int pivotIndex = QuicksortVector.partition(v, lower, upper, c);
                QuicksortVector.quicksort(v, lower, pivotIndex, c);
                QuicksortVector.quicksort(v, pivotIndex + 1, upper, c);
            }
        }
    }
}

