/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class ConjunctiveRule
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -5938309903225087198L;
    private int m_Folds = 3;
    private Attribute m_ClassAttribute;
    protected FastVector m_Antds = null;
    protected double[] m_DefDstr = null;
    protected double[] m_Cnsqt = null;
    private int m_NumClasses = 0;
    private long m_Seed = 1L;
    private Random m_Random = null;
    private FastVector m_Targets;
    private boolean m_IsExclude = false;
    private double m_MinNo = 2.0;
    private int m_NumAntds = -1;

    public String globalInfo() {
        return "This class implements a single conjunctive rule learner that can predict for numeric and nominal class labels.\n\nA rule consists of antecedents \"AND\"ed together and the consequent (class value) for the classification/regression.  In this case, the consequent is the distribution of the available classes (or mean for a numeric value) in the dataset. If the test instance is not covered by this rule, then it's predicted using the default class distributions/value of the data not covered by the rule in the training data.This learner selects an antecedent by computing the Information Gain of each antecendent and prunes the generated rule using Reduced Error Prunning (REP) or simple pre-pruning based on the number of antecedents.\n\nFor classification, the Information of one antecedent is the weighted average of the entropies of both the data covered and not covered by the rule.\nFor regression, the Information is the weighted average of the mean-squared errors of both the data covered and not covered by the rule.\n\nIn pruning, weighted average of the accuracy rates on the pruning data is used for classification while the weighted average of the mean-squared errors on the pruning data is used for regression.\n\n";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tSet number of folds for REP\n\tOne fold is used as pruning set.\n\t(default 3)", "N", 1, "-N <number of folds>"));
        newVector.addElement(new Option("\tSet if NOT uses randomization\n\t(default:use randomization)", "R", 0, "-R"));
        newVector.addElement(new Option("\tSet whether consider the exclusive\n\texpressions for nominal attributes\n\t(default false)", "E", 0, "-E"));
        newVector.addElement(new Option("\tSet the minimal weights of instances\n\twithin a split.\n\t(default 2.0)", "M", 1, "-M <min. weights>"));
        newVector.addElement(new Option("\tSet number of antecedents for pre-pruning\n\tif -1, then REP is used\n\t(default -1)", "P", 1, "-P <number of antecedents>"));
        newVector.addElement(new Option("\tSet the seed of randomization\n\t(default 1)", "S", 1, "-S <seed>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String numFoldsString = Utils.getOption('N', options);
        this.m_Folds = numFoldsString.length() != 0 ? Integer.parseInt(numFoldsString) : 3;
        String minNoString = Utils.getOption('M', options);
        this.m_MinNo = minNoString.length() != 0 ? Double.parseDouble(minNoString) : 2.0;
        String seedString = Utils.getOption('S', options);
        this.m_Seed = seedString.length() != 0 ? (long)Integer.parseInt(seedString) : 1L;
        String numAntdsString = Utils.getOption('P', options);
        this.m_NumAntds = numAntdsString.length() != 0 ? Integer.parseInt(numAntdsString) : -1;
        this.m_IsExclude = Utils.getFlag('E', options);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[9];
        int current = 0;
        options[current++] = "-N";
        options[current++] = "" + this.m_Folds;
        options[current++] = "-M";
        options[current++] = "" + this.m_MinNo;
        options[current++] = "-P";
        options[current++] = "" + this.m_NumAntds;
        options[current++] = "-S";
        options[current++] = "" + this.m_Seed;
        if (this.m_IsExclude) {
            options[current++] = "-E";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String foldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public void setFolds(int folds) {
        this.m_Folds = folds;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    public void setSeed(long s) {
        this.m_Seed = s;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String exclusiveTipText() {
        return "Set whether to consider exclusive expressions for nominal attribute splits.";
    }

    public boolean getExclusive() {
        return this.m_IsExclude;
    }

    public void setExclusive(boolean e) {
        this.m_IsExclude = e;
    }

    public String minNoTipText() {
        return "The minimum total weight of the instances in a rule.";
    }

    public void setMinNo(double m) {
        this.m_MinNo = m;
    }

    public double getMinNo() {
        return this.m_MinNo;
    }

    public String numAntdsTipText() {
        return "Set the number of antecedents allowed in the rule if pre-pruning is used.  If this value is other than -1, then pre-pruning will be used, otherwise the rule uses reduced-error pruning.";
    }

    public void setNumAntds(int n) {
        this.m_NumAntds = n;
    }

    public int getNumAntds() {
        return this.m_NumAntds;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        Instances data = new Instances(instances);
        data.deleteWithMissingClass();
        if (data.numInstances() < this.m_Folds) {
            throw new Exception("Not enough data for REP.");
        }
        this.m_ClassAttribute = data.classAttribute();
        this.m_NumClasses = this.m_ClassAttribute.isNominal() ? this.m_ClassAttribute.numValues() : 1;
        this.m_Antds = new FastVector();
        this.m_DefDstr = new double[this.m_NumClasses];
        this.m_Cnsqt = new double[this.m_NumClasses];
        this.m_Targets = new FastVector();
        this.m_Random = new Random(this.m_Seed);
        if (this.m_NumAntds != -1) {
            this.grow(data);
        } else {
            data.randomize(this.m_Random);
            data.stratify(this.m_Folds);
            Instances growData = data.trainCV(this.m_Folds, this.m_Folds - 1, this.m_Random);
            Instances pruneData = data.testCV(this.m_Folds, this.m_Folds - 1);
            this.grow(growData);
            this.prune(pruneData);
        }
        if (this.m_ClassAttribute.isNominal()) {
            Utils.normalize(this.m_Cnsqt);
            if (Utils.gr(Utils.sum(this.m_DefDstr), 0.0)) {
                Utils.normalize(this.m_DefDstr);
            }
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (instance == null) {
            throw new Exception("Testing instance is NULL!");
        }
        if (this.isCover(instance)) {
            return this.m_Cnsqt;
        }
        return this.m_DefDstr;
    }

    public boolean isCover(Instance datum) {
        boolean isCover = true;
        for (int i = 0; i < this.m_Antds.size(); ++i) {
            Antd antd = (Antd)this.m_Antds.elementAt(i);
            if (antd.isCover(datum)) continue;
            isCover = false;
            break;
        }
        return isCover;
    }

    public boolean hasAntds() {
        if (this.m_Antds == null) {
            return false;
        }
        return this.m_Antds.size() > 0;
    }

    private void grow(Instances data) {
        Instances growData = new Instances(data);
        double whole = data.sumOfWeights();
        if (this.m_NumAntds != 0) {
            double defInfo;
            Instance datum;
            int i;
            double[][] classDstr = new double[2][this.m_NumClasses];
            for (int j = 0; j < this.m_NumClasses; ++j) {
                classDstr[0][j] = 0.0;
                classDstr[1][j] = 0.0;
            }
            if (this.m_ClassAttribute.isNominal()) {
                for (i = 0; i < growData.numInstances(); ++i) {
                    datum = growData.instance(i);
                    double[] dArray = classDstr[0];
                    int n = (int)datum.classValue();
                    dArray[n] = dArray[n] + datum.weight();
                }
                defInfo = ContingencyTables.entropy(classDstr[0]);
            } else {
                for (i = 0; i < growData.numInstances(); ++i) {
                    datum = growData.instance(i);
                    double[] dArray = classDstr[0];
                    dArray[0] = dArray[0] + datum.weight() * datum.classValue();
                }
                double defMean = classDstr[0][0] / whole;
                defInfo = this.meanSquaredError(growData, defMean) * growData.sumOfWeights();
            }
            double[][] tmp = new double[2][this.m_NumClasses];
            for (int y = 0; y < this.m_NumClasses; ++y) {
                if (this.m_ClassAttribute.isNominal()) {
                    tmp[0][y] = classDstr[0][y];
                    tmp[1][y] = classDstr[1][y];
                    continue;
                }
                tmp[0][y] = classDstr[0][y] / whole;
                tmp[1][y] = classDstr[1][y];
            }
            this.m_Targets.addElement(tmp);
            boolean[] used = new boolean[growData.numAttributes()];
            for (int k = 0; k < used.length; ++k) {
                used[k] = false;
            }
            int numUnused = used.length;
            double uncoveredWtSq = 0.0;
            double uncoveredWtVl = 0.0;
            double uncoveredWts = 0.0;
            boolean isContinue = true;
            while (isContinue) {
                int numAntdsThreshold;
                double maxInfoGain = 0.0;
                Antd oneAntd = null;
                Instances coverData = null;
                Instances uncoverData = null;
                Enumeration enumAttr = growData.enumerateAttributes();
                int index = -1;
                while (enumAttr.hasMoreElements()) {
                    double infoGain;
                    boolean isUpdate;
                    Instances[] coveredData;
                    Attribute att = (Attribute)enumAttr.nextElement();
                    Antd antd = null;
                    antd = this.m_ClassAttribute.isNominal() ? (att.isNumeric() ? new NumericAntd(att, classDstr[1]) : new NominalAntd(att, classDstr[1])) : (att.isNumeric() ? new NumericAntd(att, uncoveredWtSq, uncoveredWtVl, uncoveredWts) : new NominalAntd(att, uncoveredWtSq, uncoveredWtVl, uncoveredWts));
                    if (used[++index] || (coveredData = this.computeInfoGain(growData, defInfo, antd)) == null || !(isUpdate = Utils.gr(infoGain = antd.getMaxInfoGain(), maxInfoGain))) continue;
                    oneAntd = antd;
                    coverData = coveredData[0];
                    uncoverData = coveredData[1];
                    maxInfoGain = infoGain;
                }
                if (oneAntd == null) break;
                if (!oneAntd.getAttr().isNumeric()) {
                    used[oneAntd.getAttr().index()] = true;
                    --numUnused;
                }
                this.m_Antds.addElement(oneAntd);
                growData = coverData;
                for (int x = 0; x < uncoverData.numInstances(); ++x) {
                    Instance datum2 = uncoverData.instance(x);
                    if (this.m_ClassAttribute.isNumeric()) {
                        uncoveredWtSq += datum2.weight() * datum2.classValue() * datum2.classValue();
                        uncoveredWtVl += datum2.weight() * datum2.classValue();
                        uncoveredWts += datum2.weight();
                        double[] dArray = classDstr[0];
                        dArray[0] = dArray[0] - datum2.weight() * datum2.classValue();
                        double[] dArray2 = classDstr[1];
                        dArray2[0] = dArray2[0] + datum2.weight() * datum2.classValue();
                        continue;
                    }
                    double[] dArray = classDstr[0];
                    int n = (int)datum2.classValue();
                    dArray[n] = dArray[n] - datum2.weight();
                    double[] dArray3 = classDstr[1];
                    int n2 = (int)datum2.classValue();
                    dArray3[n2] = dArray3[n2] + datum2.weight();
                }
                tmp = new double[2][this.m_NumClasses];
                for (int y = 0; y < this.m_NumClasses; ++y) {
                    if (this.m_ClassAttribute.isNominal()) {
                        tmp[0][y] = classDstr[0][y];
                        tmp[1][y] = classDstr[1][y];
                        continue;
                    }
                    tmp[0][y] = classDstr[0][y] / (whole - uncoveredWts);
                    tmp[1][y] = classDstr[1][y] / uncoveredWts;
                }
                this.m_Targets.addElement(tmp);
                defInfo = oneAntd.getInfo();
                int n = numAntdsThreshold = this.m_NumAntds == -1 ? Integer.MAX_VALUE : this.m_NumAntds;
                if (!Utils.eq(growData.sumOfWeights(), 0.0) && numUnused != 0 && this.m_Antds.size() < numAntdsThreshold) continue;
                isContinue = false;
            }
        }
        this.m_Cnsqt = ((double[][])this.m_Targets.lastElement())[0];
        this.m_DefDstr = ((double[][])this.m_Targets.lastElement())[1];
    }

    private Instances[] computeInfoGain(Instances instances, double defInfo, Antd antd) {
        Instances data = new Instances(instances);
        Instances[] splitData = antd.splitData(data, defInfo);
        Instances[] coveredData = new Instances[2];
        Instances tmp1 = new Instances(data, 0);
        Instances tmp2 = new Instances(data, 0);
        if (splitData == null) {
            return null;
        }
        for (int x = 0; x < splitData.length - 1; ++x) {
            if (x == (int)antd.getAttrValue()) {
                tmp1 = splitData[x];
                continue;
            }
            for (int y = 0; y < splitData[x].numInstances(); ++y) {
                tmp2.add(splitData[x].instance(y));
            }
        }
        if (antd.getAttr().isNominal()) {
            if (((NominalAntd)antd).isIn()) {
                coveredData[0] = new Instances(tmp1);
                coveredData[1] = new Instances(tmp2);
            } else {
                coveredData[0] = new Instances(tmp2);
                coveredData[1] = new Instances(tmp1);
            }
        } else {
            coveredData[0] = new Instances(tmp1);
            coveredData[1] = new Instances(tmp2);
        }
        for (int z = 0; z < splitData[splitData.length - 1].numInstances(); ++z) {
            coveredData[1].add(splitData[splitData.length - 1].instance(z));
        }
        return coveredData;
    }

    private void prune(Instances pruneData) {
        double defAccu;
        Instances data = new Instances(pruneData);
        Instances otherData = new Instances(data, 0);
        double total = data.sumOfWeights();
        if (this.m_ClassAttribute.isNumeric()) {
            defAccu = this.meanSquaredError(pruneData, ((double[][])this.m_Targets.firstElement())[0][0]);
        } else {
            int predict = Utils.maxIndex(((double[][])this.m_Targets.firstElement())[0]);
            defAccu = this.computeAccu(pruneData, predict) / total;
        }
        int size = this.m_Antds.size();
        if (size == 0) {
            this.m_Cnsqt = ((double[][])this.m_Targets.lastElement())[0];
            this.m_DefDstr = ((double[][])this.m_Targets.lastElement())[1];
            return;
        }
        double[] worthValue = new double[size];
        for (int x = 0; x < size; ++x) {
            double other;
            double covered;
            Antd antd = (Antd)this.m_Antds.elementAt(x);
            Instances newData = new Instances(data);
            if (Utils.eq(newData.sumOfWeights(), 0.0)) break;
            data = new Instances(newData, newData.numInstances());
            for (int y = 0; y < newData.numInstances(); ++y) {
                Instance ins = newData.instance(y);
                if (antd.isCover(ins)) {
                    data.add(ins);
                    continue;
                }
                otherData.add(ins);
            }
            double[][] classes = (double[][])this.m_Targets.elementAt(x + 1);
            if (this.m_ClassAttribute.isNominal()) {
                int coverClass = Utils.maxIndex(classes[0]);
                int otherClass = Utils.maxIndex(classes[1]);
                covered = this.computeAccu(data, coverClass);
                other = this.computeAccu(otherData, otherClass);
            } else {
                double coverClass = classes[0][0];
                double otherClass = classes[1][0];
                covered = data.sumOfWeights() * this.meanSquaredError(data, coverClass);
                other = otherData.sumOfWeights() * this.meanSquaredError(otherData, otherClass);
            }
            worthValue[x] = (covered + other) / total;
        }
        for (int z = size - 1; z > 0; --z) {
            double valueDelta = this.m_ClassAttribute.isNominal() ? (Utils.sm(worthValue[z], 1.0) ? (worthValue[z] - worthValue[z - 1]) / worthValue[z] : worthValue[z] - worthValue[z - 1]) : (Utils.sm(worthValue[z], 1.0) ? (worthValue[z - 1] - worthValue[z]) / worthValue[z] : worthValue[z - 1] - worthValue[z]);
            if (!Utils.smOrEq(valueDelta, 0.0)) break;
            this.m_Antds.removeElementAt(z);
            this.m_Targets.removeElementAt(z + 1);
        }
        if (this.m_Antds.size() == 1) {
            double valueDelta = this.m_ClassAttribute.isNominal() ? (Utils.sm(worthValue[0], 1.0) ? (worthValue[0] - defAccu) / worthValue[0] : worthValue[0] - defAccu) : (Utils.sm(worthValue[0], 1.0) ? (defAccu - worthValue[0]) / worthValue[0] : defAccu - worthValue[0]);
            if (Utils.smOrEq(valueDelta, 0.0)) {
                this.m_Antds.removeAllElements();
                this.m_Targets.removeElementAt(1);
            }
        }
        this.m_Cnsqt = ((double[][])this.m_Targets.lastElement())[0];
        this.m_DefDstr = ((double[][])this.m_Targets.lastElement())[1];
    }

    private double computeAccu(Instances data, int clas) {
        double accu = 0.0;
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            if ((int)inst.classValue() != clas) continue;
            accu += inst.weight();
        }
        return accu;
    }

    private double meanSquaredError(Instances data, double mean) {
        if (Utils.eq(data.sumOfWeights(), 0.0)) {
            return 0.0;
        }
        double mSqErr = 0.0;
        double sum = data.sumOfWeights();
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance datum = data.instance(i);
            mSqErr += datum.weight() * (datum.classValue() - mean) * (datum.classValue() - mean);
        }
        return mSqErr / sum;
    }

    public String toString(String att, String cl) {
        StringBuffer text = new StringBuffer();
        if (this.m_Antds.size() > 0) {
            for (int j = 0; j < this.m_Antds.size() - 1; ++j) {
                text.append("(" + ((Antd)this.m_Antds.elementAt(j)).toString() + ") and ");
            }
            text.append("(" + ((Antd)this.m_Antds.lastElement()).toString() + ")");
        }
        text.append(" => " + att + " = " + cl);
        return text.toString();
    }

    public String toString() {
        String title = "\n\nSingle conjunctive rule learner:\n--------------------------------\n";
        String body = null;
        StringBuffer text = new StringBuffer();
        if (this.m_ClassAttribute != null) {
            if (this.m_ClassAttribute.isNominal()) {
                int l;
                int k;
                body = this.toString(this.m_ClassAttribute.name(), this.m_ClassAttribute.value(Utils.maxIndex(this.m_Cnsqt)));
                text.append("\n\nClass distributions:\nCovered by the rule:\n");
                for (k = 0; k < this.m_Cnsqt.length; ++k) {
                    text.append(this.m_ClassAttribute.value(k) + "\t");
                }
                text.append('\n');
                for (l = 0; l < this.m_Cnsqt.length; ++l) {
                    text.append(Utils.doubleToString(this.m_Cnsqt[l], 6) + "\t");
                }
                text.append("\n\nNot covered by the rule:\n");
                for (k = 0; k < this.m_DefDstr.length; ++k) {
                    text.append(this.m_ClassAttribute.value(k) + "\t");
                }
                text.append('\n');
                for (l = 0; l < this.m_DefDstr.length; ++l) {
                    text.append(Utils.doubleToString(this.m_DefDstr[l], 6) + "\t");
                }
            } else {
                body = this.toString(this.m_ClassAttribute.name(), Utils.doubleToString(this.m_Cnsqt[0], 6));
            }
        }
        return title + body + text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5529 $");
    }

    public static void main(String[] args) {
        ConjunctiveRule.runClassifier(new ConjunctiveRule(), args);
    }

    class NominalAntd
    extends Antd {
        static final long serialVersionUID = -5949864163376447424L;
        private double[][] stats;
        private double[] coverage;
        private boolean isIn;

        public NominalAntd(Attribute a, double[] unc) {
            super(a, unc);
            int bag = this.att.numValues();
            this.stats = new double[bag][ConjunctiveRule.this.m_NumClasses];
            this.coverage = new double[bag];
            this.isIn = true;
        }

        public NominalAntd(Attribute a, double sq, double vl, double wts) {
            super(a, sq, vl, wts);
            int bag = this.att.numValues();
            this.stats = null;
            this.coverage = new double[bag];
            this.isIn = true;
        }

        @Override
        public Instances[] splitData(Instances data, double defInfo) {
            int x;
            int x2;
            int bag = this.att.numValues();
            Instances[] splitData = new Instances[bag + 1];
            double[] wSq = new double[bag];
            double[] wVl = new double[bag];
            double totalWS = 0.0;
            double totalWV = 0.0;
            double msingWS = 0.0;
            double msingWV = 0.0;
            double sum = data.sumOfWeights();
            double[] all = new double[ConjunctiveRule.this.m_NumClasses];
            double[] missing = new double[ConjunctiveRule.this.m_NumClasses];
            for (int w = 0; w < ConjunctiveRule.this.m_NumClasses; ++w) {
                missing[w] = 0.0;
                all[w] = 0.0;
            }
            for (x2 = 0; x2 < bag; ++x2) {
                wVl[x2] = 0.0;
                wSq[x2] = 0.0;
                this.coverage[x2] = 0.0;
                if (this.stats != null) {
                    for (int y = 0; y < ConjunctiveRule.this.m_NumClasses; ++y) {
                        this.stats[x2][y] = 0.0;
                    }
                }
                splitData[x2] = new Instances(data, data.numInstances());
            }
            splitData[bag] = new Instances(data, data.numInstances());
            for (x2 = 0; x2 < data.numInstances(); ++x2) {
                Instance inst = data.instance(x2);
                if (!inst.isMissing(this.att)) {
                    int v = (int)inst.value(this.att);
                    splitData[v].add(inst);
                    int n = v;
                    this.coverage[n] = this.coverage[n] + inst.weight();
                    if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                        double[] dArray = this.stats[v];
                        int n2 = (int)inst.classValue();
                        dArray[n2] = dArray[n2] + inst.weight();
                        int n3 = (int)inst.classValue();
                        all[n3] = all[n3] + inst.weight();
                        continue;
                    }
                    int n4 = v;
                    wSq[n4] = wSq[n4] + inst.weight() * inst.classValue() * inst.classValue();
                    int n5 = v;
                    wVl[n5] = wVl[n5] + inst.weight() * inst.classValue();
                    totalWS += inst.weight() * inst.classValue() * inst.classValue();
                    totalWV += inst.weight() * inst.classValue();
                    continue;
                }
                splitData[bag].add(inst);
                if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                    int n = (int)inst.classValue();
                    all[n] = all[n] + inst.weight();
                    int n6 = (int)inst.classValue();
                    missing[n6] = missing[n6] + inst.weight();
                    continue;
                }
                totalWS += inst.weight() * inst.classValue() * inst.classValue();
                totalWV += inst.weight() * inst.classValue();
                msingWS += inst.weight() * inst.classValue() * inst.classValue();
                msingWV += inst.weight() * inst.classValue();
            }
            double whole = ConjunctiveRule.this.m_ClassAttribute.isNominal() ? sum + Utils.sum(this.uncover) : sum + this.uncoverSum;
            double minEntrp = Double.MAX_VALUE;
            this.maxInfoGain = 0.0;
            int count = 0;
            for (x = 0; x < bag; ++x) {
                if (!Utils.grOrEq(this.coverage[x], ConjunctiveRule.this.m_MinNo)) continue;
                ++count;
            }
            if (count < 2) {
                this.maxInfoGain = 0.0;
                this.inform = defInfo;
                this.value = Double.NaN;
                return null;
            }
            for (x = 0; x < bag; ++x) {
                double infoGain;
                double entrp;
                double t = this.coverage[x];
                if (Utils.sm(t, ConjunctiveRule.this.m_MinNo)) continue;
                if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                    double[] other = new double[ConjunctiveRule.this.m_NumClasses];
                    for (int y = 0; y < ConjunctiveRule.this.m_NumClasses; ++y) {
                        other[y] = all[y] - this.stats[x][y] + this.uncover[y];
                    }
                    double otherCover = whole - t;
                    entrp = this.entropy(this.stats[x], t);
                    double uncEntp = this.entropy(other, otherCover);
                    infoGain = defInfo - (entrp * t + uncEntp * otherCover) / whole;
                } else {
                    double weight = whole - t;
                    entrp = this.wtMeanSqErr(wSq[x], wVl[x], t) / t;
                    infoGain = defInfo - entrp * t - this.wtMeanSqErr(totalWS - wSq[x] + this.uncoverWtSq, totalWV - wVl[x] + this.uncoverWtVl, weight);
                }
                boolean isWithin = true;
                if (ConjunctiveRule.this.m_IsExclude) {
                    double infoGain2;
                    double entrp2;
                    if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                        double[] other2 = new double[ConjunctiveRule.this.m_NumClasses];
                        double[] notIn = new double[ConjunctiveRule.this.m_NumClasses];
                        for (int y = 0; y < ConjunctiveRule.this.m_NumClasses; ++y) {
                            other2[y] = this.stats[x][y] + missing[y] + this.uncover[y];
                            notIn[y] = all[y] - this.stats[x][y] - missing[y];
                        }
                        double msSum = Utils.sum(missing);
                        double otherCover2 = t + msSum + Utils.sum(this.uncover);
                        entrp2 = this.entropy(notIn, sum - t - msSum);
                        double uncEntp2 = this.entropy(other2, otherCover2);
                        infoGain2 = defInfo - (entrp2 * (sum - t - msSum) + uncEntp2 * otherCover2) / whole;
                    } else {
                        double msWts = splitData[bag].sumOfWeights();
                        double weight2 = t + this.uncoverSum + msWts;
                        entrp2 = this.wtMeanSqErr(totalWS - wSq[x] - msingWS, totalWV - wVl[x] - msingWV, sum - t - msWts) / (sum - t - msWts);
                        infoGain2 = defInfo - entrp2 * (sum - t - msWts) - this.wtMeanSqErr(wSq[x] + this.uncoverWtSq + msingWS, wVl[x] + this.uncoverWtVl + msingWV, weight2);
                    }
                    if (Utils.gr(infoGain2, infoGain) || Utils.eq(infoGain2, infoGain) && Utils.sm(entrp2, entrp)) {
                        infoGain = infoGain2;
                        entrp = entrp2;
                        isWithin = false;
                    }
                }
                if (!Utils.gr(infoGain, this.maxInfoGain) && (!Utils.eq(infoGain, this.maxInfoGain) || !Utils.sm(entrp, minEntrp))) continue;
                this.value = x;
                this.maxInfoGain = infoGain;
                this.inform = this.maxInfoGain - defInfo;
                minEntrp = entrp;
                this.isIn = isWithin;
            }
            return splitData;
        }

        @Override
        public boolean isCover(Instance inst) {
            boolean isCover = false;
            if (!inst.isMissing(this.att)) {
                if (this.isIn) {
                    if (Utils.eq(inst.value(this.att), this.value)) {
                        isCover = true;
                    }
                } else if (!Utils.eq(inst.value(this.att), this.value)) {
                    isCover = true;
                }
            }
            return isCover;
        }

        public boolean isIn() {
            return this.isIn;
        }

        @Override
        public String toString() {
            String symbol = this.isIn ? " = " : " != ";
            return this.att.name() + symbol + this.att.value((int)this.value);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5529 $");
        }
    }

    private class NumericAntd
    extends Antd {
        static final long serialVersionUID = -7957266498918210436L;
        private double splitPoint;

        public NumericAntd(Attribute a, double[] unc) {
            super(a, unc);
            this.splitPoint = Double.NaN;
        }

        public NumericAntd(Attribute a, double sq, double vl, double wts) {
            super(a, sq, vl, wts);
            this.splitPoint = Double.NaN;
        }

        public double getSplitPoint() {
            return this.splitPoint;
        }

        @Override
        public Instances[] splitData(Instances insts, double defInfo) {
            Instance inst;
            int y;
            double minSplit;
            Instances data = new Instances(insts);
            data.sort(this.att);
            int total = data.numInstances();
            this.maxInfoGain = 0.0;
            this.value = 0.0;
            if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                minSplit = 0.1 * data.sumOfWeights() / (double)ConjunctiveRule.this.m_ClassAttribute.numValues();
                if (Utils.smOrEq(minSplit, ConjunctiveRule.this.m_MinNo)) {
                    minSplit = ConjunctiveRule.this.m_MinNo;
                } else if (Utils.gr(minSplit, 25.0)) {
                    minSplit = 25.0;
                }
            } else {
                minSplit = ConjunctiveRule.this.m_MinNo;
            }
            double[] fst = null;
            double[] snd = null;
            double[] missing = null;
            if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                fst = new double[ConjunctiveRule.this.m_NumClasses];
                snd = new double[ConjunctiveRule.this.m_NumClasses];
                missing = new double[ConjunctiveRule.this.m_NumClasses];
                for (int v = 0; v < ConjunctiveRule.this.m_NumClasses; ++v) {
                    missing[v] = 0.0;
                    snd[v] = 0.0;
                    fst[v] = 0.0;
                }
            }
            double fstCover = 0.0;
            double sndCover = 0.0;
            double fstWtSq = 0.0;
            double sndWtSq = 0.0;
            double fstWtVl = 0.0;
            double sndWtVl = 0.0;
            int split = 1;
            int prev = 0;
            int finalSplit = split;
            for (int x = 0; x < data.numInstances(); ++x) {
                Instance inst2 = data.instance(x);
                if (inst2.isMissing(this.att)) {
                    total = x;
                    break;
                }
                sndCover += inst2.weight();
                if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                    int n = (int)inst2.classValue();
                    snd[n] = snd[n] + inst2.weight();
                    continue;
                }
                sndWtSq += inst2.weight() * inst2.classValue() * inst2.classValue();
                sndWtVl += inst2.weight() * inst2.classValue();
            }
            if (Utils.sm(sndCover, 2.0 * minSplit)) {
                return null;
            }
            double msingWtSq = 0.0;
            double msingWtVl = 0.0;
            Instances missingData = new Instances(data, 0);
            for (y = total; y < data.numInstances(); ++y) {
                inst = data.instance(y);
                missingData.add(inst);
                if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                    int n = (int)inst.classValue();
                    missing[n] = missing[n] + inst.weight();
                    continue;
                }
                msingWtSq += inst.weight() * inst.classValue() * inst.classValue();
                msingWtVl += inst.weight() * inst.classValue();
            }
            if (total == 0) {
                return null;
            }
            this.splitPoint = data.instance(total - 1).value(this.att);
            while (split < total) {
                if (!Utils.eq(data.instance(split).value(this.att), data.instance(prev).value(this.att))) {
                    for (y = prev; y < split; ++y) {
                        inst = data.instance(y);
                        fstCover += inst.weight();
                        sndCover -= inst.weight();
                        if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                            int n = (int)inst.classValue();
                            fst[n] = fst[n] + inst.weight();
                            int n2 = (int)inst.classValue();
                            snd[n2] = snd[n2] - inst.weight();
                            continue;
                        }
                        fstWtSq += inst.weight() * inst.classValue() * inst.classValue();
                        fstWtVl += inst.weight() * inst.classValue();
                        sndWtSq -= inst.weight() * inst.classValue() * inst.classValue();
                        sndWtVl -= inst.weight() * inst.classValue();
                    }
                    if (Utils.sm(fstCover, minSplit) || Utils.sm(sndCover, minSplit)) {
                        prev = split;
                    } else {
                        double info;
                        double infoGain;
                        boolean isFirst;
                        double sndInfoGain;
                        double sndInfo;
                        double fstInfoGain;
                        double fstInfo;
                        double sum;
                        double fstEntp = 0.0;
                        double sndEntp = 0.0;
                        if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                            fstEntp = this.entropy(fst, fstCover);
                            sndEntp = this.entropy(snd, sndCover);
                        } else {
                            fstEntp = this.wtMeanSqErr(fstWtSq, fstWtVl, fstCover) / fstCover;
                            sndEntp = this.wtMeanSqErr(sndWtSq, sndWtVl, sndCover) / sndCover;
                        }
                        if (ConjunctiveRule.this.m_ClassAttribute.isNominal()) {
                            int z;
                            sum = data.sumOfWeights();
                            double whole = sum + Utils.sum(this.uncover);
                            double[] other = null;
                            other = new double[ConjunctiveRule.this.m_NumClasses];
                            for (z = 0; z < ConjunctiveRule.this.m_NumClasses; ++z) {
                                other[z] = this.uncover[z] + snd[z] + missing[z];
                            }
                            double otherCover = whole - fstCover;
                            double otherEntropy = this.entropy(other, otherCover);
                            fstInfo = (fstEntp * fstCover + otherEntropy * otherCover) / whole;
                            fstInfoGain = defInfo - fstInfo;
                            other = new double[ConjunctiveRule.this.m_NumClasses];
                            for (z = 0; z < ConjunctiveRule.this.m_NumClasses; ++z) {
                                other[z] = this.uncover[z] + fst[z] + missing[z];
                            }
                            otherCover = whole - sndCover;
                            otherEntropy = this.entropy(other, otherCover);
                            sndInfo = (sndEntp * sndCover + otherEntropy * otherCover) / whole;
                            sndInfoGain = defInfo - sndInfo;
                        } else {
                            sum = data.sumOfWeights();
                            double otherWtSq = sndWtSq + msingWtSq + this.uncoverWtSq;
                            double otherWtVl = sndWtVl + msingWtVl + this.uncoverWtVl;
                            double otherCover = sum - fstCover + this.uncoverSum;
                            fstInfo = Utils.eq(fstCover, 0.0) ? 0.0 : fstEntp * fstCover;
                            fstInfoGain = defInfo - (fstInfo += this.wtMeanSqErr(otherWtSq, otherWtVl, otherCover));
                            otherWtSq = fstWtSq + msingWtSq + this.uncoverWtSq;
                            otherWtVl = fstWtVl + msingWtVl + this.uncoverWtVl;
                            otherCover = sum - sndCover + this.uncoverSum;
                            sndInfo = Utils.eq(sndCover, 0.0) ? 0.0 : sndEntp * sndCover;
                            sndInfoGain = defInfo - (sndInfo += this.wtMeanSqErr(otherWtSq, otherWtVl, otherCover));
                        }
                        if (Utils.gr(fstInfoGain, sndInfoGain) || Utils.eq(fstInfoGain, sndInfoGain) && Utils.sm(fstEntp, sndEntp)) {
                            isFirst = true;
                            infoGain = fstInfoGain;
                            info = fstInfo;
                        } else {
                            isFirst = false;
                            infoGain = sndInfoGain;
                            info = sndInfo;
                        }
                        boolean isUpdate = Utils.gr(infoGain, this.maxInfoGain);
                        if (isUpdate) {
                            this.splitPoint = (data.instance(split).value(this.att) + data.instance(prev).value(this.att)) / 2.0;
                            this.value = !isFirst ? 1 : 0;
                            this.inform = info;
                            this.maxInfoGain = infoGain;
                            finalSplit = split;
                        }
                        prev = split;
                    }
                }
                ++split;
            }
            Instances[] splitData = new Instances[]{new Instances(data, 0, finalSplit), new Instances(data, finalSplit, total - finalSplit), new Instances(missingData)};
            return splitData;
        }

        @Override
        public boolean isCover(Instance inst) {
            boolean isCover = false;
            if (!inst.isMissing(this.att)) {
                if (Utils.eq(this.value, 0.0)) {
                    if (Utils.smOrEq(inst.value(this.att), this.splitPoint)) {
                        isCover = true;
                    }
                } else if (Utils.gr(inst.value(this.att), this.splitPoint)) {
                    isCover = true;
                }
            }
            return isCover;
        }

        @Override
        public String toString() {
            String symbol = Utils.eq(this.value, 0.0) ? " <= " : " > ";
            return this.att.name() + symbol + Utils.doubleToString(this.splitPoint, 6);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5529 $");
        }
    }

    private abstract class Antd
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -8729076306737827571L;
        protected Attribute att;
        protected double value;
        protected double maxInfoGain;
        protected double inform;
        protected double uncoverWtSq;
        protected double uncoverWtVl;
        protected double uncoverSum;
        protected double[] uncover;

        public Antd(Attribute a, double[] unc) {
            this.att = a;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.inform = Double.NaN;
            this.uncover = unc;
        }

        public Antd(Attribute a, double uncoveredWtSq, double uncoveredWtVl, double uncoveredWts) {
            this.att = a;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.inform = Double.NaN;
            this.uncoverWtSq = uncoveredWtSq;
            this.uncoverWtVl = uncoveredWtVl;
            this.uncoverSum = uncoveredWts;
        }

        public abstract Instances[] splitData(Instances var1, double var2);

        public abstract boolean isCover(Instance var1);

        public abstract String toString();

        public Attribute getAttr() {
            return this.att;
        }

        public double getAttrValue() {
            return this.value;
        }

        public double getMaxInfoGain() {
            return this.maxInfoGain;
        }

        public double getInfo() {
            return this.inform;
        }

        protected double wtMeanSqErr(double weightedSq, double weightedValue, double sum) {
            if (Utils.smOrEq(sum, 1.0E-6)) {
                return 0.0;
            }
            return weightedSq - weightedValue * weightedValue / sum;
        }

        protected double entropy(double[] value, double sum) {
            if (Utils.smOrEq(sum, 1.0E-6)) {
                return 0.0;
            }
            double entropy = 0.0;
            for (int i = 0; i < value.length; ++i) {
                if (Utils.eq(value[i], 0.0)) continue;
                entropy -= value[i] * Utils.log2(value[i]);
            }
            entropy += sum * Utils.log2(sum);
            return entropy /= sum;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5529 $");
        }
    }
}

