/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import utilities.ClassifierTools;
import weka.classifiers.meta.RotationForest;
import weka.core.Instances;

public class OptimisedRotationForest
extends RotationForest {
    static int[] MVALUES = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    static int[] LVALUES = new int[]{5, 10, 15, 20, 25, 30, 40, 50, 60, 70};
    int folds = 10;

    @Override
    public void buildClassifier(Instances train) throws Exception {
        int bestM = 0;
        double bestAcc = 0.0;
        int bestL = 0;
        if (train.numInstances() < this.folds) {
            this.folds = train.numInstances();
        }
        for (int m : MVALUES) {
            for (int l : LVALUES) {
                RotationForest trainer = new RotationForest();
                trainer.setMaxGroup(m);
                trainer.setMinGroup(m);
                trainer.setNumIterations(l);
                double acc = ClassifierTools.stratifiedCrossValidation(train, trainer, this.folds, 0);
                if (!(acc > bestAcc)) continue;
                bestM = m;
                bestL = l;
                bestAcc = acc;
            }
        }
        this.setMaxGroup(bestM);
        this.setMinGroup(bestM);
        this.setNumIterations(bestL);
        super.buildClassifier(train);
    }
}

