/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Random;
import java.util.StringTokenizer;
import weka.core.AttributeExpression;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class CostMatrix
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -1973792250544554965L;
    private int m_size;
    protected Object[][] m_matrix;
    public static String FILE_EXTENSION = ".cost";

    public CostMatrix(int numOfClasses) {
        this.m_size = numOfClasses;
        this.initialize();
    }

    public CostMatrix(CostMatrix toCopy) {
        this(toCopy.size());
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                this.setCell(i, j, toCopy.getCell(i, j));
            }
        }
    }

    public void initialize() {
        this.m_matrix = new Object[this.m_size][this.m_size];
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                this.setCell(i, j, i == j ? new Double(0.0) : new Double(1.0));
            }
        }
    }

    public int size() {
        return this.m_size;
    }

    public int numColumns() {
        return this.size();
    }

    public int numRows() {
        return this.size();
    }

    private boolean replaceStrings() throws Exception {
        boolean nonDouble = false;
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                if (this.getCell(i, j) instanceof String) {
                    AttributeExpression temp = new AttributeExpression();
                    temp.convertInfixToPostfix((String)this.getCell(i, j));
                    this.setCell(i, j, temp);
                    nonDouble = true;
                    continue;
                }
                if (!(this.getCell(i, j) instanceof AttributeExpression)) continue;
                nonDouble = true;
            }
        }
        return nonDouble;
    }

    public Instances applyCostMatrix(Instances data, Random random) throws Exception {
        int i;
        double sumOfWeightFactors = 0.0;
        if (data.classIndex() < 0) {
            throw new Exception("Class index is not set!");
        }
        if (this.size() != data.numClasses()) {
            throw new Exception("Misclassification cost matrix has wrong format!");
        }
        if (this.replaceStrings()) {
            if (data.classAttribute().numValues() > 2) {
                throw new Exception("Can't resample/reweight instances using non-fixed cost values when there are more than two classes!");
            }
            double[] weightOfInstances = new double[data.numInstances()];
            for (int i2 = 0; i2 < data.numInstances(); ++i2) {
                Instance inst = data.instance(i2);
                int classValIndex = (int)inst.classValue();
                double factor = 1.0;
                Object element = classValIndex == 0 ? this.getCell(classValIndex, 1) : this.getCell(classValIndex, 0);
                factor = element instanceof Double ? ((Double)element).doubleValue() : ((AttributeExpression)element).evaluateExpression(inst);
                weightOfInstances[i2] = inst.weight() * factor;
            }
            if (random != null) {
                return data.resampleWithWeights(random, weightOfInstances);
            }
            Instances instances = new Instances(data);
            for (int i3 = 0; i3 < data.numInstances(); ++i3) {
                instances.instance(i3).setWeight(weightOfInstances[i3]);
            }
            return instances;
        }
        double[] weightFactor = new double[data.numClasses()];
        double[] weightOfInstancesInClass = new double[data.numClasses()];
        for (int j = 0; j < data.numInstances(); ++j) {
            int n = (int)data.instance(j).classValue();
            weightOfInstancesInClass[n] = weightOfInstancesInClass[n] + data.instance(j).weight();
        }
        double sumOfWeights = Utils.sum(weightOfInstancesInClass);
        for (i = 0; i < this.m_size; ++i) {
            if (Utils.eq((Double)this.getCell(i, i), 0.0)) continue;
            CostMatrix normMatrix = new CostMatrix(this);
            normMatrix.normalize();
            return normMatrix.applyCostMatrix(data, random);
        }
        for (i = 0; i < data.numClasses(); ++i) {
            double sumOfMissClassWeights = 0.0;
            for (int j = 0; j < data.numClasses(); ++j) {
                if (Utils.sm((Double)this.getCell(i, j), 0.0)) {
                    throw new Exception("Neg. weights in misclassification cost matrix!");
                }
                sumOfMissClassWeights += ((Double)this.getCell(i, j)).doubleValue();
            }
            weightFactor[i] = sumOfMissClassWeights * sumOfWeights;
            sumOfWeightFactors += sumOfMissClassWeights * weightOfInstancesInClass[i];
        }
        i = 0;
        while (i < data.numClasses()) {
            int n = i++;
            weightFactor[n] = weightFactor[n] / sumOfWeightFactors;
        }
        double[] weightOfInstances = new double[data.numInstances()];
        for (i = 0; i < data.numInstances(); ++i) {
            weightOfInstances[i] = data.instance(i).weight() * weightFactor[(int)data.instance(i).classValue()];
        }
        if (random != null) {
            return data.resampleWithWeights(random, weightOfInstances);
        }
        Instances instances = new Instances(data);
        for (int i4 = 0; i4 < data.numInstances(); ++i4) {
            instances.instance(i4).setWeight(weightOfInstances[i4]);
        }
        return instances;
    }

    public double[] expectedCosts(double[] classProbs) throws Exception {
        if (classProbs.length != this.m_size) {
            throw new Exception("Length of probability estimates don't match cost matrix");
        }
        double[] costs = new double[this.m_size];
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                Object element = this.getCell(y, x);
                if (!(element instanceof Double)) {
                    throw new Exception("Can't use non-fixed costs in computing expected costs.");
                }
                int n = x;
                costs[n] = costs[n] + classProbs[y] * (Double)element;
            }
        }
        return costs;
    }

    public double[] expectedCosts(double[] classProbs, Instance inst) throws Exception {
        if (classProbs.length != this.m_size) {
            throw new Exception("Length of probability estimates don't match cost matrix");
        }
        if (!this.replaceStrings()) {
            return this.expectedCosts(classProbs);
        }
        double[] costs = new double[this.m_size];
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                Object element = this.getCell(y, x);
                double costVal = !(element instanceof Double) ? ((AttributeExpression)element).evaluateExpression(inst) : ((Double)element).doubleValue();
                int n = x;
                costs[n] = costs[n] + classProbs[y] * costVal;
            }
        }
        return costs;
    }

    public double getMaxCost(int classVal) throws Exception {
        double maxCost = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.m_size; ++i) {
            Object element = this.getCell(classVal, i);
            if (!(element instanceof Double)) {
                throw new Exception("Can't use non-fixed costs when getting max cost.");
            }
            double cost = (Double)element;
            if (!(cost > maxCost)) continue;
            maxCost = cost;
        }
        return maxCost;
    }

    public double getMaxCost(int classVal, Instance inst) throws Exception {
        if (!this.replaceStrings()) {
            return this.getMaxCost(classVal);
        }
        double maxCost = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.m_size; ++i) {
            Object element = this.getCell(classVal, i);
            double cost = !(element instanceof Double) ? ((AttributeExpression)element).evaluateExpression(inst) : ((Double)element).doubleValue();
            if (!(cost > maxCost)) continue;
            maxCost = cost;
        }
        return maxCost;
    }

    public void normalize() {
        for (int y = 0; y < this.m_size; ++y) {
            double diag = (Double)this.getCell(y, y);
            for (int x = 0; x < this.m_size; ++x) {
                this.setCell(x, y, new Double((Double)this.getCell(x, y) - diag));
            }
        }
    }

    public void readOldFormat(Reader reader) throws Exception {
        int currentToken;
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        this.initialize();
        tokenizer.commentChar(37);
        tokenizer.eolIsSignificant(true);
        while (-1 != (currentToken = tokenizer.nextToken())) {
            if (currentToken == 10) continue;
            if (currentToken != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double firstIndex = tokenizer.nval;
            if (!Utils.eq((int)firstIndex, firstIndex)) {
                throw new Exception("First number in line has to be index of a class!");
            }
            if ((int)firstIndex >= this.size()) {
                throw new Exception("Class index out of range!");
            }
            currentToken = tokenizer.nextToken();
            if (-1 == currentToken) {
                throw new Exception("Premature end of file!");
            }
            if (currentToken == 10) {
                throw new Exception("Premature end of line!");
            }
            if (currentToken != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double secondIndex = tokenizer.nval;
            if (!Utils.eq((int)secondIndex, secondIndex)) {
                throw new Exception("Second number in line has to be index of a class!");
            }
            if ((int)secondIndex >= this.size()) {
                throw new Exception("Class index out of range!");
            }
            if ((int)secondIndex == (int)firstIndex) {
                throw new Exception("Diagonal of cost matrix non-zero!");
            }
            currentToken = tokenizer.nextToken();
            if (-1 == currentToken) {
                throw new Exception("Premature end of file!");
            }
            if (currentToken == 10) {
                throw new Exception("Premature end of line!");
            }
            if (currentToken != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double weight = tokenizer.nval;
            if (!Utils.gr(weight, 0.0)) {
                throw new Exception("Only positive weights allowed!");
            }
            this.setCell((int)firstIndex, (int)secondIndex, new Double(weight));
        }
    }

    public CostMatrix(Reader reader) throws Exception {
        String line;
        LineNumberReader lnr = new LineNumberReader(reader);
        int currentRow = -1;
        while ((line = lnr.readLine()) != null) {
            StringTokenizer st;
            if (line.startsWith("%") || !(st = new StringTokenizer(line)).hasMoreTokens()) continue;
            if (currentRow < 0) {
                int rows = Integer.parseInt(st.nextToken());
                if (!st.hasMoreTokens()) {
                    throw new Exception("Line " + lnr.getLineNumber() + ": expected number of columns");
                }
                int cols = Integer.parseInt(st.nextToken());
                if (rows != cols) {
                    throw new Exception("Trying to create a non-square cost matrix");
                }
                this.m_size = rows;
                this.initialize();
                ++currentRow;
                continue;
            }
            if (currentRow == this.m_size) {
                throw new Exception("Line " + lnr.getLineNumber() + ": too many rows provided");
            }
            for (int i = 0; i < this.m_size; ++i) {
                if (!st.hasMoreTokens()) {
                    throw new Exception("Line " + lnr.getLineNumber() + ": too few matrix elements provided");
                }
                String nextTok = st.nextToken();
                Double val = null;
                try {
                    val = new Double(nextTok);
                    double d = val;
                }
                catch (Exception ex) {
                    val = null;
                }
                if (val == null) {
                    this.setCell(currentRow, i, nextTok);
                    continue;
                }
                this.setCell(currentRow, i, val);
            }
            ++currentRow;
        }
        if (currentRow == -1) {
            throw new Exception("Line " + lnr.getLineNumber() + ": expected number of rows");
        }
        if (currentRow != this.m_size) {
            throw new Exception("Line " + lnr.getLineNumber() + ": too few rows provided");
        }
    }

    public void write(Writer w) throws Exception {
        w.write("% Rows\tColumns\n");
        w.write("" + this.m_size + "\t" + this.m_size + "\n");
        w.write("% Matrix elements\n");
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                w.write("" + this.getCell(i, j) + "\t");
            }
            w.write("\n");
        }
        w.flush();
    }

    public String toMatlab() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (int i = 0; i < this.m_size; ++i) {
            if (i > 0) {
                result.append("; ");
            }
            for (int n = 0; n < this.m_size; ++n) {
                if (n > 0) {
                    result.append(" ");
                }
                result.append(this.getCell(i, n));
            }
        }
        result.append("]");
        return result.toString();
    }

    public static CostMatrix parseMatlab(String matlab) throws Exception {
        String cells = matlab.substring(matlab.indexOf("[") + 1, matlab.indexOf("]")).trim();
        StringTokenizer tokRow = new StringTokenizer(cells, ";");
        int rows = tokRow.countTokens();
        StringTokenizer tokCol = new StringTokenizer(tokRow.nextToken(), " ");
        int cols = tokCol.countTokens();
        CostMatrix result = new CostMatrix(rows);
        tokRow = new StringTokenizer(cells, ";");
        rows = 0;
        while (tokRow.hasMoreTokens()) {
            tokCol = new StringTokenizer(tokRow.nextToken(), " ");
            cols = 0;
            while (tokCol.hasMoreTokens()) {
                String current = tokCol.nextToken();
                try {
                    double val = Double.parseDouble(current);
                    result.setCell(rows, cols, new Double(val));
                }
                catch (NumberFormatException e) {
                    result.setCell(rows, cols, current);
                }
                ++cols;
            }
            ++rows;
        }
        return result;
    }

    public final void setCell(int rowIndex, int columnIndex, Object value) {
        this.m_matrix[rowIndex][columnIndex] = value;
    }

    public final Object getCell(int rowIndex, int columnIndex) {
        return this.m_matrix[rowIndex][columnIndex];
    }

    public final double getElement(int rowIndex, int columnIndex) throws Exception {
        if (!(this.m_matrix[rowIndex][columnIndex] instanceof Double)) {
            throw new Exception("Cost matrix contains non-fixed costs!");
        }
        return (Double)this.m_matrix[rowIndex][columnIndex];
    }

    public final double getElement(int rowIndex, int columnIndex, Instance inst) throws Exception {
        if (this.m_matrix[rowIndex][columnIndex] instanceof Double) {
            return (Double)this.m_matrix[rowIndex][columnIndex];
        }
        if (this.m_matrix[rowIndex][columnIndex] instanceof String) {
            this.replaceStrings();
        }
        return ((AttributeExpression)this.m_matrix[rowIndex][columnIndex]).evaluateExpression(inst);
    }

    public final void setElement(int rowIndex, int columnIndex, double value) {
        this.m_matrix[rowIndex][columnIndex] = new Double(value);
    }

    public String toString() {
        double maxval = 0.0;
        boolean fractional = false;
        Object element = null;
        int widthNumber = 0;
        int widthExpression = 0;
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                element = this.getCell(i, j);
                if (element instanceof Double) {
                    double current = (Double)element;
                    if (current < 0.0) {
                        current *= -11.0;
                    }
                    if (current > maxval) {
                        maxval = current;
                    }
                    double fract = Math.abs(current - Math.rint(current));
                    if (fractional || !(Math.log(fract) / Math.log(10.0) >= -2.0)) continue;
                    fractional = true;
                    continue;
                }
                if (element.toString().length() <= widthExpression) continue;
                widthExpression = element.toString().length();
            }
        }
        if (maxval > 0.0) {
            widthNumber = (int)(Math.log(maxval) / Math.log(10.0) + (double)(fractional ? 4 : 1));
        }
        int width = widthNumber > widthExpression ? widthNumber : widthExpression;
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                element = this.getCell(i, j);
                if (element instanceof Double) {
                    text.append(" ").append(Utils.doubleToString((Double)element, width, fractional ? 2 : 0));
                    continue;
                }
                int diff = width - element.toString().length();
                if (diff > 0) {
                    int left = diff % 2;
                    String temp = Utils.padLeft(element.toString(), element.toString().length() + (left += diff / 2));
                    temp = Utils.padRight(temp, width);
                    text.append(" ").append(temp);
                    continue;
                }
                text.append(" ").append(element.toString());
            }
            text.append("\n");
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9047 $");
    }
}

