/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.classifiers.functions.SMO;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;
import weka.filters.unsupervised.attribute.Remove;

public class SVMAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6489975709033967447L;
    private double[] m_attScores;
    private int m_numToEliminate = 1;
    private int m_percentToEliminate = 0;
    private int m_percentThreshold = 0;
    private double m_smoCParameter = 1.0;
    private double m_smoTParameter = 1.0E-10;
    private double m_smoPParameter = 1.0E-25;
    private int m_smoFilterType = 0;

    public String globalInfo() {
        return "SVMAttributeEval :\n\nEvaluates the worth of an attribute by using an SVM classifier. Attributes are ranked by the square of the weight assigned by the SVM. Attribute selection for multiclass problems is handled by ranking attributes for each class seperately using a one-vs-all method and then \"dealing\" from the top of each pile to give a final ranking.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "I. Guyon and J. Weston and S. Barnhill and V. Vapnik");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        result.setValue(TechnicalInformation.Field.TITLE, "Gene selection for cancer classification using support vector machines");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "46");
        result.setValue(TechnicalInformation.Field.PAGES, "389-422");
        return result;
    }

    public SVMAttributeEval() {
        this.resetOptions();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tSpecify the constant rate of attribute\n\telimination per invocation of\n\tthe support vector machine.\n\tDefault = 1.", "X", 1, "-X <constant rate of elimination>"));
        newVector.addElement(new Option("\tSpecify the percentage rate of attributes to\n\telimination per invocation of\n\tthe support vector machine.\n\tTrumps constant rate (above threshold).\n\tDefault = 0.", "Y", 1, "-Y <percent rate of elimination>"));
        newVector.addElement(new Option("\tSpecify the threshold below which \n\tpercentage attribute elimination\n\treverts to the constant method.", "Z", 1, "-Z <threshold for percent elimination>"));
        newVector.addElement(new Option("\tSpecify the value of P (epsilon\n\tparameter) to pass on to the\n\tsupport vector machine.\n\tDefault = 1.0e-25", "P", 1, "-P <epsilon>"));
        newVector.addElement(new Option("\tSpecify the value of T (tolerance\n\tparameter) to pass on to the\n\tsupport vector machine.\n\tDefault = 1.0e-10", "T", 1, "-T <tolerance>"));
        newVector.addElement(new Option("\tSpecify the value of C (complexity\n\tparameter) to pass on to the\n\tsupport vector machine.\n\tDefault = 1.0", "C", 1, "-C <complexity>"));
        newVector.addElement(new Option("\tWhether the SVM should 0=normalize/1=standardize/2=neither.\n\t(default 0=normalize)", "N", 1, "-N"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption('X', options);
        if (optionString.length() != 0) {
            this.setAttsToEliminatePerIteration(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('Y', options)).length() != 0) {
            this.setPercentToEliminatePerIteration(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('Z', options)).length() != 0) {
            this.setPercentThreshold(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('P', options)).length() != 0) {
            this.setEpsilonParameter(new Double(optionString));
        }
        if ((optionString = Utils.getOption('T', options)).length() != 0) {
            this.setToleranceParameter(new Double(optionString));
        }
        if ((optionString = Utils.getOption('C', options)).length() != 0) {
            this.setComplexityParameter(new Double(optionString));
        }
        if ((optionString = Utils.getOption('N', options)).length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(optionString), SMO.TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, SMO.TAGS_FILTER));
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[14];
        int current = 0;
        options[current++] = "-X";
        options[current++] = "" + this.getAttsToEliminatePerIteration();
        options[current++] = "-Y";
        options[current++] = "" + this.getPercentToEliminatePerIteration();
        options[current++] = "-Z";
        options[current++] = "" + this.getPercentThreshold();
        options[current++] = "-P";
        options[current++] = "" + this.getEpsilonParameter();
        options[current++] = "-T";
        options[current++] = "" + this.getToleranceParameter();
        options[current++] = "-C";
        options[current++] = "" + this.getComplexityParameter();
        options[current++] = "-N";
        options[current++] = "" + this.m_smoFilterType;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String attsToEliminatePerIterationTipText() {
        return "Constant rate of attribute elimination.";
    }

    public String percentToEliminatePerIterationTipText() {
        return "Percent rate of attribute elimination.";
    }

    public String percentThresholdTipText() {
        return "Threshold below which percent elimination reverts to constant elimination.";
    }

    public String epsilonParameterTipText() {
        return "P epsilon parameter to pass to the SVM";
    }

    public String toleranceParameterTipText() {
        return "T tolerance parameter to pass to the SVM";
    }

    public String complexityParameterTipText() {
        return "C complexity parameter to pass to the SVM";
    }

    public String filterTypeTipText() {
        return "filtering used by the SVM";
    }

    public void setAttsToEliminatePerIteration(int cRate) {
        this.m_numToEliminate = cRate;
    }

    public int getAttsToEliminatePerIteration() {
        return this.m_numToEliminate;
    }

    public void setPercentToEliminatePerIteration(int pRate) {
        this.m_percentToEliminate = pRate;
    }

    public int getPercentToEliminatePerIteration() {
        return this.m_percentToEliminate;
    }

    public void setPercentThreshold(int pThresh) {
        this.m_percentThreshold = pThresh;
    }

    public int getPercentThreshold() {
        return this.m_percentThreshold;
    }

    public void setEpsilonParameter(double svmP) {
        this.m_smoPParameter = svmP;
    }

    public double getEpsilonParameter() {
        return this.m_smoPParameter;
    }

    public void setToleranceParameter(double svmT) {
        this.m_smoTParameter = svmT;
    }

    public double getToleranceParameter() {
        return this.m_smoTParameter;
    }

    public void setComplexityParameter(double svmC) {
        this.m_smoCParameter = svmC;
    }

    public double getComplexityParameter() {
        return this.m_smoCParameter;
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == SMO.TAGS_FILTER) {
            this.m_smoFilterType = newType.getSelectedTag().getID();
        }
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_smoFilterType, SMO.TAGS_FILTER);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new SMO().getCapabilities();
        result.setOwner(this);
        result.disable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.BINARY_ATTRIBUTES);
        result.disableAllAttributeDependencies();
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        int[][] attScoresByClass;
        this.getCapabilities().testWithFail(data);
        this.m_numToEliminate = this.m_numToEliminate > 1 ? this.m_numToEliminate : 1;
        this.m_percentToEliminate = this.m_percentToEliminate < 100 ? this.m_percentToEliminate : 100;
        this.m_percentToEliminate = this.m_percentToEliminate > 0 ? this.m_percentToEliminate : 0;
        this.m_percentThreshold = this.m_percentThreshold < data.numAttributes() ? this.m_percentThreshold : data.numAttributes() - 1;
        this.m_percentThreshold = this.m_percentThreshold > 0 ? this.m_percentThreshold : 0;
        int numAttr = data.numAttributes() - 1;
        if (data.numClasses() > 2) {
            attScoresByClass = new int[data.numClasses()][numAttr];
            for (int i = 0; i < data.numClasses(); ++i) {
                attScoresByClass[i] = this.rankBySVM(i, data);
            }
        } else {
            attScoresByClass = new int[1][numAttr];
            attScoresByClass[0] = this.rankBySVM(0, data);
        }
        ArrayList<Integer> ordered = new ArrayList<Integer>(numAttr);
        for (int i = 0; i < numAttr; ++i) {
            for (int j = 0; j < (data.numClasses() > 2 ? data.numClasses() : 1); ++j) {
                Integer rank = new Integer(attScoresByClass[j][i]);
                if (ordered.contains(rank)) continue;
                ordered.add(rank);
            }
        }
        this.m_attScores = new double[data.numAttributes()];
        Iterator listIt = ordered.iterator();
        double i = numAttr;
        while (listIt.hasNext()) {
            this.m_attScores[((Integer)listIt.next()).intValue()] = i;
            i -= 1.0;
        }
    }

    private int[] rankBySVM(int classInd, Instances data) {
        int[] origIndices = new int[data.numAttributes()];
        for (int i = 0; i < origIndices.length; ++i) {
            origIndices[i] = i;
        }
        int numAttrLeft = data.numAttributes() - 1;
        int[] attRanks = new int[numAttrLeft];
        try {
            MakeIndicator filter = new MakeIndicator();
            filter.setAttributeIndex("" + (data.classIndex() + 1));
            filter.setNumeric(false);
            filter.setValueIndex(classInd);
            filter.setInputFormat(data);
            Instances trainCopy = Filter.useFilter(data, filter);
            double pctToElim = (double)this.m_percentToEliminate / 100.0;
            while (numAttrLeft > 0) {
                int numToElim;
                if (pctToElim > 0.0) {
                    numToElim = (int)((double)trainCopy.numAttributes() * pctToElim);
                    int n = numToElim = numToElim > 1 ? numToElim : 1;
                    if (numAttrLeft - numToElim <= this.m_percentThreshold) {
                        pctToElim = 0.0;
                        numToElim = numAttrLeft - this.m_percentThreshold;
                    }
                } else {
                    numToElim = numAttrLeft >= this.m_numToEliminate ? this.m_numToEliminate : numAttrLeft;
                }
                SMO smo = new SMO();
                smo.setFilterType(new SelectedTag(this.m_smoFilterType, SMO.TAGS_FILTER));
                smo.setEpsilon(this.m_smoPParameter);
                smo.setToleranceParameter(this.m_smoTParameter);
                smo.setC(this.m_smoCParameter);
                smo.buildClassifier(trainCopy);
                double[] weightsSparse = smo.sparseWeights()[0][1];
                int[] indicesSparse = smo.sparseIndices()[0][1];
                double[] weights = new double[trainCopy.numAttributes()];
                for (int j = 0; j < weightsSparse.length; ++j) {
                    weights[indicesSparse[j]] = weightsSparse[j] * weightsSparse[j];
                }
                weights[trainCopy.classIndex()] = Double.MAX_VALUE;
                int[] featArray = new int[numToElim];
                boolean[] eliminated = new boolean[origIndices.length];
                for (int j = 0; j < numToElim; ++j) {
                    int minWeightIndex = Utils.minIndex(weights);
                    attRanks[--numAttrLeft] = origIndices[minWeightIndex];
                    featArray[j] = minWeightIndex;
                    eliminated[minWeightIndex] = true;
                    weights[minWeightIndex] = Double.MAX_VALUE;
                }
                Remove delTransform = new Remove();
                delTransform.setInvertSelection(false);
                delTransform.setAttributeIndicesArray(featArray);
                delTransform.setInputFormat(trainCopy);
                trainCopy = Filter.useFilter(trainCopy, delTransform);
                int[] temp = new int[origIndices.length - numToElim];
                int k = 0;
                for (int j = 0; j < origIndices.length; ++j) {
                    if (eliminated[j]) continue;
                    temp[k++] = origIndices[j];
                }
                origIndices = temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attRanks;
    }

    protected void resetOptions() {
        this.m_attScores = null;
    }

    @Override
    public double evaluateAttribute(int attribute) throws Exception {
        return this.m_attScores[attribute];
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_attScores == null) {
            text.append("\tSVM feature evaluator has not been built yet");
        } else {
            text.append("\tSVM feature evaluator");
        }
        text.append("\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.28 $");
    }

    public static void main(String[] args) {
        SVMAttributeEval.runEvaluator(new SVMAttributeEval(), args);
    }
}

