/*
 * Decompiled with CFR 0.152.
 */
package vector_classifiers;

import java.util.Enumeration;
import java.util.Random;
import vector_classifiers.TunedRotationForest;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.RemoveUseless;
import weka.filters.unsupervised.instance.RemovePercentage;

public class RotationForestBootstrap
extends TunedRotationForest {
    double trainPercentPerTree = 0.5;

    public RotationForestBootstrap() {
        this.m_RemovedPercentage = 0;
        this.m_ProjectionFilter = this.defaultFilter();
    }

    private Instances[] splitByClass(Instances data) {
        int numClasses = data.numClasses();
        Instances[] instancesOfClass = new Instances[numClasses + 1];
        if (data.classAttribute().isNumeric()) {
            instancesOfClass = new Instances[numClasses];
            instancesOfClass[0] = data;
        } else {
            instancesOfClass = new Instances[numClasses + 1];
            for (int i = 0; i < instancesOfClass.length; ++i) {
                instancesOfClass[i] = new Instances(data, 0);
            }
            Enumeration enu = data.enumerateInstances();
            while (enu.hasMoreElements()) {
                Instance instance = (Instance)enu.nextElement();
                if (instance.classIsMissing()) {
                    instancesOfClass[numClasses].add(instance);
                    continue;
                }
                int c = (int)instance.classValue();
                instancesOfClass[c].add(instance);
            }
            if (instancesOfClass[numClasses].numInstances() == 0) {
                Instances[] tmp = instancesOfClass;
                instancesOfClass = new Instances[numClasses];
                System.arraycopy(tmp, 0, instancesOfClass, 0, numClasses);
            }
        }
        return instancesOfClass;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        int i;
        long startTime = System.currentTimeMillis();
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        super.buildClassifier(data);
        this.checkMinMax(data);
        Random random = data.numInstances() > 0 ? data.getRandomNumberGenerator(this.m_Seed) : new Random(this.m_Seed);
        this.m_RemoveUseless = new RemoveUseless();
        this.m_RemoveUseless.setInputFormat(data);
        data = Filter.useFilter(data, this.m_RemoveUseless);
        this.m_Normalize = new Normalize();
        this.m_Normalize.setInputFormat(data);
        data = Filter.useFilter(data, this.m_Normalize);
        if (this.m_NumberOfGroups) {
            this.generateGroupsFromNumbers(data, random);
        } else {
            this.generateGroupsFromSizes(data, random);
        }
        this.m_ProjectionFilters = new Filter[this.m_Groups.length][];
        for (i = 0; i < this.m_ProjectionFilters.length; ++i) {
            this.m_ProjectionFilters[i] = Filter.makeCopies(this.m_ProjectionFilter, this.m_Groups[i].length);
        }
        this.m_Headers = new Instances[this.m_Classifiers.length];
        this.m_ReducedHeaders = new Instances[this.m_Classifiers.length][];
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            int numClasses = data.numClasses();
            Instances trainData = new Instances(data);
            Instances testData = new Instances(data, 0);
            trainData.randomize(this.rng);
            int trainSize = (int)(this.trainPercentPerTree * (double)data.numInstances());
            while (trainSize < trainData.numInstances()) {
                testData.add(trainData.remove(0));
            }
            Instances[] instancesOfClass = this.splitByClass(trainData);
            this.m_ReducedHeaders[i] = new Instances[this.m_Groups[i].length];
            FastVector<Attribute> transformedAttributes = new FastVector<Attribute>(trainData.numAttributes());
            for (int j = 0; j < this.m_Groups[i].length; ++j) {
                FastVector<Attribute> fv = new FastVector<Attribute>(this.m_Groups[i][j].length + 1);
                for (int k = 0; k < this.m_Groups[i][j].length; ++k) {
                    String newName = trainData.attribute(this.m_Groups[i][j][k]).name() + "_" + k;
                    fv.addElement(trainData.attribute(this.m_Groups[i][j][k]).copy(newName));
                }
                fv.addElement((Attribute)trainData.classAttribute().copy());
                Instances dataSubSet = new Instances("rotated-" + i + "-" + j + "-", fv, 0);
                dataSubSet.setClassIndex(dataSubSet.numAttributes() - 1);
                this.m_ReducedHeaders[i][j] = new Instances(dataSubSet, 0);
                boolean[] selectedClasses = this.selectClasses(instancesOfClass.length, random);
                for (int c = 0; c < selectedClasses.length; ++c) {
                    if (!selectedClasses[c]) continue;
                    Enumeration enu = instancesOfClass[c].enumerateInstances();
                    while (enu.hasMoreElements()) {
                        Instance instance = (Instance)enu.nextElement();
                        DenseInstance newInstance = new DenseInstance(dataSubSet.numAttributes());
                        newInstance.setDataset(dataSubSet);
                        for (int k = 0; k < this.m_Groups[i][j].length; ++k) {
                            newInstance.setValue(k, instance.value(this.m_Groups[i][j][k]));
                        }
                        newInstance.setClassValue(instance.classValue());
                        dataSubSet.add(newInstance);
                    }
                }
                dataSubSet.randomize(random);
                Instances originalDataSubSet = dataSubSet;
                dataSubSet.randomize(random);
                RemovePercentage rp = new RemovePercentage();
                rp.setPercentage(this.m_RemovedPercentage);
                rp.setInputFormat(dataSubSet);
                dataSubSet = Filter.useFilter(dataSubSet, rp);
                if (dataSubSet.numInstances() < 2) {
                    dataSubSet = originalDataSubSet;
                }
                this.m_ProjectionFilters[i][j].setInputFormat(dataSubSet);
                Instances projectedData = null;
                do {
                    try {
                        projectedData = Filter.useFilter(dataSubSet, this.m_ProjectionFilters[i][j]);
                    }
                    catch (Exception e) {
                        this.addRandomInstances(dataSubSet, 10, random);
                    }
                } while (projectedData == null);
                for (int a = 0; a < projectedData.numAttributes() - 1; ++a) {
                    String newName = projectedData.attribute(a).name() + "_" + j;
                    transformedAttributes.addElement(projectedData.attribute(a).copy(newName));
                }
            }
            transformedAttributes.addElement((Attribute)trainData.classAttribute().copy());
            Instances buildClas = new Instances("rotated-" + i + "-", transformedAttributes, 0);
            buildClas.setClassIndex(buildClas.numAttributes() - 1);
            this.m_Headers[i] = new Instances(buildClas, 0);
            Enumeration enu = trainData.enumerateInstances();
            while (enu.hasMoreElements()) {
                Instance instance = (Instance)enu.nextElement();
                Instance newInstance = this.convertInstance(instance, i);
                buildClas.add(newInstance);
            }
            if (this.m_Classifier instanceof Randomizable) {
                ((Randomizable)((Object)this.m_Classifiers[i])).setSeed(random.nextInt());
            }
            this.m_Classifiers[i].buildClassifier(buildClas);
        }
        if (this.m_Debug) {
            this.printGroups();
        }
        this.res.buildTime = System.currentTimeMillis() - startTime;
    }

    public static void main(String[] args) {
    }
}

