/*
 * Decompiled with CFR 0.152.
 */
package vector_classifiers;

import utilities.GenericTools;
import weka.classifiers.functions.PLSClassifier;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class PLSDepricated
extends PLSClassifier {
    protected Attribute classAttribute;
    protected double[] numericClassVals;
    protected int classind;

    @Override
    public void buildClassifier(Instances data) throws Exception {
        Instances train = new Instances(data);
        this.classind = train.classIndex();
        this.classAttribute = train.classAttribute();
        this.numericClassVals = new double[this.classAttribute.numValues()];
        for (int i = 0; i < this.numericClassVals.length; ++i) {
            this.numericClassVals[i] = this.convertNominalToNumeric(this.classAttribute.value(i));
        }
        FastVector<Attribute> atts = new FastVector<Attribute>(train.numAttributes());
        for (int i = 0; i < train.numAttributes(); ++i) {
            if (i != this.classind) {
                atts.add(train.attribute(i));
                continue;
            }
            Attribute numericClassAtt = new Attribute(train.attribute(i).name());
            atts.add(numericClassAtt);
        }
        Instances temp = new Instances(train.relationName(), atts, train.numInstances());
        temp.setClassIndex(this.classind);
        for (int i = 0; i < train.numInstances(); ++i) {
            temp.add(new DenseInstance(1.0, train.instance(i).toDoubleArray()));
            temp.instance(i).setClassValue(this.numericClassVals[(int)train.instance(i).classValue()]);
        }
        train = temp;
        super.buildClassifier(train);
    }

    protected double convertNominalToNumeric(String strClassVal) {
        return Double.parseDouble(strClassVal.replaceAll("[A-Za-z ]", ""));
    }

    public double regressInstance(Instance instance) throws Exception {
        return super.classifyInstance(instance);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        return GenericTools.indexOfMax(this.distributionForInstance(instance));
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double regpred = this.regressInstance(instance);
        double[] dist = new double[this.numericClassVals.length];
        if (regpred < this.numericClassVals[0]) {
            dist[0] = 1.0;
        } else if (regpred > this.numericClassVals[this.numericClassVals.length - 1]) {
            dist[dist.length - 1] = 1.0;
        } else {
            for (int i = 1; i < this.numericClassVals.length; ++i) {
                double propToRight;
                if (!(regpred < this.numericClassVals[i])) continue;
                double end = this.numericClassVals[i] - this.numericClassVals[i - 1];
                double t = regpred - this.numericClassVals[i - 1];
                dist[i] = propToRight = t / end;
                dist[i - 1] = 1.0 - propToRight;
                break;
            }
        }
        return dist;
    }
}

