/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.File;
import java.io.FileWriter;
import weka.classifiers.Classifier;
import weka.core.Instances;

public interface WritableTestResults
extends Classifier {
    default public void writeTestResultsToFile(Instances testData, String datasetName, String classifierName, String paramLine, String outputFilePathAndName) throws Exception {
        new File(outputFilePathAndName).getParentFile().mkdirs();
        FileWriter out = new FileWriter(outputFilePathAndName);
        out.close();
        if (!new File(outputFilePathAndName).exists()) {
            throw new Exception("Error: could not create file " + outputFilePathAndName);
        }
        int correct = 0;
        StringBuilder outBuilder = new StringBuilder();
        for (int i = 0; i < testData.numInstances(); ++i) {
            double actual = testData.instance(i).classValue();
            double[] dists = this.distributionForInstance(testData.instance(i));
            StringBuilder lineBuilder = new StringBuilder();
            double bsfClass = -1.0;
            double bsfWeight = -1.0;
            for (int c = 0; c < dists.length; ++c) {
                if (dists[c] > bsfWeight) {
                    bsfWeight = dists[c];
                    bsfClass = c;
                }
                lineBuilder.append(",").append(dists[c]);
            }
            if (bsfClass == actual) {
                ++correct;
            }
            outBuilder.append(actual).append(",").append(bsfClass).append(",").append(lineBuilder.toString()).append("\n");
        }
        out = new FileWriter(outputFilePathAndName);
        out.append(datasetName + "," + classifierName + ",test\n");
        out.append(paramLine + "\n");
        out.append((double)correct / (double)testData.numInstances() + "\n");
        out.append(outBuilder.toString());
        out.close();
    }
}

