/*
 * Decompiled with CFR 0.152.
 */
package transformations;

import fileIO.OutFile;
import transformations.Transformations;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.functions.LinearRegression;
import weka.core.Instance;
import weka.core.Instances;

public class BoxCox
extends Transformations {
    public static double MIN = -3.0;
    public static double MAX = 3.0;
    public static double INTERVAL = 0.25;
    boolean tryZero = false;
    AbstractClassifier c;
    double minError = Double.MAX_VALUE;
    double bestLambda;
    double gamma;
    boolean strictlyPositive = true;

    public BoxCox() {
        this.supervised = true;
        this.response = true;
        this.minError = Double.MAX_VALUE;
        this.bestLambda = MIN;
        this.c = new LinearRegression();
        String[] options = new String[]{"-S 1", "-C "};
        try {
            this.c.setOptions(options);
        }
        catch (Exception e) {
            System.out.println(" Error Setting options in constructor");
        }
    }

    public void setStrictlyPos(boolean f) {
        this.strictlyPositive = f;
    }

    public BoxCox(AbstractClassifier c) {
        this();
        this.c = c;
    }

    public static void transformResponse(Instances data, double lambda, double[] response) {
        int responsePos = data.numAttributes() - 1;
        for (int i = 0; i < response.length; ++i) {
            Instance inst = data.instance(i);
            double v = (Math.pow(response[i], lambda) - 1.0) / lambda;
            inst.setValue(responsePos, v);
        }
    }

    @Override
    public Instances transform(Instances data) {
        Instance inst;
        int i;
        int responsePos = data.classIndex();
        double[] response = data.attributeToDoubleArray(responsePos);
        double[] predictions = new double[response.length];
        this.gamma = response[0];
        for (i = 1; i < response.length; ++i) {
            if (!(response[i] < this.gamma)) continue;
            this.gamma = response[i];
        }
        System.out.println(" Min value = " + this.gamma);
        if (this.gamma <= 0.0) {
            this.gamma = -2.0 * this.gamma + 1.0;
            System.out.println(" Data series is not strictly positive, rescaling by " + this.gamma);
            i = 0;
            while (i < response.length) {
                int n = i++;
                response[n] = response[n] + this.gamma;
            }
        }
        for (double lambda = MIN; lambda <= MAX; lambda += INTERVAL) {
            if (lambda == 0.0) {
                lambda += INTERVAL;
            }
            BoxCox.transformResponse(data, lambda, response);
            try {
                this.c.buildClassifier(data);
                for (int i2 = 0; i2 < predictions.length; ++i2) {
                    inst = data.instance(i2);
                    predictions[i2] = this.c.classifyInstance(inst);
                }
            }
            catch (Exception e) {
                System.out.println(" Error building with lambda = " + lambda);
            }
            double SSE = 0.0;
            boolean f = true;
            for (int i3 = 0; i3 < predictions.length; ++i3) {
                int n = i3;
                predictions[n] = predictions[n] * lambda;
                int n2 = i3;
                predictions[n2] = predictions[n2] + 1.0;
                predictions[i3] = predictions[i3] <= 0.0 ? 0.0 : (lambda > 0.0 ? Math.pow(predictions[i3], 1.0 / lambda) : 1.0 / Math.pow(predictions[i3], -1.0 / lambda));
                SSE += (predictions[i3] - response[i3]) * (predictions[i3] - response[i3]);
            }
            System.out.println("lambda = " + lambda + "SSE =" + (SSE /= (double)(data.numInstances() - data.numAttributes())));
            if (!(SSE < this.minError)) continue;
            this.minError = SSE;
            this.bestLambda = lambda;
        }
        System.out.println("Min lambda = " + this.bestLambda + " with MSE = " + this.minError);
        for (int i4 = 0; i4 < response.length; ++i4) {
            inst = data.instance(i4);
            double v = (Math.pow(response[i4], this.bestLambda) - 1.0) / this.bestLambda;
            inst.setValue(responsePos, v);
        }
        return data;
    }

    @Override
    public Instances invert(Instances data) {
        int responsePos = data.numAttributes() - 1;
        double[] response = data.attributeToDoubleArray(responsePos);
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            double v = response[i] * this.bestLambda;
            v += 1.0;
            v = Math.pow(v, 1.0 / this.bestLambda);
            inst.setValue(responsePos, v);
        }
        return data;
    }

    @Override
    public Instances staticTransform(Instances data) {
        int responsePos = data.numAttributes() - 1;
        double[] response = data.attributeToDoubleArray(responsePos);
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            double v = (Math.pow(response[i], this.bestLambda) - 1.0) / this.bestLambda;
            inst.setValue(responsePos, v);
        }
        return data;
    }

    @Override
    public double[] invertPredictedResponse(double[] d) {
        for (int i = 0; i < d.length; ++i) {
            double v = d[i] * this.bestLambda;
            d[i] = Math.pow(v += 1.0, 1.0 / this.bestLambda);
        }
        return d;
    }

    public static void main(String[] args) {
        double[] quantiles = Transformations.getNormalQuantiles(0.0, 1.0);
        for (int i = 0; i < quantiles.length; ++i) {
            System.out.println("Quantile " + i + " = " + quantiles[i]);
        }
        OutFile of = new OutFile("TestQuantiles.csv");
        for (int i = 0; i < quantiles.length; ++i) {
            System.out.println(i + "," + (double)(i + 1) / (double)quantiles.length + "," + quantiles[i]);
            of.writeLine(i + "," + (double)(i + 1) / (double)quantiles.length + "," + quantiles[i]);
        }
    }
}

