/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import timeseriesweka.filters.shapelet_transforms.search_functions.ImpRandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.generic_storage.Triple;
import weka.core.Instances;

public class SubsampleRandomSearch
extends ImpRandomSearch {
    float shapeletToSeriesRatio;

    protected SubsampleRandomSearch(ShapeletSearchOptions ops) {
        super(ops);
        this.shapeletToSeriesRatio = ops.getProportion();
    }

    @Override
    public void init(Instances input) {
        super.init(input);
        int numInstances = (int)((float)input.numInstances() * this.shapeletToSeriesRatio);
        int numAttributes = this.seriesLength - 1;
        this.inputData = input;
        int numLengths = this.maxShapeletLength - this.minShapeletLength;
        int i = 0;
        while ((long)i < this.numShapelets) {
            int series = this.random.nextInt(numInstances);
            int length = this.random.nextInt(numLengths) + this.minShapeletLength;
            int position = this.random.nextInt(numAttributes - length + 1);
            int dimension = this.random.nextInt(this.numDimensions);
            ArrayList<Triple<Integer, Integer, Integer>> shapeletList = (ArrayList<Triple<Integer, Integer, Integer>>)this.shapeletsToFind.get(series);
            if (shapeletList == null) {
                shapeletList = new ArrayList<Triple<Integer, Integer, Integer>>();
            }
            shapeletList.add(new Triple<Integer, Integer, Integer>(length, position, dimension));
            this.shapeletsToFind.put(series, shapeletList);
            ++i;
        }
    }
}

