/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;

public class ShapeletSearchOptions {
    private final int min;
    private final int max;
    private final long seed;
    private final long numShapelets;
    private final int lengthInc;
    private final int posInc;
    private final float proportion;
    private final int maxIterations;
    private final long timeLimit;
    private final ShapeletSearch.SearchType searchType;
    private final int numDimensions;
    private final int[] lengthDistribution;

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public long getSeed() {
        return this.seed;
    }

    public long getNumShapelets() {
        return this.numShapelets;
    }

    public int getLengthInc() {
        return this.lengthInc;
    }

    public int getPosInc() {
        return this.posInc;
    }

    public float getProportion() {
        return this.proportion;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public ShapeletSearch.SearchType getSearchType() {
        return this.searchType;
    }

    public int[] getLengthDistribution() {
        return this.lengthDistribution;
    }

    public int getNumDimensions() {
        return this.numDimensions;
    }

    protected ShapeletSearchOptions(Builder ops) {
        this.min = ops.min;
        this.max = ops.max;
        this.seed = ops.seed;
        this.numShapelets = ops.numShapelets;
        this.lengthInc = ops.lengthInc;
        this.posInc = ops.posInc;
        this.proportion = ops.proportion;
        this.maxIterations = ops.maxIterations;
        this.timeLimit = ops.timeLimit;
        this.searchType = ops.searchType;
        this.numDimensions = ops.numDimensions;
        this.lengthDistribution = ops.lengthDistribution;
    }

    public static class Builder {
        private int min;
        private int max;
        private long seed;
        private long numShapelets;
        private int lengthInc = 1;
        private int posInc = 1;
        private float proportion = 1.0f;
        private int maxIterations;
        private long timeLimit;
        private ShapeletSearch.SearchType searchType;
        private int[] lengthDistribution;
        private int numDimensions = 1;

        public Builder setNumDimensions(int dim) {
            this.numDimensions = dim;
            return this;
        }

        public Builder setLengthDistribution(int[] lengthDist) {
            this.lengthDistribution = lengthDist;
            return this;
        }

        public Builder setSearchType(ShapeletSearch.SearchType st) {
            this.searchType = st;
            return this;
        }

        public Builder setTimeLimit(long lim) {
            this.timeLimit = lim;
            return this;
        }

        public Builder setMin(int min) {
            this.min = min;
            return this;
        }

        public Builder setMax(int max) {
            this.max = max;
            return this;
        }

        public Builder setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder setNumShapelets(long numShapelets) {
            this.numShapelets = numShapelets;
            return this;
        }

        public Builder setLengthInc(int lengthInc) {
            this.lengthInc = lengthInc;
            return this;
        }

        public Builder setPosInc(int posInc) {
            this.posInc = posInc;
            return this;
        }

        public Builder setProportion(float proportion) {
            this.proportion = proportion;
            return this;
        }

        public Builder setMaxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            return this;
        }

        public ShapeletSearchOptions build() {
            this.setDefaults();
            return new ShapeletSearchOptions(this);
        }

        public void setDefaults() {
            if (this.searchType == null) {
                this.searchType = ShapeletSearch.SearchType.FULL;
            }
        }
    }
}

