/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.search_functions.RandomTimedSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import weka.core.Instance;

public class LocalSearch
extends RandomTimedSearch {
    int maxIterations;
    private static final int START_DEC = 0;
    private static final int START_INC = 1;
    private static final int LENGTH_DEC = 2;
    private static final int LENGTH_INC = 3;

    protected LocalSearch(ShapeletSearchOptions ops) {
        super(ops);
        this.maxIterations = ops.getMaxIterations();
    }

    @Override
    public ArrayList<Shapelet> SearchForShapeletsInSeries(Instance timeSeries, ShapeletSearch.ProcessCandidate checkCandidate) {
        ArrayList<Shapelet> seriesShapelets = new ArrayList<Shapelet>();
        int numLengths = this.maxShapeletLength - this.minShapeletLength;
        this.visited = new boolean[numLengths][];
        for (int currentIterations = 0; currentIterations < this.maxIterations; ++currentIterations) {
            Shapelet shape;
            int lengthIndex = this.random.nextInt(numLengths);
            int length = lengthIndex + this.minShapeletLength;
            int maxPositions = this.seriesLength - length;
            int start = this.random.nextInt(maxPositions);
            this.initVisitedMemory(this.seriesLength, length);
            if (this.visited[lengthIndex][start] || (shape = this.evaluateShapelet(timeSeries, start, length, checkCandidate)) == null) continue;
            seriesShapelets.add(shape);
        }
        return seriesShapelets;
    }

    private Shapelet evaluateShapelet(Instance series, int start, int length, ShapeletSearch.ProcessCandidate checkCandidate) {
        int index;
        Shapelet shapelet = this.visitCandidate(series, start, length, checkCandidate);
        if (shapelet == null) {
            return shapelet;
        }
        Shapelet bsf_shapelet = shapelet;
        do {
            Shapelet[] shapelets = new Shapelet[4];
            int startDec = start - 1;
            int startInc = start + 1;
            int lengthDec = length - 1;
            int lengthInc = length + 1;
            if (startDec >= 0) {
                shapelets[0] = this.visitCandidate(series, startDec, length, checkCandidate);
            }
            if (startInc < this.seriesLength - length) {
                shapelets[1] = this.visitCandidate(series, startInc, length, checkCandidate);
            }
            if (lengthDec > this.minShapeletLength && start < this.seriesLength - lengthDec) {
                shapelets[2] = this.visitCandidate(series, start, lengthDec, checkCandidate);
            }
            if (lengthInc < this.maxShapeletLength && start < this.seriesLength - lengthInc) {
                shapelets[3] = this.visitCandidate(series, start, lengthInc, checkCandidate);
            }
            index = -1;
            for (int i = 0; i < shapelets.length; ++i) {
                Shapelet shape = shapelets[i];
                if (shape == null || !(shape.qualityValue > bsf_shapelet.qualityValue) && (shape.qualityValue != bsf_shapelet.qualityValue || i != 3)) continue;
                index = i;
                bsf_shapelet = shape;
            }
            start = bsf_shapelet.startPos;
            length = bsf_shapelet.length;
        } while (index != -1);
        return bsf_shapelet;
    }
}

