/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.quality_measures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import utilities.class_distributions.ClassDistribution;
import utilities.class_distributions.TreeSetClassDistribution;

public abstract class ShapeletQualityBound
implements Serializable {
    protected double bsfQuality;
    protected List<OrderLineObj> orderLine;
    protected ClassDistribution orderLineClassDist;
    protected ClassDistribution parentClassDist;
    protected int numInstances;
    protected int percentage;

    protected void initParentFields(ClassDistribution classDist, int percentage) {
        this.bsfQuality = Double.MAX_VALUE;
        this.orderLine = new ArrayList<OrderLineObj>();
        this.orderLineClassDist = new TreeSetClassDistribution();
        this.parentClassDist = classDist;
        this.percentage = percentage;
        this.numInstances = 0;
        for (Double key : this.parentClassDist.keySet()) {
            this.orderLineClassDist.put(key, 0);
            this.numInstances += this.parentClassDist.get(key);
        }
    }

    public void setBsfQuality(double quality) {
        this.bsfQuality = quality;
    }

    public void updateOrderLine(OrderLineObj orderLineObj) {
        this.orderLineClassDist.put(orderLineObj.getClassVal(), this.orderLineClassDist.get(orderLineObj.getClassVal()) + 1);
        int index = Collections.binarySearch(this.orderLine, orderLineObj);
        if (index < 0) {
            index *= -1;
            --index;
        }
        this.orderLine.add(index, orderLineObj);
    }

    protected abstract double calculateBestQuality();

    public boolean pruneCandidate() {
        if (this.bsfQuality == Double.MAX_VALUE || this.orderLine.size() * 100 / this.numInstances <= this.percentage) {
            return false;
        }
        return this.calculateBestQuality() <= this.bsfQuality;
    }
}

