/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.quality_measures;

import java.util.Iterator;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityBound;
import utilities.class_distributions.ClassDistribution;
import utilities.class_distributions.SimpleClassDistribution;

public class MoodsMedianBound
extends ShapeletQualityBound {
    protected MoodsMedianBound(ClassDistribution classDist, int percentage) {
        this.initParentFields(classDist, percentage);
    }

    @Override
    protected double calculateBestQuality() {
        int lengthOfOrderline = this.orderLine.size();
        double median = lengthOfOrderline % 2 == 0 ? (((OrderLineObj)this.orderLine.get(lengthOfOrderline / 2 - 1)).getDistance() + ((OrderLineObj)this.orderLine.get(lengthOfOrderline / 2)).getDistance()) / 2.0 : ((OrderLineObj)this.orderLine.get(lengthOfOrderline / 2)).getDistance();
        int totalCount = this.orderLine.size();
        int countBelow = 0;
        int countAbove = 0;
        int numClasses = this.parentClassDist.size();
        SimpleClassDistribution classCountsBelowMedian = new SimpleClassDistribution(numClasses);
        SimpleClassDistribution classCountsAboveMedian = new SimpleClassDistribution(numClasses);
        for (OrderLineObj orderLine1 : this.orderLine) {
            double distance = orderLine1.getDistance();
            double classVal = orderLine1.getClassVal();
            if (distance < median) {
                ++countBelow;
                ((ClassDistribution)classCountsBelowMedian).addTo(classVal, 1);
                continue;
            }
            ++countAbove;
            ((ClassDistribution)classCountsAboveMedian).addTo(classVal, 1);
        }
        Iterator<Object> iterator = this.orderLineClassDist.keySet().iterator();
        while (iterator.hasNext()) {
            double key = (Double)iterator.next();
            int predictedCount = this.parentClassDist.get(key) - this.orderLineClassDist.get(key);
            if (((ClassDistribution)classCountsBelowMedian).get(key) <= ((ClassDistribution)classCountsAboveMedian).get(key)) {
                ((ClassDistribution)classCountsAboveMedian).addTo(key, predictedCount);
                countAbove += predictedCount;
            } else {
                ((ClassDistribution)classCountsBelowMedian).addTo(key, predictedCount);
                countBelow += predictedCount;
            }
            totalCount += predictedCount;
        }
        double chi = 0.0;
        double expectedAbove = 0.0;
        for (int i = 0; i < numClasses; ++i) {
            double expectedBelow = (double)(countBelow * this.parentClassDist.get((double)i)) / (double)totalCount;
            double classCountsBelow = (double)((ClassDistribution)classCountsBelowMedian).get(i) - expectedBelow;
            double classCountsAbove = (double)((ClassDistribution)classCountsAboveMedian).get(i) - expectedAbove;
            chi += classCountsBelow * classCountsBelow / expectedBelow;
            expectedAbove = (double)(countAbove * this.parentClassDist.get((double)i)) / (double)totalCount;
            chi += classCountsAbove * classCountsAbove / expectedAbove;
        }
        if (Double.isNaN(chi)) {
            chi = 0.0;
        }
        return chi;
    }

    @Override
    public boolean pruneCandidate() {
        if (this.orderLine.size() % this.parentClassDist.size() != 0) {
            return false;
        }
        return super.pruneCandidate();
    }
}

