/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.distance_functions;

import java.io.Serializable;
import timeseriesweka.filters.shapelet_transforms.distance_functions.MultivariateDistance;
import utilities.MultivariateInstanceTools;
import weka.core.Instance;

public class MultivariateIndependentDistance
extends MultivariateDistance
implements Serializable {
    @Override
    public double calculate(Instance timeSeries, int timeSeriesId) {
        Instance[] channel = MultivariateInstanceTools.splitMultivariateInstance(timeSeries);
        double cumulative_distance = 0.0;
        for (int i = 0; i < channel.length; ++i) {
            cumulative_distance += this.calculate(this.cand.getShapeletContent(i), channel[i].toDoubleArray());
        }
        return cumulative_distance;
    }

    public double calculate(double[] shape, double[] timeSeries) {
        double bestSum = Double.MAX_VALUE;
        for (int i = 0; i < timeSeries.length - this.length + 1; ++i) {
            double sum = 0.0;
            double[] subseq = new double[this.length];
            System.arraycopy(timeSeries, i, subseq, 0, this.length);
            subseq = this.zNormalise(subseq, false);
            for (int j = 0; j < this.length; ++j) {
                this.incrementCount();
                double temp = shape[j] - subseq[j];
                sum += temp * temp;
            }
            if (!(sum < bestSum)) continue;
            bestSum = sum;
        }
        double dist = bestSum == 0.0 ? 0.0 : 1.0 / (double)this.length * bestSum;
        return dist;
    }
}

