/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import java.io.FileReader;
import timeseriesweka.filters.FFT;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class PowerSpectrum
extends FFT {
    boolean log = false;
    FFT fftFilter = new FFT();

    public void takeLogs(boolean x) {
        this.log = x;
    }

    public PowerSpectrum() {
        this.fftFilter.useDFT();
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int length = this.fftFilter.findLength(inputFormat);
        length /= 2;
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < length; ++i) {
            String name = "PowerSpectrum_" + i;
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("PowerSpectrum" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public Instances process(Instances instances) throws Exception {
        Instances output = this.determineOutputFormat(instances);
        Instances fft = this.fftFilter.process(instances);
        int length = fft.numAttributes();
        if (instances.classIndex() >= 0) {
            --length;
        }
        length /= 2;
        if (this.log) {
            for (int i = 0; i < fft.numInstances(); ++i) {
                Instance f = fft.instance(i);
                DenseInstance inst = new DenseInstance(length + 1);
                for (int j = 0; j < length; ++j) {
                    double l1 = f.value(j * 2) * f.value(j * 2) + f.value(j * 2 + 1) * f.value(j * 2 + 1);
                    inst.setValue(j, Math.log(l1));
                }
                if (output.classIndex() >= 0) {
                    inst.setValue(length, output.instance(i).classValue());
                }
                output.add(inst);
            }
        } else {
            for (int i = 0; i < fft.numInstances(); ++i) {
                Instance f = fft.instance(i);
                DenseInstance inst = new DenseInstance(length + 1);
                for (int j = 0; j < length; ++j) {
                    inst.setValue(j, f.value(j * 2) * f.value(j * 2) + f.value(j * 2 + 1) * f.value(j * 2 + 1));
                }
                if (output.classIndex() >= 0) {
                    inst.setValue(length, fft.instance(i).classValue());
                }
                output.add(inst);
            }
        }
        return output;
    }

    public static void waferTest() {
    }

    public static double[] powerSpectrum(double[] d) {
        if ((d.length & d.length - 1) != 0) {
            return null;
        }
        FFT.Complex[] c = new FFT.Complex[d.length];
        for (int j = 0; j < d.length; ++j) {
            c[j] = new FFT.Complex(d[j], 0.0);
        }
        FFT f = new FFT();
        f.fft(c, c.length);
        double[] ps = new double[c.length];
        for (int i = 0; i < c.length; ++i) {
            ps[i] = c[i].getReal() * c[i].getReal() + c[i].getImag() * c[i].getImag();
        }
        return ps;
    }

    public static Instances loadData(String fullPath) {
        Instances d = null;
        try {
            FileReader r = new FileReader(fullPath + ".arff");
            d = new Instances(r);
            d.setClassIndex(d.numAttributes() - 1);
        }
        catch (Exception e) {
            System.out.println("Unable to load data on path " + fullPath + " Exception thrown =" + e);
            e.printStackTrace();
            System.exit(0);
        }
        return d;
    }

    public static void matlabComparison() {
    }

    public static void main(String[] args) {
        PowerSpectrum.matlabComparison();
        System.exit(0);
        PowerSpectrum ps = new PowerSpectrum();
        System.out.println(" " + ps.getInputFormat());
        Instances in = PowerSpectrum.loadData("C:\\Research\\Data\\Time Series Classification\\Beef\\Beef_Train");
        try {
            Instances out = ps.process(in);
            System.out.println(" " + out.numAttributes() + " " + out.numInstances());
            Instance ins = out.instance(0);
            double[] vals = ins.toDoubleArray();
            System.out.println(" Class index =" + out.classIndex());
            System.out.println(" Num atts =" + out.numAttributes());
            System.out.println(" " + ins.value(out.classIndex()));
        }
        catch (Exception e) {
            System.out.println(" Error =" + e);
            e.printStackTrace();
        }
    }
}

