/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class Differences
extends SimpleBatchFilter {
    private int order = 1;
    String attName = "";
    private static final long serialVersionUID = 1L;

    public void setOrder(int m) {
        this.order = m;
    }

    public void setAttName(String s) {
        this.attName = s;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed in Moments");
        }
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < inputFormat.numAttributes() - this.order - 1; ++i) {
            String name = this.attName + "Difference" + this.order + "_" + (i + 1);
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("Difference" + this.order + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public Instances process(Instances inst) throws Exception {
        Instances output = this.determineOutputFormat(inst);
        for (int i = 0; i < inst.numInstances(); ++i) {
            double[] d = inst.instance(i).toDoubleArray();
            int c = inst.classIndex();
            if (c >= 0) {
                double[] temp = new double[d.length - 1];
                System.arraycopy(d, 0, temp, 0, c);
                d = temp;
            }
            double[] diffs = c >= 0 ? new double[output.numAttributes() - 1] : new double[output.numAttributes()];
            for (int j = 0; j < diffs.length; ++j) {
                diffs[j] = d[j] - d[j + this.order];
            }
            DenseInstance newInst = null;
            newInst = c >= 0 ? new DenseInstance(diffs.length + 1) : new DenseInstance(diffs.length);
            for (int j = 0; j < diffs.length; ++j) {
                newInst.setValue(j, diffs[j]);
            }
            if (c >= 0) {
                newInst.setValue(output.classIndex(), inst.instance(i).classValue());
            }
            output.add(newInst);
        }
        return output;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public static void main(String[] args) {
    }
}

