/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.Matrix;
import weka.filters.SimpleBatchFilter;

public class Correlation
extends SimpleBatchFilter {
    Matrix covariance;
    Matrix eigenvectors;
    Matrix X;
    int numAtts = 0;

    private void findCovariance(Instances inst) {
        int j;
        this.setOutputFormat(inst);
        this.numAtts = inst.numAttributes();
        int c = inst.classIndex();
        if (c > 0) {
            --this.numAtts;
        }
        double[][] d = new double[inst.numInstances()][this.numAtts];
        for (int i = 0; i < inst.numInstances(); ++i) {
            Instance x = inst.instance(i);
            for (j = 0; j < this.numAtts; ++j) {
                d[i][j] = x.value(j);
            }
        }
        for (j = 0; j < this.numAtts; ++j) {
            int i;
            double mean = 0.0;
            for (i = 0; i < inst.numInstances(); ++i) {
                mean += d[i][j];
            }
            mean /= (double)inst.numInstances();
            for (i = 0; i < inst.numInstances(); ++i) {
                double[] dArray = d[i];
                int n = j;
                dArray[n] = dArray[n] - mean;
            }
        }
        this.X = new Matrix(d);
        this.covariance = this.X.transpose().times(this.X);
        this.covariance.timesEquals(1.0 / ((double)inst.numInstances() - 1.0));
    }

    public void findEigenVectors() {
        EigenvalueDecomposition ev = new EigenvalueDecomposition(this.covariance);
        this.eigenvectors = ev.getV();
    }

    @Override
    public Instances process(Instances inst) throws Exception {
        Instances result = this.determineOutputFormat(inst);
        this.findCovariance(inst);
        this.findEigenVectors();
        Matrix y = this.eigenvectors.times(this.X);
        for (int i = 0; i < inst.numInstances(); ++i) {
            DenseInstance in = new DenseInstance(inst.instance(i));
            for (int j = 0; j < this.numAtts; ++j) {
                in.setValue(j, y.get(i, j));
            }
            result.add(in);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return null;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        throw new Exception("Added: 6/3/13. FILTER CORRELTATION IS NOT CORRECTLY IMPLEMENTED, DO NOT USE");
    }

    @Override
    public String globalInfo() {
        return null;
    }

    public static void main(String[] args) {
        double[] evals;
        double[][] d = new double[][]{{1.0, 2.0, 1.0}, {6.0, -1.0, 0.0}, {-1.0, -2.0, -1.0}};
        Matrix m = new Matrix(d);
        EigenvalueDecomposition ev = new EigenvalueDecomposition(m);
        Matrix eigenvectors = ev.getV();
        for (double x : evals = ev.getRealEigenvalues()) {
            System.out.println(x);
        }
        System.out.println(eigenvectors);
        Matrix y = ev.getD();
        System.out.println(y);
        System.exit(0);
    }
}

