/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import timeseriesweka.filters.SAX;
import utilities.ClassifierTools;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.filters.NormalizeCase;
import weka.filters.SimpleBatchFilter;

public class BagOfPatternsFilter
extends SimpleBatchFilter {
    public TreeSet<String> dictionary;
    private final int windowSize;
    private final int numIntervals;
    private final int alphabetSize;
    private boolean useRealAttributes = true;
    private boolean numerosityReduction = false;
    private FastVector alphabet = null;
    private static final long serialVersionUID = 1L;

    public BagOfPatternsFilter(int PAA_intervalsPerWindow, int SAX_alphabetSize, int windowSize) {
        this.numIntervals = PAA_intervalsPerWindow;
        this.alphabetSize = SAX_alphabetSize;
        this.windowSize = windowSize;
        this.alphabet = SAX.getAlphabet(SAX_alphabetSize);
    }

    public int getWindowSize() {
        return this.numIntervals;
    }

    public int getNumIntervals() {
        return this.numIntervals;
    }

    public int getAlphabetSize() {
        return this.alphabetSize;
    }

    public void useRealValuedAttributes(boolean b) {
        this.useRealAttributes = b;
    }

    public void performNumerosityReduction(boolean b) {
        this.numerosityReduction = b;
    }

    private HashMap<String, Integer> buildHistogram(LinkedList<double[]> patterns) {
        HashMap<String, Integer> hist = new HashMap<String, Integer>();
        for (double[] pattern : patterns) {
            String word = "";
            for (int j = 0; j < pattern.length; ++j) {
                word = word + (String)this.alphabet.get((int)pattern[j]);
            }
            Integer val = hist.get(word);
            if (val == null) {
                val = 0;
            }
            hist.put(word, val + 1);
        }
        return hist;
    }

    public HashMap<String, Integer> buildBag(Instance series) throws Exception {
        LinkedList<double[]> patterns = new LinkedList<double[]>();
        double[] prevPattern = new double[this.windowSize];
        for (int i = 0; i < this.windowSize; ++i) {
            prevPattern[i] = -1.0;
        }
        int windowStart = 0;
        while (windowStart + this.windowSize - 1 < series.numAttributes() - 1) {
            double[] pattern = this.slidingWindow(series, windowStart);
            try {
                NormalizeCase.standardNorm(pattern);
            }
            catch (Exception e) {
                for (int j = 0; j < pattern.length; ++j) {
                    pattern[j] = 0.0;
                }
            }
            pattern = SAX.convertSequence(pattern, this.alphabetSize, this.numIntervals);
            if (!this.numerosityReduction || !this.identicalPattern(pattern, prevPattern)) {
                patterns.add(pattern);
            }
            ++windowStart;
        }
        return this.buildHistogram(patterns);
    }

    private double[] slidingWindow(Instance series, int windowStart) {
        double[] window = new double[this.windowSize];
        for (int i = 0; i < this.windowSize; ++i) {
            window[i] = series.value(i + windowStart);
        }
        return window;
    }

    private boolean identicalPattern(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed for BoP conversion");
        }
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        for (String word : this.dictionary) {
            attributes.add(new Attribute(word));
        }
        Instances result = new Instances("BagOfPatterns_" + inputFormat.relationName(), attributes, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            result.insertAttributeAt(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals), result.numAttributes());
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public Instances process(Instances input) throws Exception {
        ArrayList<HashMap<String, Integer>> bags = new ArrayList<HashMap<String, Integer>>(input.numInstances());
        this.dictionary = new TreeSet();
        for (int i = 0; i < input.numInstances(); ++i) {
            bags.add(this.buildBag(input.get(i)));
            this.dictionary.addAll(((HashMap)bags.get(i)).keySet());
        }
        Instances output = this.determineOutputFormat(input);
        Iterator it = bags.iterator();
        int i = 0;
        while (it.hasNext()) {
            double[] bag = this.bagToArray((HashMap)it.next());
            it.remove();
            output.add(new SparseInstance(1.0, bag));
            output.get(i).setClassValue(input.get(i).classValue());
            ++i;
        }
        return output;
    }

    public double[] bagToArray(HashMap<String, Integer> bag) {
        double[] res = new double[this.dictionary.size()];
        int j = 0;
        for (String word : this.dictionary) {
            Integer val = bag.get(word);
            if (val != null) {
                int n = j;
                res[n] = res[n] + (double)val.intValue();
            }
            ++j;
        }
        return res;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public static void main(String[] args) {
        System.out.println("BoPtest\n\n");
        try {
            Instances test = ClassifierTools.loadData("C:\\tempbakeoff\\TSC Problems\\Car\\Car_TRAIN.arff");
            test.deleteAttributeAt(0);
            BagOfPatternsFilter bop = new BagOfPatternsFilter(8, 4, 50);
            bop.useRealValuedAttributes(false);
            Instances result = bop.process(test);
            System.out.println(result);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
}

