/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class AttributeIntervalSelection
extends SimpleBatchFilter {
    int start = 0;
    int end = 1;
    boolean trained = false;

    @Override
    public String globalInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed in " + this.getClass().getName());
        }
        if (this.end - this.start + 1 > inputFormat.numAttributes() - 1) {
            throw new Exception(" Too many attributes in " + this.getClass().getName() + "\n start =" + this.start + " end = " + this.end + " num Atts =" + (inputFormat.numAttributes() - 1));
        }
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = this.start; i <= this.end; ++i) {
            String name = "Interval_" + i;
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("Interval" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public Instances process(Instances instances) {
        if (!this.trained) {
            this.findBestInterval(instances);
            this.trained = true;
        }
        return instances;
    }

    private void findBestInterval(Instances instances) {
        this.start = 0;
        this.end = instances.numAttributes() - 2;
    }
}

