/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import timeseriesweka.filters.ACF;
import timeseriesweka.filters.PACF;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class ARMA
extends SimpleBatchFilter {
    double[] ar;
    public static int globalMaxLag = 25;
    public int maxLag = globalMaxLag;
    public boolean useAIC = true;

    public void setUseAIC(boolean b) {
        this.useAIC = b;
    }

    public void setMaxLag(int a) {
        this.maxLag = a;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed in ACF");
        }
        this.maxLag = inputFormat.classIndex() >= 0 ? (inputFormat.numAttributes() - 1 > this.maxLag ? this.maxLag : inputFormat.numAttributes() - 1) : (inputFormat.numAttributes() > this.maxLag ? this.maxLag : inputFormat.numAttributes());
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < this.maxLag; ++i) {
            String name = "ARMA_" + i;
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("ARMA" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public Instances process(Instances inst) throws Exception {
        Instances output = this.determineOutputFormat(inst);
        int seriesLength = inst.numAttributes();
        int acfLength = output.numAttributes();
        if (inst.classIndex() >= 0) {
            --seriesLength;
            --acfLength;
        }
        for (int i = 0; i < inst.numInstances(); ++i) {
            int k;
            double[] d = inst.instance(i).toDoubleArray();
            int c = inst.classIndex();
            if (c >= 0) {
                double[] temp = new double[d.length - 1];
                int count = 0;
                for (k = 0; k < d.length; ++k) {
                    if (k == c) continue;
                    temp[count] = d[k];
                    ++count;
                }
                d = temp;
            }
            double[] autos = ACF.fitAutoCorrelations(d, this.maxLag);
            double[][] partials = PACF.formPartials(autos);
            int best = this.maxLag;
            if (this.useAIC) {
                best = ARMA.findBestAIC(autos, partials, this.maxLag, d);
            }
            double[] pi = new double[this.maxLag];
            for (k = 0; k < best; ++k) {
                pi[k] = partials[k][best - 1];
            }
            DenseInstance in = new DenseInstance(output.numAttributes());
            int cls = output.classIndex();
            if (cls >= 0) {
                in.setValue(cls, inst.instance(i).classValue());
            }
            int count = 0;
            for (int k2 = 0; k2 < pi.length; ++k2) {
                if (k2 == cls) continue;
                in.setValue(count, pi[k2]);
                ++count;
            }
            output.add(in);
        }
        return output;
    }

    public static double[] fitAR(double[] d) {
        double[] autos = ACF.fitAutoCorrelations(d, globalMaxLag);
        double[][] partials = PACF.formPartials(autos);
        int best = ARMA.findBestAIC(autos, partials, globalMaxLag, d);
        double[] pi = new double[globalMaxLag];
        for (int k = 0; k < best; ++k) {
            pi[k] = partials[k][best - 1];
        }
        return pi;
    }

    public static int findBestAIC(double[] autoCorrelations, double[][] partialCorrelations, int maxLag, double[] d) {
        int i;
        int n = d.length;
        double var = 0.0;
        double mean = 0.0;
        for (i = 0; i < d.length; ++i) {
            mean += d[i];
        }
        for (i = 0; i < d.length; ++i) {
            var += (d[i] - mean) * (d[i] - mean);
        }
        var /= (double)(d.length - 1);
        double AIC = Double.MAX_VALUE;
        double bestAIC = Double.MAX_VALUE;
        int bestPos = 0;
        int i2 = 0;
        boolean found = false;
        while (i2 < maxLag && !found) {
            double sigma2 = 1.0;
            for (int j = 0; j <= i2; ++j) {
                sigma2 -= autoCorrelations[j] * partialCorrelations[j][i2];
            }
            AIC = Math.log(sigma2 *= var);
            if ((AIC += 2.0 * (double)(++i2 + 1) / (double)n) == Double.NaN) {
                AIC = Double.MAX_VALUE;
            }
            if (AIC < bestAIC) {
                bestAIC = AIC;
                bestPos = i2;
                continue;
            }
            found = true;
        }
        return bestPos;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public String getRevision() {
        return null;
    }
}

