/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import timeseriesweka.elastic_distance_measures.BasicDTW;
import weka.core.Instance;
import weka.core.neighboursearch.PerformanceStats;

public class WeightedDTW
extends BasicDTW {
    protected double[][] distances;
    protected boolean isEarlyAbandon;
    private static final double WEIGHT_MAX = 1.0;
    private double g;
    private double[] weightVector;

    public WeightedDTW() {
        this.g = 0.0;
        this.weightVector = null;
        this.m_DontNormalize = true;
        this.isEarlyAbandon = false;
    }

    public WeightedDTW(double g) {
        this.g = g;
        this.weightVector = null;
        this.m_DontNormalize = true;
        this.isEarlyAbandon = false;
    }

    public WeightedDTW(double g, double[] weightVector) {
        this.g = g;
        this.weightVector = weightVector;
        this.m_DontNormalize = true;
        this.isEarlyAbandon = false;
    }

    public WeightedDTW(boolean earlyAbandon) {
        this.g = 0.0;
        this.weightVector = null;
        this.isEarlyAbandon = earlyAbandon;
        this.m_DontNormalize = true;
    }

    public WeightedDTW(double g, boolean earlyAbandon) {
        this.g = g;
        this.weightVector = null;
        this.isEarlyAbandon = earlyAbandon;
        this.m_DontNormalize = true;
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second, cutOffValue);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        double[] arr2;
        int secondClassIndex;
        double[] arr1;
        int firtClassIndex = first.classIndex();
        if (firtClassIndex > 0) {
            arr1 = new double[first.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < first.numAttributes(); ++i) {
                if (i == firtClassIndex) continue;
                arr1[j] = first.value(i);
                ++j;
            }
        } else {
            arr1 = first.toDoubleArray();
        }
        if ((secondClassIndex = second.classIndex()) > 0) {
            arr2 = new double[second.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < second.numAttributes(); ++i) {
                if (i == secondClassIndex) continue;
                arr2[j] = second.value(i);
                ++j;
            }
        } else {
            arr2 = second.toDoubleArray();
        }
        return this.distance(arr1, arr2, cutOffValue);
    }

    @Override
    public double distance(double[] first, double[] second, double cutOffValue) {
        int i;
        if (this.weightVector == null) {
            this.initWeights(first.length);
        }
        this.distances = new double[first.length][second.length];
        this.distances[0][0] = this.weightVector[0] * (first[0] - second[0]) * (first[0] - second[0]);
        if (this.distances[0][0] > cutOffValue && this.isEarlyAbandon) {
            return Double.MAX_VALUE;
        }
        for (i = 1; i < second.length; ++i) {
            this.distances[0][i] = this.distances[0][i - 1] + this.weightVector[i] * (first[0] - second[i]) * (first[0] - second[i]);
        }
        for (i = 1; i < first.length; ++i) {
            this.distances[i][0] = this.distances[i - 1][0] + this.weightVector[i] * (first[i] - second[0]) * (first[i] - second[0]);
        }
        for (int i2 = 1; i2 < first.length; ++i2) {
            boolean overflow = true;
            for (int j = 1; j < second.length; ++j) {
                double minDistance = Math.min(this.distances[i2][j - 1], Math.min(this.distances[i2 - 1][j], this.distances[i2 - 1][j - 1]));
                this.distances[i2][j] = minDistance + this.weightVector[Math.abs(i2 - j)] * (first[i2] - second[j]) * (first[i2] - second[j]);
                if (!overflow || !(this.distances[i2][j] < cutOffValue)) continue;
                overflow = false;
            }
            if (!overflow || !this.isEarlyAbandon) continue;
            return Double.MAX_VALUE;
        }
        return this.distances[first.length - 1][second.length - 1];
    }

    private void initWeights(int seriesLength) {
        this.weightVector = new double[seriesLength];
        double halfLength = (double)seriesLength / 2.0;
        for (int i = 0; i < seriesLength; ++i) {
            this.weightVector[i] = 1.0 / (1.0 + Math.exp(-this.g * ((double)i - halfLength)));
        }
    }

    public static double[] calculateWeightVector(int seriesLength, double g) {
        double[] weights = new double[seriesLength];
        double halfLength = (double)seriesLength / 2.0;
        for (int i = 0; i < seriesLength; ++i) {
            weights[i] = 1.0 / (1.0 + Math.exp(-g * ((double)i - halfLength)));
        }
        return weights;
    }

    @Override
    public String printMinCostWarpPath() {
        return this.findPath(this.distances.length - 1, this.distances[0].length - 1);
    }

    @Override
    protected String findPath(int i, int j) {
        double prevDistance = this.distances[i][j];
        int oldI = i;
        int oldJ = j;
        if (i != 0 || j != 0) {
            if (i > 0 && j > 0) {
                double min = Math.min(this.distances[i - 1][j], Math.min(this.distances[i - 1][j - 1], this.distances[i][j - 1]));
                if (this.distances[i - 1][j - 1] == min) {
                    --i;
                    --j;
                } else if (this.distances[i - 1][j] == min) {
                    --i;
                } else if (this.distances[i][j - 1] == min) {
                    --j;
                }
            } else if (j > 0) {
                --j;
            } else if (i > 0) {
                --i;
            }
            return "(" + oldI + "," + oldJ + ") = " + prevDistance + "\n" + this.findPath(i, j);
        }
        return "(" + oldI + "," + oldJ + ") = " + prevDistance + "\n";
    }

    @Override
    public double[][] getDistanceArray() {
        return this.distances;
    }

    @Override
    public void printDiagonalRoute() {
        System.out.println("------------------ Diagonal Route ------------------");
        for (int i = this.distances.length - 1; i >= 0; --i) {
            System.out.print(this.distances[i][i] + " ");
        }
        System.out.println("\n------------------ End ------------------");
    }

    @Override
    public void printDistances() {
        System.out.println("------------------ Distances Table ------------------");
        for (int i = 0; i < this.distances.length; ++i) {
            System.out.print("Row =" + i + " = ");
            for (int j = 0; j < this.distances[0].length; ++j) {
                System.out.print(" " + this.distances[i][j]);
            }
            System.out.print("\n");
        }
        System.out.println("------------------ End ------------------");
    }

    public boolean isEarlyAbandon() {
        return this.isEarlyAbandon;
    }

    public void setIsEarlyAbandon(boolean isEarlyAbandon) {
        this.isEarlyAbandon = isEarlyAbandon;
    }

    @Override
    public String toString() {
        return "BasicDTW{ earlyAbandon=" + this.isEarlyAbandon + " }";
    }
}

