/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import timeseriesweka.elastic_distance_measures.BasicDTW;

public class PiecewiseDTW
extends BasicDTW {
    private int frameSize;
    private double[] reducedDimensionSeries1;
    private double[] reducedDimensionSeries2;

    public PiecewiseDTW(int frameSize) throws IllegalArgumentException {
        this.setup(frameSize);
    }

    private void setup(int frameSize) throws IllegalArgumentException {
        if (frameSize < 1) {
            throw new IllegalArgumentException("Frame Size must be 1 or greater");
        }
        this.frameSize = frameSize;
    }

    @Override
    public double distance(double[] first, double[] second, double cutOffValue) {
        if (first.length % this.frameSize != 0) {
            throw new IllegalArgumentException("Frame size must be a factor of the number of attributes");
        }
        int seriesLength = first.length / this.frameSize;
        this.reducedDimensionSeries1 = new double[seriesLength];
        this.reducedDimensionSeries2 = new double[seriesLength];
        double series1Frame = 0.0;
        double series2Frame = 0.0;
        int i = 0;
        int reducedPos = 0;
        while (i < first.length) {
            series1Frame = 0.0;
            series2Frame = 0.0;
            for (int j = i; j < i + this.frameSize; ++j) {
                series1Frame += first[j];
                series2Frame += second[j];
            }
            this.reducedDimensionSeries1[reducedPos] = series1Frame / (double)this.frameSize;
            this.reducedDimensionSeries2[reducedPos] = series2Frame / (double)this.frameSize;
            i += this.frameSize;
            ++reducedPos;
        }
        return super.distance(this.reducedDimensionSeries1, this.reducedDimensionSeries2, cutOffValue);
    }

    public void setFrameSize(int frameSize) throws IllegalArgumentException {
        this.setup(frameSize);
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public double[] getReducedDimensionSeries1() {
        return this.reducedDimensionSeries1;
    }

    public double[] getReducedDimensionSeries2() {
        return this.reducedDimensionSeries2;
    }

    public void printReducedSeries() {
        int i;
        System.out.println("------------------ Reduced Series 1 ------------------");
        for (i = 0; i < this.reducedDimensionSeries1.length; ++i) {
            System.out.print(" " + this.reducedDimensionSeries1[i] + "\n");
        }
        System.out.println("------------------ End ------------------");
        System.out.println("------------------ Reduced Series 2 ------------------");
        for (i = 0; i < this.reducedDimensionSeries2.length; ++i) {
            System.out.print(" " + this.reducedDimensionSeries2[i] + "\n");
        }
        System.out.println("------------------ End ------------------");
    }

    @Override
    public String toString() {
        return "PiecewiseDTW{ frameSize=" + this.frameSize + ", }";
    }
}

