/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.voting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.voting.ModuleVotingScheme;
import weka.core.Instance;

public abstract class BestIndividual
extends ModuleVotingScheme {
    protected ArrayList<Integer> bestModulesInds = new ArrayList();
    protected ArrayList<String> bestModulesNames = new ArrayList();
    public int bestModule;

    public BestIndividual() {
    }

    public BestIndividual(int numClasses) {
        this.numClasses = numClasses;
    }

    public ArrayList<Integer> getBestModulesInds() {
        return this.bestModulesInds;
    }

    public ArrayList<String> getBestModulesNames() {
        return this.bestModulesNames;
    }

    public Map<String, ArrayList<String>> splitBestIndividualString(String[] dsets, int numFolds) throws Exception {
        if (this.bestModulesNames.size() != dsets.length * numFolds) {
            throw new Exception("not all folds present");
        }
        HashMap<String, ArrayList<String>> res = new HashMap<String, ArrayList<String>>(dsets.length);
        int globalIndex = 0;
        for (int d = 0; d < dsets.length; ++d) {
            ArrayList<String> fs = new ArrayList<String>(numFolds);
            for (int f = 0; f < numFolds; ++f) {
                fs.add(this.bestModulesNames.get(globalIndex++));
            }
            res.put(dsets[d], fs);
        }
        return res;
    }

    public Map<String, ArrayList<Integer>> splitBestIndividualIndex(String[] dsets, int numFolds) throws Exception {
        if (this.bestModulesNames.size() != dsets.length * numFolds) {
            throw new Exception("not all folds present");
        }
        HashMap<String, ArrayList<Integer>> res = new HashMap<String, ArrayList<Integer>>(dsets.length);
        int globalIndex = 0;
        for (int d = 0; d < dsets.length; ++d) {
            ArrayList<Integer> fs = new ArrayList<Integer>(numFolds);
            for (int f = 0; f < numFolds; ++f) {
                fs.add(this.bestModulesInds.get(globalIndex++));
            }
            res.put(dsets[d], fs);
        }
        return res;
    }

    @Override
    public double[] distributionForTrainInstance(EnsembleModule[] modules, int trainInstanceIndex) {
        return modules[this.bestModule].trainResults.getDistributionForInstance(trainInstanceIndex);
    }

    @Override
    public double[] distributionForTestInstance(EnsembleModule[] modules, int testInstanceIndex) {
        return modules[this.bestModule].testResults.getDistributionForInstance(testInstanceIndex);
    }

    @Override
    public double[] distributionForInstance(EnsembleModule[] modules, Instance testInstance) throws Exception {
        return modules[this.bestModule].getClassifier().distributionForInstance(testInstance);
    }
}

