/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.elastic_ensemble;

import timeseriesweka.classifiers.ensembles.elastic_ensemble.Efficient1NN;
import timeseriesweka.elastic_distance_measures.MSMDistance;
import utilities.ClassifierTools;
import weka.classifiers.lazy.kNN;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;

public class MSM1NN
extends Efficient1NN {
    private Instances train = null;
    private double c = 0.0;
    protected static double[] msmParams = new double[]{0.01, 0.01375, 0.0175, 0.02125, 0.025, 0.02875, 0.0325, 0.03625, 0.04, 0.04375, 0.0475, 0.05125, 0.055, 0.05875, 0.0625, 0.06625, 0.07, 0.07375, 0.0775, 0.08125, 0.085, 0.08875, 0.0925, 0.09625, 0.1, 0.136, 0.172, 0.208, 0.244, 0.28, 0.316, 0.352, 0.388, 0.424, 0.46, 0.496, 0.532, 0.568, 0.604, 0.64, 0.676, 0.712, 0.748, 0.784, 0.82, 0.856, 0.892, 0.928, 0.964, 1.0, 1.36, 1.72, 2.08, 2.44, 2.8, 3.16, 3.52, 3.88, 4.24, 4.6, 4.96, 5.32, 5.68, 6.04, 6.4, 6.76, 7.12, 7.48, 7.84, 8.2, 8.56, 8.92, 9.28, 9.64, 10.0, 13.6, 17.2, 20.8, 24.4, 28.0, 31.6, 35.2, 38.8, 42.4, 46.0, 49.6, 53.2, 56.8, 60.4, 64.0, 67.6, 71.2, 74.8, 78.4, 82.0, 85.6, 89.2, 92.8, 96.4, 100.0};

    public MSM1NN() {
        this.c = 0.1;
        this.classifierIdentifier = "MSM_1NN";
    }

    public MSM1NN(double c) {
        this.c = c;
        this.classifierIdentifier = "MSM_1NN";
        this.allowLoocv = false;
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        int i;
        if (first.classIndex() != first.numAttributes() - 1 || second.classIndex() != second.numAttributes() - 1) {
            System.err.println("Warning: class designed to use problems with class index as last attribute. Defaulting to original MSM distance");
            MSMDistance msm = new MSMDistance(this.c);
            return new MSMDistance(this.c).distance(first, second);
        }
        int m = first.numAttributes() - 1;
        int n = second.numAttributes() - 1;
        double[][] cost = new double[m][n];
        cost[0][0] = Math.abs(first.value(0) - second.value(0));
        for (i = 1; i < m; ++i) {
            cost[i][0] = cost[i - 1][0] + this.calcualteCost(first.value(i), first.value(i - 1), second.value(0));
        }
        for (i = 1; i < n; ++i) {
            cost[0][i] = cost[0][i - 1] + this.calcualteCost(second.value(i), first.value(0), second.value(i - 1));
        }
        for (int i2 = 1; i2 < m; ++i2) {
            double min = cutOffValue;
            for (int j = 1; j < n; ++j) {
                double d1 = cost[i2 - 1][j - 1] + Math.abs(first.value(i2) - second.value(j));
                double d2 = cost[i2 - 1][j] + this.calcualteCost(first.value(i2), first.value(i2 - 1), second.value(j));
                double d3 = cost[i2][j - 1] + this.calcualteCost(second.value(j), first.value(i2), second.value(j - 1));
                cost[i2][j] = Math.min(d1, Math.min(d2, d3));
                if (cost[i2][j] >= cutOffValue) {
                    cost[i2][j] = Double.MAX_VALUE;
                }
                if (!(cost[i2][j] < min)) continue;
                min = cost[i2][j];
            }
            if (!(min >= cutOffValue)) continue;
            return Double.MAX_VALUE;
        }
        return cost[m - 1][n - 1];
    }

    public double calcualteCost(double new_point, double x, double y) {
        double dist = 0.0;
        dist = x <= new_point && new_point <= y || y <= new_point && new_point <= x ? this.c : this.c + Math.min(Math.abs(new_point - x), Math.abs(new_point - y));
        return dist;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void runComparison() throws Exception {
        double pred;
        int i;
        String tscProbDir = "C:/users/sjx07ngu/Dropbox/TSC Problems/";
        String datasetName = "SonyAiboRobotSurface1";
        double c = 0.1;
        Instances train = ClassifierTools.loadData(tscProbDir + datasetName + "/" + datasetName + "_TRAIN");
        Instances test = ClassifierTools.loadData(tscProbDir + datasetName + "/" + datasetName + "_TEST");
        kNN knn = new kNN();
        MSMDistance msmOld = new MSMDistance(c);
        knn.setDistanceFunction(msmOld);
        knn.buildClassifier(train);
        MSM1NN msmNew = new MSM1NN(c);
        msmNew.buildClassifier(train);
        int correctOld = 0;
        int correctNew = 0;
        long start = System.nanoTime();
        correctOld = 0;
        for (i = 0; i < test.numInstances(); ++i) {
            pred = knn.classifyInstance(test.instance(i));
            if (pred != test.instance(i).classValue()) continue;
            ++correctOld;
        }
        long end = System.nanoTime();
        long oldTime = end - start;
        start = System.nanoTime();
        correctNew = 0;
        for (i = 0; i < test.numInstances(); ++i) {
            pred = msmNew.classifyInstance(test.instance(i));
            if (pred != test.instance(i).classValue()) continue;
            ++correctNew;
        }
        end = System.nanoTime();
        long newTime = end - start;
        System.out.println("Comparison of MSM: " + datasetName);
        System.out.println("==========================================");
        System.out.println("Old acc:    " + (double)correctOld / (double)test.numInstances());
        System.out.println("New acc:    " + (double)correctNew / (double)test.numInstances());
        System.out.println("Old timing: " + oldTime);
        System.out.println("New timing: " + newTime);
        System.out.println("Relative Performance: " + (double)newTime / (double)oldTime);
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 10; ++i) {
            MSM1NN.runComparison();
        }
    }

    @Override
    public void setParamsFromParamId(Instances train, int paramId) {
        this.c = msmParams[paramId];
    }

    @Override
    public String getParamInformationString() {
        return this.c + "";
    }
}

