/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.cote;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Scanner;

public abstract class AbstractPostProcessedCote {
    protected String resultsDir;
    protected String datasetName;
    protected int resampleId = 0;
    protected ArrayList<String> classifierNames;
    protected double[] cvAccs;
    protected double[] testAccs;
    protected double[][] testPreds;
    protected double[][][] testDists;
    private double[] testActualClassVals;
    public static String CLASSIFIER_NAME = "AbstractCOTE";

    public void loadResults() throws Exception {
        this.cvAccs = new double[this.classifierNames.size()];
        this.testPreds = new double[this.classifierNames.size()][];
        this.testDists = new double[this.classifierNames.size()][][];
        int testSetSize = -1;
        int numClassVals = -1;
        for (int c = 0; c < this.classifierNames.size(); ++c) {
            String[] lineParts;
            File trainResult = new File(this.resultsDir + this.classifierNames.get(c) + "/Predictions/" + this.datasetName + "/trainFold" + this.resampleId + ".csv");
            if (!trainResult.exists() || trainResult.length() == 0L) {
                throw new Exception("Error: training results do not exist (" + trainResult.getAbsolutePath() + ")");
            }
            Scanner scan = new Scanner(trainResult);
            scan.useDelimiter("\n");
            scan.next();
            scan.next();
            this.cvAccs[c] = Double.parseDouble(scan.next().trim());
            scan.close();
            File testResult = new File(this.resultsDir + this.classifierNames.get(c) + "/Predictions/" + this.datasetName + "/testFold" + this.resampleId + ".csv");
            if (testSetSize <= 0) {
                scan = new Scanner(testResult);
                scan.useDelimiter("\n");
                scan.next();
                scan.next();
                scan.next();
                testSetSize = 0;
                while (scan.hasNext()) {
                    if (numClassVals <= 0) {
                        lineParts = scan.next().split(",");
                        numClassVals = lineParts.length - 3;
                    } else {
                        scan.next();
                    }
                    ++testSetSize;
                }
                scan.close();
            }
            if (c == 0) {
                this.testPreds = new double[this.classifierNames.size()][testSetSize];
                this.testDists = new double[this.classifierNames.size()][testSetSize][numClassVals];
                this.testActualClassVals = new double[testSetSize];
                this.testAccs = new double[this.classifierNames.size()];
            }
            scan = new Scanner(testResult);
            System.out.println("test results exist? " + testResult.exists());
            scan.useDelimiter("\n");
            scan.next();
            scan.next();
            this.testAccs[c] = Double.parseDouble(scan.next().trim());
            int counter = 0;
            while (scan.hasNext()) {
                lineParts = scan.next().split(",");
                this.testPreds[c][counter] = Double.parseDouble(lineParts[1].trim());
                for (int d = 0; d < numClassVals; ++d) {
                    this.testDists[c][counter][d] = Double.parseDouble(lineParts[d + 3].trim());
                }
                if (c == 0) {
                    this.testActualClassVals[counter] = Double.parseDouble(lineParts[0].trim());
                } else if (this.testActualClassVals[counter] != Double.parseDouble(lineParts[0].trim())) {
                    throw new Exception("Error: class value mismatch. Test file for " + this.classifierNames.get(c) + " states that instance " + counter + " has the class value of " + lineParts[0] + ", but in " + this.classifierNames.get(0) + " it was " + this.testActualClassVals[counter] + ".");
                }
                ++counter;
            }
            scan.close();
        }
    }

    protected double classifyInstanceFromDistribution(double[] dist) {
        double bsfClassVal = -1.0;
        double bsfClassWeight = -1.0;
        for (int d = 0; d < dist.length; ++d) {
            if (!(dist[d] > bsfClassWeight)) continue;
            bsfClassWeight = dist[d];
            bsfClassVal = d;
        }
        return bsfClassVal;
    }

    public abstract double[] distributionForInstance(int var1) throws Exception;

    public void writeTestSheet() throws Exception {
        this.writeTestSheet(this.resultsDir);
    }

    public void writeTestSheet(String outputDir) throws Exception {
        File outputPath = new File(outputDir + CLASSIFIER_NAME + "/Predictions/" + this.datasetName + "/");
        if (!outputPath.exists()) {
            outputPath.mkdirs();
            if (!outputPath.exists()) {
                throw new Exception("Error: invalid results path (" + outputPath + ").");
            }
        }
        if (this.cvAccs == null) {
            this.loadResults();
        }
        StringBuilder st = new StringBuilder();
        int correct = 0;
        for (int i = 0; i < this.testPreds[0].length; ++i) {
            double act = this.testActualClassVals[i];
            double[] dist = this.distributionForInstance(i);
            double pred = this.classifyInstanceFromDistribution(dist);
            if (act == pred) {
                ++correct;
            }
            st.append(act + "," + pred + ",");
            for (int d = 0; d < dist.length; ++d) {
                st.append("," + dist[d]);
            }
            st.append("\n");
        }
        FileWriter out = new FileWriter(outputDir + CLASSIFIER_NAME + "/Predictions/" + this.datasetName + "/testFold" + this.resampleId + ".csv");
        out.append(CLASSIFIER_NAME + "," + this.datasetName + ",test\n");
        out.append("constituentCvAccs");
        for (int c = 0; c < this.classifierNames.size(); ++c) {
            out.append("," + this.classifierNames.get(c));
            out.append("," + this.cvAccs[c]);
        }
        out.append("\n" + (double)correct / (double)this.testPreds[0].length + "\n");
        out.append(st);
        out.close();
    }

    public double[] getHiveTestPredictions() throws Exception {
        return null;
    }
}

