/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.boss;

import fileIO.OutFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import utilities.BitWord;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import utilities.generic_storage.ComparablePair;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class BOSSSpatialPyramids
implements Classifier,
SaveParameterInfo,
TrainAccuracyEstimate {
    private List<BOSSWindow> classifiers;
    private final double correctThreshold = 0.92;
    private int maxEnsembleSize = 100;
    private final Integer[] wordLengths = new Integer[]{16, 14, 12, 10, 8};
    private final Integer[] levels = new Integer[]{1, 2, 3};
    private final int alphabetSize = 4;
    private SerialiseOptions serOption = SerialiseOptions.NONE;
    private static String serFileLoc = "BOSSWindowSers\\";
    private boolean[] normOptions;
    private String trainCVPath;
    private boolean trainCV = false;
    private ClassifierResults res = new ClassifierResults();

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Lazebnik, Svetlana and Schmid, Cordelia and Ponce, Jean");
        result.setValue(TechnicalInformation.Field.TITLE, "Beyond bags of features: Spatial pyramid matching for recognizing natural scene categories");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Computer Vision and Pattern Recognition, 2006 IEEE Computer Society Conference on");
        result.setValue(TechnicalInformation.Field.VOLUME, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "2169--2178");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        return result;
    }

    public BOSSSpatialPyramids(boolean normalise) {
        this.normOptions = new boolean[]{normalise};
    }

    public BOSSSpatialPyramids() {
        this.normOptions = new boolean[]{true, false};
    }

    @Override
    public void writeCVTrainToFile(String train) {
        this.trainCVPath = train;
        this.trainCV = true;
    }

    @Override
    public boolean findsTrainAccuracyEstimate() {
        return this.trainCV;
    }

    @Override
    public ClassifierResults getTrainResults() {
        return this.res;
    }

    @Override
    public String getParameters() {
        StringBuilder sb = new StringBuilder();
        BOSSWindow first = this.classifiers.get(0);
        sb.append("windowSize=").append(first.getWindowSize()).append("/wordLength=").append(first.getWordLength());
        sb.append("/alphabetSize=").append(first.getAlphabetSize()).append("/norm=").append(first.isNorm());
        for (int i = 1; i < this.classifiers.size(); ++i) {
            BOSSWindow boss = this.classifiers.get(i);
            sb.append(",windowSize=").append(boss.getWindowSize()).append("/wordLength=").append(boss.getWordLength());
            sb.append("/alphabetSize=").append(boss.getAlphabetSize()).append("/norm=").append(boss.isNorm());
        }
        return sb.toString();
    }

    @Override
    public int setNumberOfFolds(Instances data) {
        return data.numInstances();
    }

    public int[][] getParametersValues() {
        int[][] params = new int[this.classifiers.size()][];
        int i = 0;
        for (BOSSWindow boss : this.classifiers) {
            params[i++] = boss.getParameters();
        }
        return params;
    }

    public void setSerOption(SerialiseOptions option) {
        this.serOption = option;
    }

    public void setSerFileLoc(String path) {
        serFileLoc = path;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        double maxWindowSearches;
        int minWindow;
        if (data.classIndex() != data.numAttributes() - 1) {
            throw new Exception("BOSSEnsembleSP_BuildClassifier: Class attribute not set as last attribute in dataset");
        }
        if (this.serOption == SerialiseOptions.STORE || this.serOption == SerialiseOptions.STORE_LOAD) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = new Date();
            File f = new File(serFileLoc = serFileLoc + data.relationName() + "_" + dateFormat.format(date) + "\\");
            if (!f.isDirectory()) {
                f.mkdirs();
            }
        }
        this.classifiers = new LinkedList<BOSSWindow>();
        int numSeries = data.numInstances();
        int seriesLength = data.numAttributes() - 1;
        int maxWindow = seriesLength;
        int winInc = (int)((double)(maxWindow - (minWindow = 10)) / (maxWindowSearches = (double)seriesLength / 4.0));
        if (winInc < 1) {
            winInc = 1;
        }
        double maxAcc = -1.0;
        double minMaxAcc = -1.0;
        for (boolean normalise : this.normOptions) {
            for (int winSize = minWindow; winSize <= maxWindow; winSize += winInc) {
                BOSSSpatialPyramidsIndividual boss = new BOSSSpatialPyramidsIndividual(this.wordLengths[0], 4, winSize, normalise, this.levels[0]);
                boss.buildClassifier(data);
                BOSSSpatialPyramidsIndividual bestClassifierForWinSize = null;
                double bestAccForWinSize = -1.0;
                for (Integer wordLen : this.wordLengths) {
                    boss = boss.buildShortenedSPBags(wordLen);
                    int correct = 0;
                    for (int i = 0; i < numSeries; ++i) {
                        double c = boss.classifyInstance(i);
                        if (c != data.get(i).classValue()) continue;
                        ++correct;
                    }
                    double acc = (double)correct / (double)numSeries;
                    if (!(acc >= bestAccForWinSize)) continue;
                    bestAccForWinSize = acc;
                    bestClassifierForWinSize = boss;
                }
                int bestLevels = bestClassifierForWinSize.getLevels();
                for (int l = 1; l < this.levels.length; ++l) {
                    bestClassifierForWinSize.changeNumLevels(this.levels[l]);
                    int correct = 0;
                    for (int i = 0; i < numSeries; ++i) {
                        double c = bestClassifierForWinSize.classifyInstance(i);
                        if (c != data.get(i).classValue()) continue;
                        ++correct;
                    }
                    double acc = (double)correct / (double)numSeries;
                    if (!(acc > bestAccForWinSize)) continue;
                    bestAccForWinSize = acc;
                    bestLevels = this.levels[l];
                }
                if (!this.makesItIntoEnsemble(bestAccForWinSize, maxAcc, minMaxAcc, this.classifiers.size())) continue;
                bestClassifierForWinSize.changeNumLevels(bestLevels);
                BOSSWindow bw = new BOSSWindow(bestClassifierForWinSize, bestAccForWinSize, data.relationName());
                bw.classifier.clean();
                if (this.serOption == SerialiseOptions.STORE) {
                    bw.store();
                } else if (this.serOption == SerialiseOptions.STORE_LOAD) {
                    bw.storeAndClearClassifier();
                }
                this.classifiers.add(bw);
                if (bestAccForWinSize > maxAcc) {
                    maxAcc = bestAccForWinSize;
                    Iterator<BOSSWindow> it = this.classifiers.iterator();
                    while (it.hasNext()) {
                        BOSSWindow b = it.next();
                        if (!(b.accuracy < maxAcc * 0.92)) continue;
                        if (this.serOption == SerialiseOptions.STORE || this.serOption == SerialiseOptions.STORE_LOAD) {
                            b.deleteSerFile();
                        }
                        it.remove();
                    }
                }
                while (this.classifiers.size() > this.maxEnsembleSize) {
                    int minAccInd = (int)this.findMinEnsembleAcc()[0];
                    if (this.serOption == SerialiseOptions.STORE || this.serOption == SerialiseOptions.STORE_LOAD) {
                        this.classifiers.get(minAccInd).deleteSerFile();
                    }
                    this.classifiers.remove(minAccInd);
                }
                minMaxAcc = this.findMinEnsembleAcc()[1];
            }
        }
        if (this.trainCV) {
            int folds = this.setNumberOfFolds(data);
            OutFile of = new OutFile(this.trainCVPath);
            of.writeLine(data.relationName() + ",BOSSEnsembleSP_Redo,train");
            double[][] results = this.findEnsembleTrainAcc(data);
            of.writeLine(this.getParameters());
            of.writeLine(results[0][0] + "");
            for (int i = 1; i < results[0].length; ++i) {
                of.writeLine(results[0][i] + "," + results[1][i]);
            }
            System.out.println("CV acc =" + results[0][0]);
        }
    }

    private double[] findMinEnsembleAcc() {
        double minAcc = Double.MIN_VALUE;
        int minAccInd = 0;
        for (int i = 0; i < this.classifiers.size(); ++i) {
            double curacc = this.classifiers.get((int)i).accuracy;
            if (!(curacc < minAcc)) continue;
            minAcc = curacc;
            minAccInd = i;
        }
        return new double[]{minAccInd, minAcc};
    }

    private boolean makesItIntoEnsemble(double acc, double maxAcc, double minMaxAcc, int curEnsembleSize) {
        if (acc >= maxAcc * 0.92) {
            if (curEnsembleSize >= this.maxEnsembleSize) {
                return acc > minMaxAcc;
            }
            return true;
        }
        return false;
    }

    private double[][] findEnsembleTrainAcc(Instances data) throws Exception {
        double[][] results = new double[2][data.numInstances() + 1];
        double correct = 0.0;
        for (int i = 0; i < data.numInstances(); ++i) {
            double c = this.classifyInstance(i, data.numClasses());
            if (c == data.get(i).classValue()) {
                correct += 1.0;
            }
            results[0][i + 1] = data.get(i).classValue();
            results[1][i + 1] = c;
        }
        results[0][0] = correct / (double)data.numInstances();
        return results;
    }

    public double classifyInstance(int test, int numclasses) throws Exception {
        double[] dist = this.distributionForInstance(test, numclasses);
        double maxFreq = dist[0];
        double maxClass = 0.0;
        for (int i = 1; i < dist.length; ++i) {
            if (!(dist[i] > maxFreq)) continue;
            maxFreq = dist[i];
            maxClass = i;
        }
        return maxClass;
    }

    public double[] distributionForInstance(int test, int numclasses) throws Exception {
        double[] classHist = new double[numclasses];
        double sum = 0.0;
        for (BOSSWindow classifier : this.classifiers) {
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.load();
            }
            double classification = classifier.classifyInstance(test);
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.clearClassifier();
            }
            int n = (int)classification;
            classHist[n] = classHist[n] + 1.0;
            sum += 1.0;
        }
        if (sum != 0.0) {
            int i = 0;
            while (i < classHist.length) {
                int n = i++;
                classHist[n] = classHist[n] / sum;
            }
        }
        return classHist;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double[] dist = this.distributionForInstance(instance);
        double maxFreq = dist[0];
        double maxClass = 0.0;
        for (int i = 1; i < dist.length; ++i) {
            if (!(dist[i] > maxFreq)) continue;
            maxFreq = dist[i];
            maxClass = i;
        }
        return maxClass;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] classHist = new double[instance.numClasses()];
        double sum = 0.0;
        for (BOSSWindow classifier : this.classifiers) {
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.load();
            }
            double classification = classifier.classifyInstance(instance);
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.clearClassifier();
            }
            int n = (int)classification;
            classHist[n] = classHist[n] + 1.0;
            sum += 1.0;
        }
        if (sum != 0.0) {
            int i = 0;
            while (i < classHist.length) {
                int n = i++;
                classHist[n] = classHist[n] / sum;
            }
        }
        return classHist;
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) throws Exception {
        String dataset = "ItalyPowerDemand";
        Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dataset + "\\" + dataset + "_TRAIN.arff");
        Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dataset + "\\" + dataset + "_TEST.arff");
        BOSSSpatialPyramids c = new BOSSSpatialPyramids();
        c.buildClassifier(train);
        double accuracy = ClassifierTools.accuracy(test, c);
        System.out.println("BOSSEnsembleSP accuracy on " + dataset + " fold 0 = " + accuracy);
    }

    public static void detailedFold0Test(String dset) {
        System.out.println("BOSSEnsembleSPDetailedTest\n");
        try {
            Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
            System.out.println(train.relationName());
            BOSSSpatialPyramids boss = new BOSSSpatialPyramids();
            System.out.println("Training starting");
            long start = System.nanoTime();
            boss.buildClassifier(train);
            double trainTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Training done (" + trainTime + "s)");
            System.out.println("Ensemble Size: " + boss.classifiers.size());
            System.out.println("Param sets: ");
            int[][] params = boss.getParametersValues();
            for (int i = 0; i < params.length; ++i) {
                System.out.println(i + ": " + params[i][0] + " " + params[i][1] + " " + params[i][2] + " " + boss.classifiers.get(i).isNorm() + " " + boss.classifiers.get(i).getLevels() + " " + boss.classifiers.get((int)i).accuracy);
            }
            System.out.println("\nTesting starting");
            start = System.nanoTime();
            double acc = ClassifierTools.accuracy(test, boss);
            double testTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Testing done (" + testTime + "s)");
            System.out.println("\nACC: " + acc);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static void resampleTest(String dset, int resamples) throws Exception {
        Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
        Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
        BOSSSpatialPyramids c = new BOSSSpatialPyramids();
        double[] accs = new double[resamples];
        for (int i = 0; i < resamples; ++i) {
            Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, i);
            c.buildClassifier(data[0]);
            accs[i] = ClassifierTools.accuracy(data[1], c);
            if (i == 0) {
                System.out.print(accs[i]);
                continue;
            }
            System.out.print("," + accs[i]);
        }
        double mean = 0.0;
        for (int i = 0; i < resamples; ++i) {
            mean += accs[i];
        }
        System.out.println("\n\nBOSSEnsembleSP mean acc over " + resamples + " resamples: " + (mean /= (double)resamples));
    }

    public static class BOSSSpatialPyramidsIndividual
    implements Classifier,
    Serializable {
        protected BitWord[][] SFAwords;
        public ArrayList<SPBag> bags;
        protected double[][] breakpoints;
        protected double inverseSqrtWindowSize;
        protected int windowSize;
        protected int wordLength;
        protected int alphabetSize;
        protected boolean norm;
        protected int levels = 0;
        protected double levelWeighting = 0.5;
        protected int seriesLength;
        protected boolean numerosityReduction = true;
        protected static final long serialVersionUID = 1L;

        public BOSSSpatialPyramidsIndividual(int wordLength, int alphabetSize, int windowSize, boolean normalise, int levels) {
            this.wordLength = wordLength;
            this.alphabetSize = alphabetSize;
            this.windowSize = windowSize;
            this.inverseSqrtWindowSize = 1.0 / Math.sqrt(windowSize);
            this.norm = normalise;
            this.levels = levels;
        }

        public BOSSSpatialPyramidsIndividual(BOSSSpatialPyramidsIndividual boss, int wordLength) {
            this.wordLength = wordLength;
            this.windowSize = boss.windowSize;
            this.inverseSqrtWindowSize = boss.inverseSqrtWindowSize;
            this.alphabetSize = boss.alphabetSize;
            this.norm = boss.norm;
            this.numerosityReduction = boss.numerosityReduction;
            this.SFAwords = boss.SFAwords;
            this.breakpoints = boss.breakpoints;
            this.levelWeighting = boss.levelWeighting;
            this.levels = boss.levels;
            this.seriesLength = boss.seriesLength;
            this.bags = new ArrayList(boss.bags.size());
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public int getWordLength() {
            return this.wordLength;
        }

        public int getAlphabetSize() {
            return this.alphabetSize;
        }

        public boolean isNorm() {
            return this.norm;
        }

        public int getLevels() {
            return this.levels;
        }

        public double getLevelWeighting() {
            return this.levelWeighting;
        }

        public int[] getParameters() {
            return new int[]{this.wordLength, this.alphabetSize, this.windowSize};
        }

        public void clean() {
            this.SFAwords = null;
        }

        protected double[][] slidingWindow(double[] data) {
            int numWindows = data.length - this.windowSize + 1;
            double[][] subSequences = new double[numWindows][this.windowSize];
            for (int windowStart = 0; windowStart < numWindows; ++windowStart) {
                System.arraycopy(data, windowStart, subSequences[windowStart], 0, this.windowSize);
            }
            return subSequences;
        }

        protected double[][] performDFT(double[][] windows) {
            double[][] dfts = new double[windows.length][this.wordLength];
            for (int i = 0; i < windows.length; ++i) {
                dfts[i] = this.DFT(windows[i]);
            }
            return dfts;
        }

        protected double stdDev(double[] series) {
            double sum = 0.0;
            double squareSum = 0.0;
            for (int i = 0; i < this.windowSize; ++i) {
                sum += series[i];
                squareSum += series[i] * series[i];
            }
            double mean = sum / (double)series.length;
            double variance = squareSum / (double)series.length - mean * mean;
            return variance > 0.0 ? Math.sqrt(variance) : 1.0;
        }

        protected double[] DFT(double[] series) {
            int n = series.length;
            int outputLength = this.wordLength / 2;
            int start = this.norm ? 1 : 0;
            double normalisingFactor = this.inverseSqrtWindowSize / this.stdDev(series);
            double[] dft = new double[outputLength * 2];
            for (int k = start; k < start + outputLength; ++k) {
                float sumreal = 0.0f;
                float sumimag = 0.0f;
                for (int t = 0; t < n; ++t) {
                    sumreal = (float)((double)sumreal + series[t] * Math.cos(Math.PI * 2 * (double)t * (double)k / (double)n));
                    sumimag = (float)((double)sumimag + -series[t] * Math.sin(Math.PI * 2 * (double)t * (double)k / (double)n));
                }
                dft[(k - start) * 2] = (double)sumreal * normalisingFactor;
                dft[(k - start) * 2 + 1] = (double)sumimag * normalisingFactor;
            }
            return dft;
        }

        private double[] DFTunnormed(double[] series) {
            int n = series.length;
            int outputLength = this.wordLength / 2;
            int start = this.norm ? 1 : 0;
            double[] dft = new double[outputLength * 2];
            double twoPi = Math.PI * 2 / (double)n;
            for (int k = start; k < start + outputLength; ++k) {
                float sumreal = 0.0f;
                float sumimag = 0.0f;
                for (int t = 0; t < n; ++t) {
                    sumreal = (float)((double)sumreal + series[t] * Math.cos(twoPi * (double)t * (double)k));
                    sumimag = (float)((double)sumimag + -series[t] * Math.sin(twoPi * (double)t * (double)k));
                }
                dft[(k - start) * 2] = sumreal;
                dft[(k - start) * 2 + 1] = sumimag;
            }
            return dft;
        }

        private double[] normalizeDFT(double[] dft, double std) {
            double normalisingFactor = (std > 0.0 ? 1.0 / std : 1.0) * this.inverseSqrtWindowSize;
            int i = 0;
            while (i < dft.length) {
                int n = i++;
                dft[n] = dft[n] * normalisingFactor;
            }
            return dft;
        }

        private double[][] performMFT(double[] series) {
            int startOffset = this.norm ? 2 : 0;
            int l = this.wordLength;
            l += l % 2;
            double[] phis = new double[l];
            for (int u = 0; u < phis.length; u += 2) {
                double uHalve = -(u + startOffset) / 2;
                phis[u] = BOSSSpatialPyramidsIndividual.realephi(uHalve, this.windowSize);
                phis[u + 1] = BOSSSpatialPyramidsIndividual.complexephi(uHalve, this.windowSize);
            }
            int end = Math.max(1, series.length - this.windowSize + 1);
            double[] means = new double[end];
            double[] stds = new double[end];
            this.calcIncreamentalMeanStddev(this.windowSize, series, means, stds);
            double[][] transformed = new double[end][];
            double[] mftData = null;
            for (int t = 0; t < end; ++t) {
                if (t > 0) {
                    for (int k = 0; k < l; k += 2) {
                        double real1 = mftData[k] + series[t + this.windowSize - 1] - series[t - 1];
                        double imag1 = mftData[k + 1];
                        double real = BOSSSpatialPyramidsIndividual.complexMulReal(real1, imag1, phis[k], phis[k + 1]);
                        double imag = BOSSSpatialPyramidsIndividual.complexMulImag(real1, imag1, phis[k], phis[k + 1]);
                        mftData[k] = real;
                        mftData[k + 1] = imag;
                    }
                } else {
                    mftData = Arrays.copyOf(series, this.windowSize);
                    mftData = this.DFTunnormed(mftData);
                }
                transformed[t] = this.normalizeDFT(Arrays.copyOf(mftData, l), stds[t]);
            }
            return transformed;
        }

        private void calcIncreamentalMeanStddev(int windowLength, double[] series, double[] means, double[] stds) {
            double sum = 0.0;
            double squareSum = 0.0;
            double rWindowLength = 1.0 / (double)windowLength;
            double[] tsData = series;
            for (int ww = 0; ww < windowLength; ++ww) {
                sum += tsData[ww];
                squareSum += tsData[ww] * tsData[ww];
            }
            means[0] = sum * rWindowLength;
            double buf = squareSum * rWindowLength - means[0] * means[0];
            stds[0] = buf > 0.0 ? Math.sqrt(buf) : 0.0;
            int end = tsData.length - windowLength + 1;
            for (int w = 1; w < end; ++w) {
                means[w] = (sum += tsData[w + windowLength - 1] - tsData[w - 1]) * rWindowLength;
                buf = (squareSum += tsData[w + windowLength - 1] * tsData[w + windowLength - 1] - tsData[w - 1] * tsData[w - 1]) * rWindowLength - means[w] * means[w];
                stds[w] = buf > 0.0 ? Math.sqrt(buf) : 0.0;
            }
        }

        private static double complexMulReal(double r1, double im1, double r2, double im2) {
            return r1 * r2 - im1 * im2;
        }

        private static double complexMulImag(double r1, double im1, double r2, double im2) {
            return r1 * im2 + r2 * im1;
        }

        private static double realephi(double u, double M) {
            return Math.cos(Math.PI * 2 * u / M);
        }

        private static double complexephi(double u, double M) {
            return -Math.sin(Math.PI * 2 * u / M);
        }

        protected double[][] disjointWindows(double[] data) {
            int amount = (int)Math.ceil((double)data.length / (double)this.windowSize);
            double[][] subSequences = new double[amount][this.windowSize];
            for (int win = 0; win < amount; ++win) {
                int offset = Math.min(win * this.windowSize, data.length - this.windowSize);
                System.arraycopy(data, offset, subSequences[win], 0, this.windowSize);
            }
            return subSequences;
        }

        protected double[][] MCB(Instances data) {
            double[][][] dfts = new double[data.numInstances()][][];
            int sample = 0;
            for (Instance inst : data) {
                dfts[sample++] = this.performDFT(this.disjointWindows(BOSSSpatialPyramidsIndividual.toArrayNoClass(inst)));
            }
            int numInsts = dfts.length;
            int numWindowsPerInst = dfts[0].length;
            int totalNumWindows = numInsts * numWindowsPerInst;
            this.breakpoints = new double[this.wordLength][this.alphabetSize];
            for (int letter = 0; letter < this.wordLength; ++letter) {
                double[] column = new double[totalNumWindows];
                for (int inst = 0; inst < numInsts; ++inst) {
                    for (int window = 0; window < numWindowsPerInst; ++window) {
                        column[inst * numWindowsPerInst + window] = (double)Math.round(dfts[inst][window][letter] * 100.0) / 100.0;
                    }
                }
                Arrays.sort(column);
                double binIndex = 0.0;
                double targetBinDepth = (double)totalNumWindows / (double)this.alphabetSize;
                for (int bp = 0; bp < this.alphabetSize - 1; ++bp) {
                    this.breakpoints[letter][bp] = column[(int)(binIndex += targetBinDepth)];
                }
                this.breakpoints[letter][this.alphabetSize - 1] = Double.MAX_VALUE;
            }
            return this.breakpoints;
        }

        protected SPBag createSPBagSingle(double[][] dfts) {
            SPBag bag = new SPBag();
            BitWord lastWord = new BitWord();
            int wInd = 0;
            int trivialMatchCount = 0;
            for (double[] d : dfts) {
                BitWord word = this.createWord(d);
                if (this.numerosityReduction && word.equals(lastWord)) {
                    ++trivialMatchCount;
                    ++wInd;
                    continue;
                }
                this.addWordToPyramid(word, wInd - trivialMatchCount / 2, bag);
                lastWord = word;
                trivialMatchCount = 0;
                ++wInd;
            }
            this.applyPyramidWeights(bag);
            return bag;
        }

        protected BitWord createWord(double[] dft) {
            BitWord word = new BitWord(this.wordLength);
            block0: for (int l = 0; l < this.wordLength; ++l) {
                for (int bp = 0; bp < this.alphabetSize; ++bp) {
                    if (!(dft[l] <= this.breakpoints[l][bp])) continue;
                    word.push(bp);
                    continue block0;
                }
            }
            return word;
        }

        protected static double[] toArrayNoClass(Instance inst) {
            int length = inst.numAttributes();
            if (inst.classIndex() >= 0) {
                --length;
            }
            double[] data = new double[length];
            int j = 0;
            for (int i = 0; i < inst.numAttributes(); ++i) {
                if (inst.classIndex() == i) continue;
                data[j++] = inst.value(i);
            }
            return data;
        }

        public SPBag BOSSSpatialPyramidsTransform(Instance inst) {
            double[][] mfts = this.performMFT(BOSSSpatialPyramidsIndividual.toArrayNoClass(inst));
            SPBag bag2 = this.createSPBagSingle(mfts);
            bag2.setClassVal(inst.classValue());
            return bag2;
        }

        public BOSSSpatialPyramidsIndividual buildShortenedSPBags(int newWordLength) throws Exception {
            if (newWordLength == this.wordLength) {
                return this;
            }
            if (newWordLength > this.wordLength) {
                throw new Exception("Cannot incrementally INCREASE word length, current:" + this.wordLength + ", requested:" + newWordLength);
            }
            if (newWordLength < 2) {
                throw new Exception("Invalid wordlength requested, current:" + this.wordLength + ", requested:" + newWordLength);
            }
            BOSSSpatialPyramidsIndividual newBoss = new BOSSSpatialPyramidsIndividual(this, newWordLength);
            for (int i = 0; i < this.bags.size(); ++i) {
                SPBag newSPBag = this.createSPBagFromWords(newWordLength, this.SFAwords[i], true);
                newSPBag.setClassVal(this.bags.get(i).getClassVal());
                newBoss.bags.add(newSPBag);
            }
            return newBoss;
        }

        protected SPBag shortenSPBag(int newWordLength, int bagIndex) {
            SPBag newSPBag = new SPBag();
            for (BitWord word : this.SFAwords[bagIndex]) {
                BitWord shortWord = new BitWord(word);
                shortWord.shortenByFourierCoefficient();
                Double val = (Double)newSPBag.get(shortWord);
                if (val == null) {
                    val = 0.0;
                }
                newSPBag.put(new ComparablePair<BitWord, Integer>(shortWord, 0), val + 1.0);
            }
            return newSPBag;
        }

        protected SPBag createSPBagFromWords(int thisWordLength, BitWord[] words, boolean wordLengthSearching) {
            SPBag bag = new SPBag();
            BitWord lastWord = new BitWord();
            int wInd = 0;
            int trivialMatchCount = 0;
            for (BitWord w : words) {
                BitWord word = new BitWord(w);
                if (wordLengthSearching) {
                    word.shorten(16 - thisWordLength);
                }
                if (this.numerosityReduction && word.equals(lastWord)) {
                    ++trivialMatchCount;
                    ++wInd;
                    continue;
                }
                this.addWordToPyramid(word, wInd - trivialMatchCount / 2, bag);
                lastWord = word;
                trivialMatchCount = 0;
                ++wInd;
            }
            this.applyPyramidWeights(bag);
            return bag;
        }

        protected void changeNumLevels(int newLevels) {
            if (newLevels == this.levels) {
                return;
            }
            this.levels = newLevels;
            for (int inst = 0; inst < this.bags.size(); ++inst) {
                SPBag bag = this.createSPBagFromWords(this.wordLength, this.SFAwords[inst], true);
                bag.setClassVal(this.bags.get((int)inst).classVal);
                this.bags.set(inst, bag);
            }
        }

        protected void applyPyramidWeights(SPBag bag) {
            for (Map.Entry ent : bag.entrySet()) {
                int numQuadrants;
                int quadrant = (Integer)((ComparablePair)ent.getKey()).var2;
                int level = 0;
                for (int qEnd = 0; qEnd < quadrant; qEnd += numQuadrants) {
                    numQuadrants = (int)Math.pow(2.0, ++level);
                }
                double val = (Double)ent.getValue() * Math.pow(this.levelWeighting, this.levels - level - 1);
                bag.put(ent.getKey(), val);
            }
        }

        protected void addWordToPyramid(BitWord word, int wInd, SPBag bag) {
            int qStart = 0;
            for (int l = 0; l < this.levels; ++l) {
                int pos = wInd + this.windowSize / 2;
                int numQuadrants = (int)Math.pow(2.0, l);
                int quadrantSize = this.seriesLength / numQuadrants;
                int quadrant = qStart + pos / quadrantSize;
                ComparablePair<BitWord, Integer> key = new ComparablePair<BitWord, Integer>(word, quadrant);
                Double val = (Double)bag.get(key);
                if (val == null) {
                    val = 0.0;
                }
                val = val + 1.0;
                bag.put(key, val);
                qStart += numQuadrants;
            }
        }

        protected BitWord[] createSFAwords(Instance inst) throws Exception {
            double[][] dfts2 = this.performMFT(BOSSSpatialPyramidsIndividual.toArrayNoClass(inst));
            BitWord[] words2 = new BitWord[dfts2.length];
            for (int window = 0; window < dfts2.length; ++window) {
                words2[window] = this.createWord(dfts2[window]);
            }
            return words2;
        }

        @Override
        public void buildClassifier(Instances data) throws Exception {
            if (data.classIndex() != data.numAttributes() - 1) {
                throw new Exception("BOSSSpatialPyramids_BuildClassifier: Class attribute not set as last attribute in dataset");
            }
            this.seriesLength = data.numAttributes() - 1;
            this.breakpoints = this.MCB(data);
            this.SFAwords = new BitWord[data.numInstances()][];
            this.bags = new ArrayList(data.numInstances());
            for (int inst = 0; inst < data.numInstances(); ++inst) {
                this.SFAwords[inst] = this.createSFAwords(data.get(inst));
                SPBag bag = this.createSPBagFromWords(this.wordLength, this.SFAwords[inst], false);
                bag.setClassVal(data.get(inst).classValue());
                this.bags.add(bag);
            }
        }

        public double BOSSSpatialPyramidsDistance(SPBag instA, SPBag instB) {
            double dist = 0.0;
            for (Map.Entry entry : instA.entrySet()) {
                Double valA = (Double)entry.getValue();
                Double valB = (Double)instB.get(entry.getKey());
                if (valB == null) {
                    valB = 0.0;
                }
                dist += (valA - valB) * (valA - valB);
            }
            return dist;
        }

        public double BOSSSpatialPyramidsDistance(SPBag instA, SPBag instB, double bestDist) {
            double dist = 0.0;
            for (Map.Entry entry : instA.entrySet()) {
                Double valA = (Double)entry.getValue();
                Double valB = (Double)instB.get(entry.getKey());
                if (valB == null) {
                    valB = 0.0;
                }
                if (!((dist += (valA - valB) * (valA - valB)) > bestDist)) continue;
                return Double.MAX_VALUE;
            }
            return dist;
        }

        public double histogramIntersection(SPBag instA, SPBag instB) {
            double sim = 0.0;
            for (Map.Entry entry : instA.entrySet()) {
                Double valA = (Double)entry.getValue();
                Double valB = (Double)instB.get(entry.getKey());
                if (valB == null) continue;
                sim += Math.min(valA, valB);
            }
            return sim;
        }

        @Override
        public double classifyInstance(Instance instance) throws Exception {
            SPBag testSPBag = this.BOSSSpatialPyramidsTransform(instance);
            double bestSimilarity = 0.0;
            double nn = -1.0;
            for (int i = 0; i < this.bags.size(); ++i) {
                double similarity = this.histogramIntersection(testSPBag, this.bags.get(i));
                if (!(similarity > bestSimilarity)) continue;
                bestSimilarity = similarity;
                nn = this.bags.get(i).getClassVal();
            }
            if (nn == -1.0) {
                nn = 0.0;
            }
            return nn;
        }

        public double classifyInstance(int test) {
            double bestSimilarity = 0.0;
            double nn = -1.0;
            SPBag testSPBag = this.bags.get(test);
            for (int i = 0; i < this.bags.size(); ++i) {
                double similarity;
                if (i == test || !((similarity = this.histogramIntersection(testSPBag, this.bags.get(i))) > bestSimilarity)) continue;
                bestSimilarity = similarity;
                nn = this.bags.get(i).getClassVal();
            }
            return nn;
        }

        @Override
        public double[] distributionForInstance(Instance instance) throws Exception {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Capabilities getCapabilities() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public static void detailedFold0Test(String dset) {
            System.out.println("BOSSSpatialPyramidsIndividual DetailedTest\n");
            try {
                Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
                Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
                System.out.println(train.relationName());
                int windowSize = 10;
                int alphabetSize = 4;
                int wordLength = 58;
                int levels = 2;
                boolean norm = true;
                BOSSSpatialPyramidsIndividual boss = new BOSSSpatialPyramidsIndividual(windowSize, alphabetSize, wordLength, norm, levels);
                System.out.println(boss.getWordLength() + " " + boss.getAlphabetSize() + " " + boss.getWindowSize() + " " + boss.isNorm());
                System.out.println("Training starting");
                long start = System.nanoTime();
                boss.buildClassifier(train);
                double trainTime = (double)(System.nanoTime() - start) / 1.0E9;
                System.out.println("Training done (" + trainTime + "s)");
                System.out.println("Breakpoints: ");
                for (int i = 0; i < boss.breakpoints.length; ++i) {
                    System.out.print("Letter " + i + ": ");
                    for (int j = 0; j < boss.breakpoints[i].length; ++j) {
                        System.out.print(boss.breakpoints[i][j] + " ");
                    }
                    System.out.println("");
                }
                System.out.println("\nTesting starting");
                start = System.nanoTime();
                double acc = ClassifierTools.accuracy(test, boss);
                double testTime = (double)(System.nanoTime() - start) / 1.0E9;
                System.out.println("Testing done (" + testTime + "s)");
                System.out.println("\nACC: " + acc);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }

        public static class SPBag
        extends HashMap<ComparablePair<BitWord, Integer>, Double> {
            double classVal;

            public SPBag() {
            }

            public SPBag(int classValue) {
                this.classVal = classValue;
            }

            public double getClassVal() {
                return this.classVal;
            }

            public void setClassVal(double classVal) {
                this.classVal = classVal;
            }
        }
    }

    public static class BOSSWindow
    implements Comparable<BOSSWindow>,
    Serializable {
        private BOSSSpatialPyramidsIndividual classifier;
        public double accuracy;
        public String filename;
        private static final long serialVersionUID = 2L;

        public BOSSWindow(String filename) {
            this.filename = filename;
        }

        public BOSSWindow(BOSSSpatialPyramidsIndividual classifer, double accuracy, String dataset) {
            this.classifier = classifer;
            this.accuracy = accuracy;
            this.buildFileName(dataset);
        }

        public double classifyInstance(Instance inst) throws Exception {
            return this.classifier.classifyInstance(inst);
        }

        public double classifyInstance(int test) throws Exception {
            return this.classifier.classifyInstance(test);
        }

        private void buildFileName(String dataset) {
            this.filename = serFileLoc + dataset + "_" + this.classifier.windowSize + "_" + this.classifier.wordLength + "_" + this.classifier.alphabetSize + "_" + this.classifier.norm + ".ser";
        }

        public boolean storeAndClearClassifier() {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.filename));
                out.writeObject(this);
                out.close();
                this.clearClassifier();
                return true;
            }
            catch (IOException e) {
                System.out.print("Error serialiszing to " + this.filename);
                e.printStackTrace();
                return false;
            }
        }

        public boolean store() {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.filename));
                out.writeObject(this);
                out.close();
                return true;
            }
            catch (IOException e) {
                System.out.print("Error serialiszing to " + this.filename);
                e.printStackTrace();
                return false;
            }
        }

        public void clearClassifier() {
            this.classifier = null;
        }

        public boolean load() {
            BOSSWindow bw = null;
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.filename));
                bw = (BOSSWindow)in.readObject();
                in.close();
                this.accuracy = bw.accuracy;
                this.classifier = bw.classifier;
                return true;
            }
            catch (IOException i) {
                System.out.print("Error deserialiszing from " + this.filename);
                i.printStackTrace();
                return false;
            }
            catch (ClassNotFoundException c) {
                System.out.println("BOSSWindow class not found");
                c.printStackTrace();
                return false;
            }
        }

        public boolean deleteSerFile() {
            try {
                File f = new File(this.filename);
                return f.delete();
            }
            catch (SecurityException s) {
                System.out.println("Unable to delete, access denied: " + this.filename);
                s.printStackTrace();
                return false;
            }
        }

        public int[] getParameters() {
            return this.classifier.getParameters();
        }

        public int getWindowSize() {
            return this.classifier.getWindowSize();
        }

        public int getWordLength() {
            return this.classifier.getWordLength();
        }

        public int getAlphabetSize() {
            return this.classifier.getAlphabetSize();
        }

        public boolean isNorm() {
            return this.classifier.isNorm();
        }

        public double getLevelWeighting() {
            return this.classifier.getLevelWeighting();
        }

        public int getLevels() {
            return this.classifier.getLevels();
        }

        @Override
        public int compareTo(BOSSWindow other) {
            if (this.accuracy > other.accuracy) {
                return 1;
            }
            if (this.accuracy == other.accuracy) {
                return 0;
            }
            return -1;
        }
    }

    public static enum SerialiseOptions {
        NONE,
        STORE,
        STORE_LOAD;

    }
}

