/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.boss;

import fileIO.OutFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import timeseriesweka.classifiers.BOSS;
import utilities.BitWord;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class BOSSC45
implements Classifier,
SaveParameterInfo,
TrainAccuracyEstimate {
    private List<BOSSWindow> classifiers;
    private int numCVFolds = 10;
    private final double correctThreshold = 0.92;
    private int maxEnsembleSize = 50;
    private final Integer[] wordLengths = new Integer[]{16, 14, 12, 10, 8};
    private final int alphabetSize = 4;
    private SerialiseOptions serOption = SerialiseOptions.NONE;
    private static String serFileLoc = "BOSSWindowSers\\";
    private boolean[] normOptions;
    private String trainCVPath;
    private boolean trainCV = false;
    private ClassifierResults res = new ClassifierResults();

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "P. Schafer");
        result.setValue(TechnicalInformation.Field.TITLE, "The BOSS is concerned with time series classification in the presence of noise");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Data Mining and Knowledge Discovery");
        result.setValue(TechnicalInformation.Field.VOLUME, "29");
        result.setValue(TechnicalInformation.Field.NUMBER, "6");
        result.setValue(TechnicalInformation.Field.PAGES, "1505-1530");
        result.setValue(TechnicalInformation.Field.YEAR, "2015");
        return result;
    }

    public BOSSC45(boolean normalise) {
        this.normOptions = new boolean[]{normalise};
    }

    public BOSSC45() {
        this.normOptions = new boolean[]{true, false};
    }

    @Override
    public void writeCVTrainToFile(String train) {
        this.trainCVPath = train;
        this.trainCV = true;
    }

    @Override
    public boolean findsTrainAccuracyEstimate() {
        return this.trainCV;
    }

    @Override
    public ClassifierResults getTrainResults() {
        return this.res;
    }

    @Override
    public String getParameters() {
        StringBuilder sb = new StringBuilder();
        BOSSWindow first = this.classifiers.get(0);
        sb.append("windowSize=").append(first.getWindowSize()).append("/wordLength=").append(first.getWordLength());
        sb.append("/alphabetSize=").append(first.getAlphabetSize()).append("/norm=").append(first.isNorm());
        for (int i = 1; i < this.classifiers.size(); ++i) {
            BOSSWindow boss = this.classifiers.get(i);
            sb.append(",windowSize=").append(boss.getWindowSize()).append("/wordLength=").append(boss.getWordLength());
            sb.append("/alphabetSize=").append(boss.getAlphabetSize()).append("/norm=").append(boss.isNorm());
        }
        return sb.toString();
    }

    @Override
    public int setNumberOfFolds(Instances data) {
        return data.numInstances();
    }

    public int[][] getParametersValues() {
        int[][] params = new int[this.classifiers.size()][];
        int i = 0;
        for (BOSSWindow boss : this.classifiers) {
            params[i++] = boss.getParameters();
        }
        return params;
    }

    public void setSerOption(SerialiseOptions option) {
        this.serOption = option;
    }

    public void setSerFileLoc(String path) {
        serFileLoc = path;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        double maxWindowSearches;
        int minWindow;
        if (data.classIndex() != data.numAttributes() - 1) {
            throw new Exception("BOSSEnsemble_BuildClassifier: Class attribute not set as last attribute in dataset");
        }
        if (this.serOption == SerialiseOptions.STORE || this.serOption == SerialiseOptions.STORE_LOAD) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = new Date();
            File f = new File(serFileLoc = serFileLoc + data.relationName() + "_" + dateFormat.format(date) + "\\");
            if (!f.isDirectory()) {
                f.mkdirs();
            }
        }
        if (data.numInstances() < this.numCVFolds) {
            this.numCVFolds = data.numInstances();
        }
        this.classifiers = new LinkedList<BOSSWindow>();
        int numSeries = data.numInstances();
        int seriesLength = data.numAttributes() - 1;
        int maxWindow = seriesLength;
        int winInc = (int)((double)(maxWindow - (minWindow = 10)) / (maxWindowSearches = (double)seriesLength / 4.0));
        if (winInc < 1) {
            winInc = 1;
        }
        double maxAcc = -1.0;
        double minMaxAcc = -1.0;
        for (boolean normalise : this.normOptions) {
            for (int winSize = minWindow; winSize <= maxWindow; winSize += winInc) {
                BOSSC45Individual boss = new BOSSC45Individual(this.wordLengths[0], 4, winSize, normalise);
                boss.buildBags = true;
                boss.buildForest = false;
                boss.buildClassifier(data);
                BOSSC45Individual bestClassifierForWinSize = null;
                double bestAccForWinSize = -1.0;
                for (Integer wordLen : this.wordLengths) {
                    double acc = (boss = boss.buildShortenedBags(wordLen)).findCVAcc(this.numCVFolds);
                    if (!(acc >= bestAccForWinSize)) continue;
                    bestAccForWinSize = acc;
                    bestClassifierForWinSize = boss;
                }
                if (!this.makesItIntoEnsemble(bestAccForWinSize, maxAcc, minMaxAcc, this.classifiers.size())) continue;
                BOSSWindow bw = new BOSSWindow(bestClassifierForWinSize, bestAccForWinSize, data.relationName());
                bw.classifier.clean();
                if (this.serOption == SerialiseOptions.STORE) {
                    bw.store();
                } else if (this.serOption == SerialiseOptions.STORE_LOAD) {
                    bw.storeAndClearClassifier();
                }
                this.classifiers.add(bw);
                if (bestAccForWinSize > maxAcc) {
                    maxAcc = bestAccForWinSize;
                    Iterator<BOSSWindow> it = this.classifiers.iterator();
                    while (it.hasNext()) {
                        BOSSWindow b = it.next();
                        if (!(b.accuracy < maxAcc * 0.92)) continue;
                        if (this.serOption == SerialiseOptions.STORE || this.serOption == SerialiseOptions.STORE_LOAD) {
                            b.deleteSerFile();
                        }
                        it.remove();
                    }
                }
                while (this.classifiers.size() > this.maxEnsembleSize) {
                    int minAccInd = (int)this.findMinEnsembleAcc()[0];
                    if (this.serOption == SerialiseOptions.STORE || this.serOption == SerialiseOptions.STORE_LOAD) {
                        this.classifiers.get(minAccInd).deleteSerFile();
                    }
                    this.classifiers.remove(minAccInd);
                }
                minMaxAcc = this.findMinEnsembleAcc()[1];
            }
        }
        Object object = this.classifiers.iterator();
        while (object.hasNext()) {
            BOSSWindow window = (BOSSWindow)object.next();
            window.classifier.buildFullForest();
        }
        if (this.trainCV) {
            OutFile of = new OutFile(this.trainCVPath);
            of.writeLine(data.relationName() + ",BOSSEnsemble,train");
            double[][] results = this.findEnsembleTrainAcc(data);
            of.writeLine(this.getParameters());
            of.writeLine(results[0][0] + "");
            for (int i = 1; i < results[0].length; ++i) {
                of.writeLine(results[0][i] + "," + results[1][i]);
            }
            System.out.println("CV acc =" + results[0][0]);
        }
    }

    private double[] findMinEnsembleAcc() {
        double minAcc = Double.MIN_VALUE;
        int minAccInd = 0;
        for (int i = 0; i < this.classifiers.size(); ++i) {
            double curacc = this.classifiers.get((int)i).accuracy;
            if (!(curacc < minAcc)) continue;
            minAcc = curacc;
            minAccInd = i;
        }
        return new double[]{minAccInd, minAcc};
    }

    private boolean makesItIntoEnsemble(double acc, double maxAcc, double minMaxAcc, int curEnsembleSize) {
        if (acc >= maxAcc * 0.92) {
            if (curEnsembleSize >= this.maxEnsembleSize) {
                return acc > minMaxAcc;
            }
            return true;
        }
        return false;
    }

    private double[][] findEnsembleTrainAcc(Instances data) throws Exception {
        double[][] results = new double[2][data.numInstances() + 1];
        double correct = 0.0;
        for (int i = 0; i < data.numInstances(); ++i) {
            double c = this.classifyInstance(i, data.numClasses());
            if (c == data.get(i).classValue()) {
                correct += 1.0;
            }
            results[0][i + 1] = data.get(i).classValue();
            results[1][i + 1] = c;
        }
        results[0][0] = correct / (double)data.numInstances();
        return results;
    }

    public double classifyInstance(int test, int numclasses) throws Exception {
        double[] dist = this.distributionForInstance(test, numclasses);
        double maxFreq = dist[0];
        double maxClass = 0.0;
        for (int i = 1; i < dist.length; ++i) {
            if (!(dist[i] > maxFreq)) continue;
            maxFreq = dist[i];
            maxClass = i;
        }
        return maxClass;
    }

    public double[] distributionForInstance(int test, int numclasses) throws Exception {
        double[] classHist = new double[numclasses];
        double sum = 0.0;
        for (BOSSWindow classifier : this.classifiers) {
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.load();
            }
            double classification = classifier.classifyInstance(test);
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.clearClassifier();
            }
            int n = (int)classification;
            classHist[n] = classHist[n] + 1.0;
            sum += 1.0;
        }
        if (sum != 0.0) {
            int i = 0;
            while (i < classHist.length) {
                int n = i++;
                classHist[n] = classHist[n] / sum;
            }
        }
        return classHist;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double[] dist = this.distributionForInstance(instance);
        double maxFreq = dist[0];
        double maxClass = 0.0;
        for (int i = 1; i < dist.length; ++i) {
            if (!(dist[i] > maxFreq)) continue;
            maxFreq = dist[i];
            maxClass = i;
        }
        return maxClass;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] classHist = new double[instance.numClasses()];
        double sum = 0.0;
        for (BOSSWindow classifier : this.classifiers) {
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.load();
            }
            double classification = classifier.classifyInstance(instance);
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.clearClassifier();
            }
            int n = (int)classification;
            classHist[n] = classHist[n] + 1.0;
            sum += 1.0;
        }
        if (sum != 0.0) {
            int i = 0;
            while (i < classHist.length) {
                int n = i++;
                classHist[n] = classHist[n] / sum;
            }
        }
        return classHist;
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) throws Exception {
        String dataset = "BeetleFly";
        Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dataset + "\\" + dataset + "_TRAIN.arff");
        Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dataset + "\\" + dataset + "_TEST.arff");
        BOSSC45 c = new BOSSC45();
        c.buildClassifier(train);
        double accuracy = ClassifierTools.accuracy(test, c);
        System.out.println("BOSSC45 accuracy on " + dataset + " fold 0 = " + accuracy);
    }

    public static void detailedFold0Test(String dset) {
        System.out.println("BOSSC45 DetailedTest\n");
        try {
            Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
            System.out.println(train.relationName());
            BOSSC45 boss = new BOSSC45();
            System.out.println("Training starting");
            long start = System.nanoTime();
            boss.buildClassifier(train);
            double trainTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Training done (" + trainTime + "s)");
            System.out.println("Ensemble Size: " + boss.classifiers.size());
            System.out.println("Param sets: ");
            int[][] params = boss.getParametersValues();
            for (int i = 0; i < params.length; ++i) {
                System.out.println(i + ": " + params[i][0] + " " + params[i][1] + " " + params[i][2] + " " + boss.classifiers.get(i).isNorm() + " " + boss.classifiers.get((int)i).accuracy);
            }
            System.out.println("\nTesting starting");
            start = System.nanoTime();
            double acc = ClassifierTools.accuracy(test, boss);
            double testTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Testing done (" + testTime + "s)");
            System.out.println("\nACC: " + acc);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static void resampleTest(String dset, int resamples) throws Exception {
        Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
        Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
        BOSSC45 c = new BOSSC45();
        double[] accs = new double[resamples];
        for (int i = 0; i < resamples; ++i) {
            Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, i);
            c.buildClassifier(data[0]);
            accs[i] = ClassifierTools.accuracy(data[1], c);
            if (i == 0) {
                System.out.print(accs[i]);
                continue;
            }
            System.out.print("," + accs[i]);
        }
        double mean = 0.0;
        for (int i = 0; i < resamples; ++i) {
            mean += accs[i];
        }
        System.out.println("\n\nBOSSEnsemble mean acc over " + resamples + " resamples: " + (mean /= (double)resamples));
    }

    public static class BOSSC45Individual
    extends BOSS.BOSSIndividual {
        public boolean buildBags = true;
        public boolean buildForest = true;
        public Instances bagInsts;
        public J48 tree = new J48();
        private Attribute classAttribute;

        public BOSSC45Individual(int wordLength, int alphabetSize, int windowSize, boolean normalise) {
            super(wordLength, alphabetSize, windowSize, normalise);
        }

        public BOSSC45Individual(BOSSC45Individual boss, int wordLength) {
            super(boss, wordLength);
            this.classAttribute = boss.classAttribute;
        }

        public Instances bagsToInstances() {
            FastVector<Attribute> attInfo = new FastVector<Attribute>();
            HashSet<String> wordsFound = new HashSet<String>();
            for (BOSS.BOSSIndividual.Bag bag : this.bags) {
                for (Map.Entry entry : bag.entrySet()) {
                    wordsFound.add(((BitWord)entry.getKey()).toString());
                }
            }
            for (String word : wordsFound) {
                attInfo.add(new Attribute(word));
            }
            attInfo.add(this.classAttribute);
            Instances bagInsts = new Instances("", attInfo, this.bags.size());
            bagInsts.setClassIndex(attInfo.size() - 1);
            int i = 0;
            for (BOSS.BOSSIndividual.Bag bag : this.bags) {
                double[] init = new double[attInfo.size()];
                init[init.length - 1] = bag.getClassVal();
                bagInsts.add(new DenseInstance(1.0, init));
                for (Map.Entry entry : bag.entrySet()) {
                    bagInsts.get(i).setValue(bagInsts.attribute(((BitWord)entry.getKey()).toString()), (double)((Integer)entry.getValue()).intValue());
                }
                ++i;
            }
            return bagInsts;
        }

        @Override
        public void buildClassifier(Instances data) throws Exception {
            this.classAttribute = data.classAttribute();
            if (this.buildBags) {
                super.buildClassifier(data);
            }
            if (this.buildForest) {
                this.buildFullForest();
            }
        }

        public void buildFullForest() throws Exception {
            if (this.bagInsts == null) {
                this.bagInsts = this.bagsToInstances();
            }
            if (this.tree == null) {
                this.tree = new J48();
            }
            this.tree.buildClassifier(this.bagInsts);
        }

        public double findCVAcc(int numFolds) throws Exception {
            if (this.bagInsts == null) {
                this.bagInsts = this.bagsToInstances();
            }
            if (this.tree == null) {
                this.tree = new J48();
            }
            return ClassifierTools.crossValidationWithStats(this.tree, this.bagInsts, numFolds)[0][0];
        }

        @Override
        public BOSSC45Individual buildShortenedBags(int newWordLength) throws Exception {
            if (newWordLength == this.wordLength) {
                return this;
            }
            if (newWordLength > this.wordLength) {
                throw new Exception("Cannot incrementally INCREASE word length, current:" + this.wordLength + ", requested:" + newWordLength);
            }
            if (newWordLength < 2) {
                throw new Exception("Invalid wordlength requested, current:" + this.wordLength + ", requested:" + newWordLength);
            }
            BOSSC45Individual newBoss = new BOSSC45Individual(this, newWordLength);
            for (int i = 0; i < this.bags.size(); ++i) {
                BOSS.BOSSIndividual.Bag newBag = this.createBagFromWords(newWordLength, this.SFAwords[i]);
                newBag.setClassVal(((BOSS.BOSSIndividual.Bag)this.bags.get(i)).getClassVal());
                newBoss.bags.add(newBag);
            }
            return newBoss;
        }

        @Override
        public void clean() {
            super.clean();
            this.bags = null;
            this.tree = null;
        }

        @Override
        public double classifyInstance(Instance instance) throws Exception {
            BOSS.BOSSIndividual.Bag testBag = this.BOSSTransform(instance);
            double[] init = new double[this.bagInsts.numAttributes()];
            init[init.length - 1] = testBag.getClassVal();
            this.bagInsts.add(new DenseInstance(1.0, init));
            for (Map.Entry entry : testBag.entrySet()) {
                Attribute att = this.bagInsts.attribute(((BitWord)entry.getKey()).toString());
                if (att == null) continue;
                this.bagInsts.get(this.bagInsts.size() - 1).setValue(att, (double)((Integer)entry.getValue()).intValue());
            }
            Instance testInst = this.bagInsts.remove(this.bagInsts.size() - 1);
            return this.tree.classifyInstance(testInst);
        }

        @Override
        public double[] distributionForInstance(Instance instance) throws Exception {
            BOSS.BOSSIndividual.Bag testBag = this.BOSSTransform(instance);
            double[] init = new double[this.bagInsts.numAttributes()];
            init[init.length - 1] = testBag.getClassVal();
            this.bagInsts.add(new DenseInstance(1.0, init));
            for (Map.Entry entry : testBag.entrySet()) {
                Attribute att = this.bagInsts.attribute(((BitWord)entry.getKey()).toString());
                if (att == null) continue;
                this.bagInsts.get(this.bagInsts.numInstances() - 1).setValue(att, (double)((Integer)entry.getValue()).intValue());
            }
            Instance testInst = this.bagInsts.remove(this.bagInsts.size() - 1);
            return this.tree.distributionForInstance(testInst);
        }
    }

    public static class BOSSWindow
    implements Comparable<BOSSWindow>,
    Serializable {
        private BOSSC45Individual classifier;
        public double accuracy;
        public String filename;
        private static final long serialVersionUID = 2L;

        public BOSSWindow(String filename) {
            this.filename = filename;
        }

        public BOSSWindow(BOSSC45Individual classifer, double accuracy, String dataset) {
            this.classifier = classifer;
            this.accuracy = accuracy;
            this.buildFileName(dataset);
        }

        public double classifyInstance(Instance inst) throws Exception {
            return this.classifier.classifyInstance(inst);
        }

        public double classifyInstance(int test) throws Exception {
            return this.classifier.classifyInstance(test);
        }

        private void buildFileName(String dataset) {
            this.filename = serFileLoc + dataset + "_" + this.classifier.getWindowSize() + "_" + this.classifier.getWordLength() + "_" + this.classifier.getAlphabetSize() + "_" + this.classifier.isNorm() + ".ser";
        }

        public boolean storeAndClearClassifier() {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.filename));
                out.writeObject(this);
                out.close();
                this.clearClassifier();
                return true;
            }
            catch (IOException e) {
                System.out.print("Error serialiszing to " + this.filename);
                e.printStackTrace();
                return false;
            }
        }

        public boolean store() {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.filename));
                out.writeObject(this);
                out.close();
                return true;
            }
            catch (IOException e) {
                System.out.print("Error serialiszing to " + this.filename);
                e.printStackTrace();
                return false;
            }
        }

        public void clearClassifier() {
            this.classifier = null;
        }

        public boolean load() {
            BOSSWindow bw = null;
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.filename));
                bw = (BOSSWindow)in.readObject();
                in.close();
                this.accuracy = bw.accuracy;
                this.classifier = bw.classifier;
                return true;
            }
            catch (IOException i) {
                System.out.print("Error deserialiszing from " + this.filename);
                i.printStackTrace();
                return false;
            }
            catch (ClassNotFoundException c) {
                System.out.println("BOSSWindow class not found");
                c.printStackTrace();
                return false;
            }
        }

        public boolean deleteSerFile() {
            try {
                File f = new File(this.filename);
                return f.delete();
            }
            catch (SecurityException s) {
                System.out.println("Unable to delete, access denied: " + this.filename);
                s.printStackTrace();
                return false;
            }
        }

        public int[] getParameters() {
            return this.classifier.getParameters();
        }

        public int getWindowSize() {
            return this.classifier.getWindowSize();
        }

        public int getWordLength() {
            return this.classifier.getWordLength();
        }

        public int getAlphabetSize() {
            return this.classifier.getAlphabetSize();
        }

        public boolean isNorm() {
            return this.classifier.isNorm();
        }

        @Override
        public int compareTo(BOSSWindow other) {
            if (this.accuracy > other.accuracy) {
                return 1;
            }
            if (this.accuracy == other.accuracy) {
                return 0;
            }
            return -1;
        }
    }

    public static enum SerialiseOptions {
        NONE,
        STORE,
        STORE_LOAD;

    }
}

