/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import timeseriesweka.classifiers.AbstractClassifierWithTrainingData;
import timeseriesweka.filters.SAX;
import utilities.ClassifierTools;
import weka.classifiers.lazy.kNN;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.unsupervised.instance.Randomize;

public class SAX_1NN
extends AbstractClassifierWithTrainingData {
    public Instances SAXdata;
    private kNN knn;
    private SAX sax;
    private final int PAA_intervalsPerWindow;
    private final int SAX_alphabetSize;

    public SAX_1NN(int PAA_intervalsPerWindow, int SAX_alphabetSize) {
        this.PAA_intervalsPerWindow = PAA_intervalsPerWindow;
        this.SAX_alphabetSize = SAX_alphabetSize;
        this.sax = new SAX();
        this.sax.setNumIntervals(PAA_intervalsPerWindow);
        this.sax.setAlphabetSize(SAX_alphabetSize);
        this.sax.useRealValuedAttributes(false);
        this.knn = new kNN();
    }

    @Override
    public String getParameters() {
        return super.getParameters() + ",PAAIntervalsPerWindow," + this.PAA_intervalsPerWindow + ",alphabetSize," + this.SAX_alphabetSize;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.trainResults.buildTime = System.currentTimeMillis();
        this.SAXdata = this.sax.process(data);
        this.knn.buildClassifier(this.SAXdata);
        this.trainResults.buildTime = System.currentTimeMillis() - this.trainResults.buildTime;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        Instance saxinst = this.sax.convertInstance(instance, this.SAX_alphabetSize, this.PAA_intervalsPerWindow);
        return this.knn.classifyInstance(saxinst);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        Instance saxinst = this.sax.convertInstance(instance, this.SAX_alphabetSize, this.PAA_intervalsPerWindow);
        return this.knn.distributionForInstance(saxinst);
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        System.out.println("BagofPatternsTest\n\n");
        try {
            Instances all = ClassifierTools.loadData("C:\\\\Temp\\\\TESTDATA\\\\FiveClassV1.arff");
            all.deleteAttributeAt(0);
            Randomize rand = new Randomize();
            rand.setInputFormat(all);
            for (int i = 0; i < all.numInstances(); ++i) {
                rand.input(all.get(i));
            }
            rand.batchFinished();
            int trainNum = (int)((double)all.numInstances() * 0.7);
            int testNum = all.numInstances() - trainNum;
            Instances train = new Instances(all, trainNum);
            for (int i = 0; i < trainNum; ++i) {
                train.add(rand.output());
            }
            Instances test = new Instances(all, testNum);
            for (int i = 0; i < testNum; ++i) {
                test.add(rand.output());
            }
            SAX_1NN saxc = new SAX_1NN(6, 3);
            saxc.buildClassifier(train);
            System.out.println(saxc.SAXdata);
            System.out.println("\nACCURACY TEST");
            System.out.println(ClassifierTools.accuracy(test, saxc));
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public String toString() {
        return "SAX";
    }
}

