/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import timeseriesweka.classifiers.AbstractClassifierWithTrainingData;
import timeseriesweka.filters.BagOfPatternsFilter;
import utilities.ClassifierTools;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.TechnicalInformation;

public class SAXVSM
extends AbstractClassifierWithTrainingData {
    Instances transformedData;
    Instances corpus;
    private BagOfPatternsFilter bop;
    private int PAA_intervalsPerWindow;
    private int SAX_alphabetSize;
    private int windowSize;
    private final boolean useParamSearch;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "P. Senin and S. Malinchik");
        result.setValue(TechnicalInformation.Field.TITLE, "SAX-VSM: Interpretable Time Series Classification Using SAX and Vector Space Model");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Proc. 13th IEEE ICDM");
        result.setValue(TechnicalInformation.Field.YEAR, "2013");
        return result;
    }

    public SAXVSM() {
        this.PAA_intervalsPerWindow = -1;
        this.SAX_alphabetSize = -1;
        this.windowSize = -1;
        this.useParamSearch = true;
    }

    public SAXVSM(int PAA_intervalsPerWindow, int SAX_alphabetSize, int windowSize) {
        this.PAA_intervalsPerWindow = PAA_intervalsPerWindow;
        this.SAX_alphabetSize = SAX_alphabetSize;
        this.windowSize = windowSize;
        this.bop = new BagOfPatternsFilter(PAA_intervalsPerWindow, SAX_alphabetSize, windowSize);
        this.useParamSearch = false;
    }

    public int getPAA_intervalsPerWindow() {
        return this.PAA_intervalsPerWindow;
    }

    public int getSAX_alphabetSize() {
        return this.SAX_alphabetSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int[] getParametersArray() {
        return new int[]{this.PAA_intervalsPerWindow, this.SAX_alphabetSize, this.windowSize};
    }

    @Override
    public String getParameters() {
        return super.getParameters() + ",PAAIntervalsPerWindow," + this.PAA_intervalsPerWindow + ",alphabetSize," + this.SAX_alphabetSize + ",windowSize," + this.windowSize;
    }

    public static int[] parameterSearch(Instances data) throws Exception {
        double bestAcc = -1.0;
        int bestAlpha = 0;
        int bestWord = 0;
        int bestWindowSize = 0;
        int minWinSize = (int)((double)(data.numAttributes() - 1) * 0.15);
        int maxWinSize = (int)((double)(data.numAttributes() - 1) * 0.36);
        int winInc = (int)((double)(maxWinSize - minWinSize) / 10.0);
        if (winInc < 1) {
            winInc = 1;
        }
        for (int alphaSize = 2; alphaSize <= 8; alphaSize += 2) {
            for (int winSize = minWinSize; winSize <= maxWinSize; winSize += winInc) {
                for (int wordSize = 2; wordSize <= 8 && wordSize < winSize; ++wordSize) {
                    SAXVSM vsm = new SAXVSM(wordSize, alphaSize, winSize);
                    double acc = vsm.crossValidate(data);
                    if (!(acc > bestAcc)) continue;
                    bestAcc = acc;
                    bestAlpha = alphaSize;
                    bestWord = wordSize;
                    bestWindowSize = winSize;
                }
            }
        }
        return new int[]{bestWord, bestAlpha, bestWindowSize};
    }

    private double crossValidate(Instances data) throws Exception {
        this.transformedData = this.bop.process(data);
        double correct = 0.0;
        for (int i = 0; i < data.numInstances(); ++i) {
            this.corpus = this.tfxidf(this.transformedData, i);
            if (this.classifyInstance(data.get(i)) != data.get(i).classValue()) continue;
            correct += 1.0;
        }
        return correct / (double)data.numInstances();
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.trainResults.buildTime = System.currentTimeMillis();
        if (data.classIndex() != data.numAttributes() - 1) {
            throw new Exception("SAXVSM_BuildClassifier: Class attribute not set as last attribute in dataset");
        }
        if (this.useParamSearch) {
            int[] params = SAXVSM.parameterSearch(data);
            this.PAA_intervalsPerWindow = params[0];
            this.SAX_alphabetSize = params[1];
            this.windowSize = params[2];
            this.bop = new BagOfPatternsFilter(this.PAA_intervalsPerWindow, this.SAX_alphabetSize, this.windowSize);
        }
        if (this.PAA_intervalsPerWindow < 1) {
            throw new Exception("SAXVSM_BuildClassifier: Invalid PAA word size: " + this.PAA_intervalsPerWindow);
        }
        if (this.PAA_intervalsPerWindow > this.windowSize) {
            throw new Exception("SAXVSM_BuildClassifier: Invalid PAA word size, bigger than sliding window size: " + this.PAA_intervalsPerWindow + "," + this.windowSize);
        }
        if (this.SAX_alphabetSize < 2 || this.SAX_alphabetSize > 10) {
            throw new Exception("SAXVSM_BuildClassifier: Invalid SAX alphabet size (valid=2-10): " + this.SAX_alphabetSize);
        }
        if (this.windowSize < 1 || this.windowSize > data.numAttributes() - 1) {
            throw new Exception("SAXVSM_BuildClassifier: Invalid sliding window size: " + this.windowSize + " (series length " + (data.numAttributes() - 1) + ")");
        }
        this.transformedData = this.bop.process(data);
        this.corpus = this.tfxidf(this.transformedData);
        this.trainResults.buildTime = System.currentTimeMillis() - this.trainResults.buildTime;
    }

    public Instances tfxidf(Instances bopData) {
        return this.tfxidf(bopData, -1);
    }

    private Instances tfxidf(Instances bopData, int skip) {
        int j;
        int numClasses = bopData.numClasses();
        int numInstances = bopData.numInstances();
        int numTerms = bopData.numAttributes() - 1;
        double[][] classWeights = new double[numClasses][numTerms];
        int inst = 0;
        for (Instance in : bopData) {
            if (inst++ == skip) continue;
            int classVal = (int)in.classValue();
            for (j = 0; j < numTerms; ++j) {
                double[] dArray = classWeights[classVal];
                int n = j;
                dArray[n] = dArray[n] + in.value(j);
            }
        }
        for (int i = 0; i < numTerms; ++i) {
            double df = 0.0;
            for (j = 0; j < numClasses; ++j) {
                if (classWeights[j][i] == 0.0) continue;
                df += 1.0;
            }
            if (df == 0.0) continue;
            if (df != (double)numClasses) {
                for (j = 0; j < numClasses; ++j) {
                    if (classWeights[j][i] == 0.0) continue;
                    classWeights[j][i] = Math.log(1.0 + classWeights[j][i]) * Math.log((double)numClasses / df);
                }
                continue;
            }
            for (j = 0; j < numClasses; ++j) {
                classWeights[j][i] = 0.0;
            }
        }
        Instances tfxidfCorpus = new Instances(bopData, numClasses);
        for (int i = 0; i < numClasses; ++i) {
            tfxidfCorpus.add(new SparseInstance(1.0, classWeights[i]));
        }
        return tfxidfCorpus;
    }

    public double cosineSimilarity(double[] a, double[] b) throws Exception {
        if (a.length != b.length) {
            throw new Exception("Cannot calculate cosine similarity between vectors of different lengths (" + a.length + ", " + b.length + ")");
        }
        return this.cosineSimilarity(a, b, a.length);
    }

    public double cosineSimilarity(double[] a, double[] b, int n) throws Exception {
        if (n > a.length || n > b.length) {
            throw new IllegalArgumentException("SAXVSM_CosineSimilarity n greater than vector lengths (a:" + a.length + ", b:" + b.length + " n:" + n + ")");
        }
        double dotProd = 0.0;
        double aMag = 0.0;
        double bMag = 0.0;
        for (int i = 0; i < n; ++i) {
            dotProd += a[i] * b[i];
            aMag += a[i] * a[i];
            bMag += b[i] * b[i];
        }
        if (aMag == 0.0 || bMag == 0.0 || dotProd == 0.0) {
            return 0.0;
        }
        if (aMag == bMag) {
            return dotProd / aMag;
        }
        return dotProd / (Math.sqrt(aMag) * Math.sqrt(bMag));
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        int numClasses = this.corpus.numInstances();
        double[] distribution = this.distributionForInstance(instance);
        double maxIndex = 0.0;
        double max = distribution[0];
        for (int i = 1; i < numClasses; ++i) {
            if (!(distribution[i] > max)) continue;
            max = distribution[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        int i;
        int numClasses = this.corpus.numInstances();
        double[] termFreqs = this.bop.bagToArray(this.bop.buildBag(instance));
        double[] similarities = new double[numClasses];
        double sum = 0.0;
        for (i = 0; i < numClasses; ++i) {
            similarities[i] = this.cosineSimilarity(this.corpus.get(i).toDoubleArray(), termFreqs, termFreqs.length);
            sum += similarities[i];
        }
        if (sum != 0.0) {
            i = 0;
            while (i < numClasses) {
                int n = i++;
                similarities[n] = similarities[n] / sum;
            }
        }
        return similarities;
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        SAXVSM.basicTest();
    }

    public static void basicTest() {
        System.out.println("SAXVSMBasicTest\n");
        try {
            Instances train = ClassifierTools.loadData("C:\\tempbakeoff\\TSC Problems\\Car\\Car_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\tempbakeoff\\TSC Problems\\Car\\Car_TEST.arff");
            System.out.println(train.relationName());
            SAXVSM vsm = new SAXVSM();
            System.out.println("Training starting");
            long start = System.nanoTime();
            vsm.buildClassifier(train);
            double trainTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Training done (" + trainTime + "s)");
            System.out.print("Params: ");
            for (int p : vsm.getParametersArray()) {
                System.out.print(p + " ");
            }
            System.out.println("");
            System.out.println("\nTesting starting");
            start = System.nanoTime();
            double acc = ClassifierTools.accuracy(test, vsm);
            double testTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Testing done (" + testTime + "s)");
            System.out.println("\nACC: " + acc);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public String toString() {
        return "SAXVSM";
    }
}

