/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import java.text.DecimalFormat;
import timeseriesweka.classifiers.DD_DTW;
import timeseriesweka.elastic_distance_measures.DTW_DistanceBasic;
import timeseriesweka.filters.Cosine;
import timeseriesweka.filters.Hilbert;
import timeseriesweka.filters.Sine;
import utilities.ClassifierTools;
import weka.classifiers.lazy.kNN;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.filters.SimpleBatchFilter;

public class DTD_C
extends DD_DTW {
    public static final String DATA_DIR = "C:/Temp/Dropbox/TSC Problems/";
    public static final double[] ALPHAS = new double[]{1.0, 1.01, 1.02, 1.03, 1.04, 1.05, 1.06, 1.07, 1.08, 1.09, 1.1, 1.11, 1.12, 1.13, 1.14, 1.15, 1.16, 1.17, 1.18, 1.19, 1.2, 1.21, 1.22, 1.23, 1.24, 1.25, 1.26, 1.27, 1.28, 1.29, 1.3, 1.31, 1.32, 1.33, 1.34, 1.35, 1.36, 1.37, 1.38, 1.39, 1.4, 1.41, 1.42, 1.43, 1.44, 1.45, 1.46, 1.47, 1.48, 1.49, 1.5, 1.51, 1.52, 1.53, 1.54, 1.55, 1.56, 1.57};
    public static final String[] PAPER_DATASETS = new String[]{"fiftywords", "Adiac", "Beef", "Car", "CBF", "ChlorineConcentration", "CinC_ECG_torso", "Coffee", "Cricket_X", "Cricket_Y", "Cricket_Z", "DiatomSizeReduction", "ECGFiveDays", "FaceAll", "FaceFour", "FacesUCR", "fish", "GunPoint", "Haptics", "InlineSkate", "ItalyPowerDemand", "Lightning2", "Lightning7", "MALLAT", "MedicalImages", "MoteStrain", "NonInvasiveFatalECG_Thorax1", "NonInvasiveFatalECG_Thorax2", "OliveOil", "OSULeaf", "Plane", "SonyAIBORobotSurface", "SonyAIBORobotSurfaceII", "StarLightCurves", "SwedishLeaf", "Symbols", "SyntheticControl", "Trace", "TwoPatterns", "TwoLeadECG", "UWaveGestureLibrary_X", "UWaveGestureLibrary_Y", "UWaveGestureLibrary_Z", "wafer", "WordSynonyms", "yoga"};
    private TransformType transformType;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "T. G\u00f3recki and M. \u0141uczak");
        result.setValue(TechnicalInformation.Field.TITLE, "Non-isometric transforms in time series classification using DTW");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Knowledge-Based Systems");
        result.setValue(TechnicalInformation.Field.VOLUME, "61");
        result.setValue(TechnicalInformation.Field.PAGES, "98-108");
        result.setValue(TechnicalInformation.Field.YEAR, "2014");
        return result;
    }

    public DTD_C() {
        this.transformType = TransformType.COS;
        this.distanceFunction = new TransformWeightedDTW(this.transformType);
    }

    public DTD_C(TransformType transformType) {
        this.transformType = transformType;
        this.distanceFunction = new TransformWeightedDTW(this.transformType);
    }

    @Override
    public String getParameters() {
        return super.getParameters() + ",transformType," + (Object)((Object)this.transformType);
    }

    public static void recreateResultsTable() throws Exception {
        System.out.println("Recreating Results from Gorecki 2:");
        DecimalFormat df = new DecimalFormat("#.##");
        SimpleBatchFilter[] transforms = new SimpleBatchFilter[]{new Cosine(), new Sine(), new Hilbert()};
        TransformType[] transformTypes = new TransformType[]{TransformType.COS, TransformType.SIN, TransformType.HIL};
        System.out.println("Dataset,fullCosDTW,fullSinDTW,fullHilDTW,weightedCosDTW,weightedSinDTW,weightedHilDTW");
        for (String dataset : PAPER_DATASETS) {
            double err;
            double acc;
            int correct;
            System.out.print(dataset + ",");
            Instances train = ClassifierTools.loadData(DATA_DIR + dataset + "/" + dataset + "_TRAIN");
            Instances test = ClassifierTools.loadData(DATA_DIR + dataset + "/" + dataset + "_TEST");
            for (SimpleBatchFilter simpleBatchFilter : transforms) {
                Instances transTrain = simpleBatchFilter.process(train);
                Instances transTest = simpleBatchFilter.process(test);
                DTW_DistanceBasic dtw = new DTW_DistanceBasic();
                kNN knn = new kNN();
                knn.setDistanceFunction(dtw);
                correct = DTD_C.getCorrect(knn, transTrain, transTest);
                acc = (double)correct / (double)test.numInstances();
                err = (1.0 - acc) * 100.0;
                System.out.print(df.format(err) + ",");
            }
            for (TransformType transformType : transformTypes) {
                DTD_C tdtw = new DTD_C(transformType);
                correct = DTD_C.getCorrect(tdtw, train, test);
                acc = (double)correct / (double)test.numInstances();
                err = (1.0 - acc) * 100.0;
                System.out.print(df.format(err) + ",");
            }
            System.out.println("");
        }
    }

    public static void main(String[] args) {
        int option = 1;
        try {
            if (option == 1) {
                String dataName = "ItalyPowerDemand";
                Instances train = ClassifierTools.loadData(DATA_DIR + dataName + "/" + dataName + "_TRAIN");
                Instances test = ClassifierTools.loadData(DATA_DIR + dataName + "/" + dataName + "_TEST");
                DTD_C nntw = new DTD_C(TransformType.COS);
                nntw.buildClassifier(train);
                int correct = 0;
                for (int i = 0; i < test.numInstances(); ++i) {
                    if (nntw.classifyInstance(test.instance(i)) != test.instance(i).classValue()) continue;
                    ++correct;
                }
                System.out.println(dataName + ":\t" + new DecimalFormat("#.###").format((double)correct / (double)test.numInstances() * 100.0) + "%");
            } else if (option == 2) {
                DTD_C.recreateResultsTable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class TransformWeightedDTW
    extends DD_DTW.GoreckiDerivativesDTW {
        private TransformType transformType;

        public TransformWeightedDTW(TransformType transformType) {
            this.transformType = transformType;
        }

        @Override
        public double[] getNonScaledDistances(Instance first, Instance second) {
            DTW_DistanceBasic dtw = new DTW_DistanceBasic();
            boolean classPenalty = false;
            if (first.classIndex() > 0) {
                classPenalty = true;
            }
            Instances temp = new Instances(first.dataset(), 0);
            temp.add(first);
            temp.add(second);
            try {
                switch (this.transformType) {
                    case COS: {
                        temp = new Cosine().process(temp);
                        break;
                    }
                    case SIN: {
                        temp = new Sine().process(temp);
                        break;
                    }
                    case HIL: {
                        temp = new Hilbert().process(temp);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            double dist = dtw.distance(first, second);
            double transDist = dtw.distance(temp.get(0), temp.get(1), Double.MAX_VALUE);
            return new double[]{Math.sqrt(dist), Math.sqrt(transDist)};
        }
    }

    public static enum TransformType {
        SIN,
        COS,
        HIL;

    }
}

