/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import fileIO.OutFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import timeseriesweka.classifiers.AbstractClassifierWithTrainingData;
import timeseriesweka.classifiers.cote.HiveCoteModule;
import utilities.BitWord;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.TrainAccuracyEstimate;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class BOSS
extends AbstractClassifierWithTrainingData
implements HiveCoteModule,
TrainAccuracyEstimate {
    private List<BOSSWindow> classifiers;
    private final double correctThreshold = 0.92;
    private int maxEnsembleSize = Integer.MAX_VALUE;
    private final Integer[] wordLengths = new Integer[]{16, 14, 12, 10, 8};
    private final int alphabetSize = 4;
    private boolean loadFeatureSets = false;
    private int fold = 0;
    private SerialiseOptions serOption = SerialiseOptions.NONE;
    private static String serFileLoc = "BOSSWindowSers\\";
    private static String featureFileLoc = "C:/JamesLPHD/featuresets/BOSSEnsemble/";
    private boolean[] normOptions;
    private String trainCVPath;
    private boolean trainCV = false;
    private Instances train;
    private double ensembleCvAcc = -1.0;
    private double[] ensembleCvPreds = null;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "P. Schafer");
        result.setValue(TechnicalInformation.Field.TITLE, "The BOSS is concerned with time series classification in the presence of noise");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Data Mining and Knowledge Discovery");
        result.setValue(TechnicalInformation.Field.VOLUME, "29");
        result.setValue(TechnicalInformation.Field.NUMBER, "6");
        result.setValue(TechnicalInformation.Field.PAGES, "1505-1530");
        result.setValue(TechnicalInformation.Field.YEAR, "2015");
        return result;
    }

    @Override
    public void writeCVTrainToFile(String outputPathAndName) {
        this.trainCVPath = outputPathAndName;
        this.trainCV = true;
    }

    @Override
    public boolean findsTrainAccuracyEstimate() {
        return this.trainCV;
    }

    @Override
    public ClassifierResults getTrainResults() {
        this.trainResults.acc = this.ensembleCvAcc;
        return this.trainResults;
    }

    public BOSS(boolean normalise) {
        this.normOptions = new boolean[]{normalise};
    }

    public BOSS() {
        this.normOptions = new boolean[]{true, false};
    }

    @Override
    public String getParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getParameters());
        BOSSWindow first = this.classifiers.get(0);
        sb.append(",windowSize,").append(first.getWindowSize()).append(",wordLength,").append(first.getWordLength());
        sb.append(",alphabetSize,").append(first.getAlphabetSize()).append(",norm,").append(first.isNorm());
        for (int i = 1; i < this.classifiers.size(); ++i) {
            BOSSWindow boss = this.classifiers.get(i);
            sb.append(",windowSize,").append(boss.getWindowSize()).append(",wordLength,").append(boss.getWordLength());
            sb.append(",alphabetSize,").append(boss.getAlphabetSize()).append(",norm,").append(boss.isNorm());
        }
        return sb.toString();
    }

    public int[][] getParametersValues() {
        int[][] params = new int[this.classifiers.size()][];
        int i = 0;
        for (BOSSWindow boss : this.classifiers) {
            params[i++] = boss.getParameters();
        }
        return params;
    }

    public void setSerOption(SerialiseOptions option) {
        this.serOption = option;
    }

    public void setSerFileLoc(String path) {
        serFileLoc = path;
    }

    public void setFeatureFileLoc(String path) {
        featureFileLoc = path;
    }

    public void setMaxEnsembleSize(int max) {
        this.maxEnsembleSize = max;
    }

    public void setLoadFeatures(boolean load, int fold) {
        this.loadFeatureSets = load;
        this.fold = fold;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        double maxWindowSearches;
        int minWindow;
        this.trainResults.buildTime = System.currentTimeMillis();
        this.train = data;
        if (data.classIndex() != data.numAttributes() - 1) {
            throw new Exception("BOSSEnsemble_BuildClassifier: Class attribute not set as last attribute in dataset");
        }
        if (this.serOption == SerialiseOptions.STORE || this.serOption == SerialiseOptions.STORE_LOAD) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = new Date();
            File f = new File(serFileLoc = serFileLoc + data.relationName() + "_" + dateFormat.format(date) + "\\");
            if (!f.isDirectory()) {
                f.mkdirs();
            }
        }
        this.classifiers = new LinkedList<BOSSWindow>();
        int numSeries = data.numInstances();
        int seriesLength = data.numAttributes() - 1;
        int maxWindow = seriesLength;
        int winInc = (int)((double)(maxWindow - (minWindow = 10)) / (maxWindowSearches = (double)seriesLength / 4.0));
        if (winInc < 1) {
            winInc = 1;
        }
        double maxAcc = -1.0;
        double minMaxAcc = -1.0;
        for (boolean normalise : this.normOptions) {
            for (int winSize = minWindow; winSize <= maxWindow; winSize += winInc) {
                BOSSIndividual boss = null;
                if (this.loadFeatureSets) {
                    try {
                        boss = BOSSIndividual.loadFeatureSet(featureFileLoc, data.relationName(), this.fold, "BOSS", winSize, this.wordLengths[0], 4, normalise);
                    }
                    catch (Exception e) {
                        boss = new BOSSIndividual(this.wordLengths[0], 4, winSize, normalise);
                        boss.buildClassifier(data);
                        BOSSIndividual.serialiseFeatureSet(boss, featureFileLoc, data.relationName(), this.fold);
                    }
                } else {
                    boss = new BOSSIndividual(this.wordLengths[0], 4, winSize, normalise);
                    boss.buildClassifier(data);
                }
                BOSSIndividual bestClassifierForWinSize = null;
                double bestAccForWinSize = -1.0;
                for (Integer wordLen : this.wordLengths) {
                    boss = boss.buildShortenedBags(wordLen);
                    int correct = 0;
                    for (int i = 0; i < numSeries; ++i) {
                        double c = boss.classifyInstance(i);
                        if (c != data.get(i).classValue()) continue;
                        ++correct;
                    }
                    double acc = (double)correct / (double)numSeries;
                    if (!(acc >= bestAccForWinSize)) continue;
                    bestAccForWinSize = acc;
                    bestClassifierForWinSize = boss;
                }
                if (!this.makesItIntoEnsemble(bestAccForWinSize, maxAcc, minMaxAcc, this.classifiers.size())) continue;
                BOSSWindow bw = new BOSSWindow(bestClassifierForWinSize, bestAccForWinSize, data.relationName());
                bw.classifier.clean();
                if (this.serOption == SerialiseOptions.STORE) {
                    bw.store();
                } else if (this.serOption == SerialiseOptions.STORE_LOAD) {
                    bw.storeAndClearClassifier();
                }
                this.classifiers.add(bw);
                if (bestAccForWinSize > maxAcc) {
                    maxAcc = bestAccForWinSize;
                    Iterator<BOSSWindow> it = this.classifiers.iterator();
                    while (it.hasNext()) {
                        BOSSWindow b = it.next();
                        if (!(b.accuracy < maxAcc * 0.92)) continue;
                        if (this.serOption == SerialiseOptions.STORE || this.serOption == SerialiseOptions.STORE_LOAD) {
                            b.deleteSerFile();
                        }
                        it.remove();
                    }
                }
                while (this.classifiers.size() > this.maxEnsembleSize) {
                    int minAccInd = (int)this.findMinEnsembleAcc()[0];
                    if (this.serOption == SerialiseOptions.STORE || this.serOption == SerialiseOptions.STORE_LOAD) {
                        this.classifiers.get(minAccInd).deleteSerFile();
                    }
                    this.classifiers.remove(minAccInd);
                }
                minMaxAcc = this.findMinEnsembleAcc()[1];
            }
        }
        this.trainResults.buildTime = System.currentTimeMillis() - this.trainResults.buildTime;
        if (this.trainCV) {
            OutFile of = new OutFile(this.trainCVPath);
            of.writeLine(data.relationName() + ",BOSSEnsemble,train");
            double[][] results = this.findEnsembleTrainAcc(data);
            of.writeLine(this.getParameters());
            of.writeLine(results[0][0] + "");
            this.ensembleCvAcc = results[0][0];
            for (int i = 1; i < results[0].length; ++i) {
                of.writeLine(results[0][i] + "," + results[1][i]);
            }
            System.out.println("CV acc =" + results[0][0]);
        }
    }

    private double[] findMinEnsembleAcc() {
        double minAcc = Double.MIN_VALUE;
        int minAccInd = 0;
        for (int i = 0; i < this.classifiers.size(); ++i) {
            double curacc = this.classifiers.get((int)i).accuracy;
            if (!(curacc < minAcc)) continue;
            minAcc = curacc;
            minAccInd = i;
        }
        return new double[]{minAccInd, minAcc};
    }

    private boolean makesItIntoEnsemble(double acc, double maxAcc, double minMaxAcc, int curEnsembleSize) {
        if (acc >= maxAcc * 0.92) {
            if (curEnsembleSize >= this.maxEnsembleSize) {
                return acc > minMaxAcc;
            }
            return true;
        }
        return false;
    }

    private double[][] findEnsembleTrainAcc(Instances data) throws Exception {
        double[][] results = new double[2][data.numInstances() + 1];
        this.ensembleCvPreds = new double[data.numInstances()];
        double correct = 0.0;
        for (int i = 0; i < data.numInstances(); ++i) {
            double c = this.classifyInstance(i, data.numClasses());
            if (c == data.get(i).classValue()) {
                correct += 1.0;
            }
            results[0][i + 1] = data.get(i).classValue();
            results[1][i + 1] = c;
            this.ensembleCvPreds[i] = c;
        }
        results[0][0] = correct / (double)data.numInstances();
        return results;
    }

    @Override
    public double getEnsembleCvAcc() {
        if (this.ensembleCvAcc >= 0.0) {
            return this.ensembleCvAcc;
        }
        try {
            return this.findEnsembleTrainAcc(this.train)[0][0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    @Override
    public double[] getEnsembleCvPreds() {
        if (this.ensembleCvPreds == null) {
            try {
                this.findEnsembleTrainAcc(this.train);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.ensembleCvPreds;
    }

    public double classifyInstance(int test, int numclasses) throws Exception {
        double[] dist = this.distributionForInstance(test, numclasses);
        double maxFreq = dist[0];
        double maxClass = 0.0;
        for (int i = 1; i < dist.length; ++i) {
            if (!(dist[i] > maxFreq)) continue;
            maxFreq = dist[i];
            maxClass = i;
        }
        return maxClass;
    }

    public double[] distributionForInstance(int test, int numclasses) throws Exception {
        double[] classHist = new double[numclasses];
        double sum = 0.0;
        for (BOSSWindow classifier : this.classifiers) {
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.load();
            }
            double classification = classifier.classifyInstance(test);
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.clearClassifier();
            }
            int n = (int)classification;
            classHist[n] = classHist[n] + 1.0;
            sum += 1.0;
        }
        if (sum != 0.0) {
            int i = 0;
            while (i < classHist.length) {
                int n = i++;
                classHist[n] = classHist[n] / sum;
            }
        }
        return classHist;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double[] dist = this.distributionForInstance(instance);
        double maxFreq = dist[0];
        double maxClass = 0.0;
        for (int i = 1; i < dist.length; ++i) {
            if (!(dist[i] > maxFreq)) continue;
            maxFreq = dist[i];
            maxClass = i;
        }
        return maxClass;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] classHist = new double[instance.numClasses()];
        double sum = 0.0;
        for (BOSSWindow classifier : this.classifiers) {
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.load();
            }
            double classification = classifier.classifyInstance(instance);
            if (this.serOption == SerialiseOptions.STORE_LOAD) {
                classifier.clearClassifier();
            }
            int n = (int)classification;
            classHist[n] = classHist[n] + 1.0;
            sum += 1.0;
        }
        if (sum != 0.0) {
            int i = 0;
            while (i < classHist.length) {
                int n = i++;
                classHist[n] = classHist[n] / sum;
            }
        }
        return classHist;
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) throws Exception {
        String dataset = "ItalyPowerDemand";
        Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dataset + "\\" + dataset + "_TRAIN.arff");
        Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dataset + "\\" + dataset + "_TEST.arff");
        BOSS c = new BOSS();
        c.buildClassifier(train);
        double accuracy = ClassifierTools.accuracy(test, c);
        System.out.println("BOSS accuracy on " + dataset + " fold 0 = " + accuracy);
    }

    public static void detailedFold0Test(String dset) {
        System.out.println("BOSS DetailedTest\n");
        try {
            Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
            System.out.println(train.relationName());
            BOSS boss = new BOSS();
            System.out.println("Training starting");
            long start = System.nanoTime();
            boss.buildClassifier(train);
            double trainTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Training done (" + trainTime + "s)");
            System.out.println("Ensemble Size: " + boss.classifiers.size());
            System.out.println("Param sets: ");
            int[][] params = boss.getParametersValues();
            for (int i = 0; i < params.length; ++i) {
                System.out.println(i + ": " + params[i][0] + " " + params[i][1] + " " + params[i][2] + " " + boss.classifiers.get(i).isNorm() + " " + boss.classifiers.get((int)i).accuracy);
            }
            System.out.println("\nTesting starting");
            start = System.nanoTime();
            double acc = ClassifierTools.accuracy(test, boss);
            double testTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Testing done (" + testTime + "s)");
            System.out.println("\nACC: " + acc);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static void resampleTest(String dset, int resamples) throws Exception {
        Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
        Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
        System.out.println(dset);
        BOSS c = new BOSS();
        double[] accs = new double[resamples];
        for (int i = 0; i < resamples; ++i) {
            Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, i);
            c.buildClassifier(data[0]);
            accs[i] = ClassifierTools.accuracy(data[1], c);
            if (i == 0) {
                System.out.print(accs[i]);
                continue;
            }
            System.out.print("," + accs[i]);
        }
        double mean = 0.0;
        for (int i = 0; i < resamples; ++i) {
            mean += accs[i];
        }
        System.out.println("\n\nBOSSEnsemble mean acc over " + resamples + " resamples: " + (mean /= (double)resamples));
    }

    public static class BOSSIndividual
    implements Classifier,
    Serializable {
        protected BitWord[][] SFAwords;
        public ArrayList<Bag> bags;
        protected double[][] breakpoints;
        public static String classifierName = "BOSS";
        protected double inverseSqrtWindowSize;
        protected int windowSize;
        protected int wordLength;
        protected int alphabetSize;
        protected boolean norm;
        protected boolean numerosityReduction = true;
        protected static final long serialVersionUID = 1L;

        public BOSSIndividual(int wordLength, int alphabetSize, int windowSize, boolean normalise) {
            this.wordLength = wordLength;
            this.alphabetSize = alphabetSize;
            this.windowSize = windowSize;
            this.inverseSqrtWindowSize = 1.0 / Math.sqrt(windowSize);
            this.norm = normalise;
        }

        public BOSSIndividual(BOSSIndividual boss, int wordLength) {
            this.wordLength = wordLength;
            this.windowSize = boss.windowSize;
            this.inverseSqrtWindowSize = boss.inverseSqrtWindowSize;
            this.alphabetSize = boss.alphabetSize;
            this.norm = boss.norm;
            this.numerosityReduction = boss.numerosityReduction;
            this.SFAwords = boss.SFAwords;
            this.breakpoints = boss.breakpoints;
            this.bags = new ArrayList(boss.bags.size());
        }

        private BOSSIndividual(BOSSIndividual boss) {
            this.wordLength = boss.wordLength;
            this.windowSize = boss.windowSize;
            this.inverseSqrtWindowSize = boss.inverseSqrtWindowSize;
            this.alphabetSize = boss.alphabetSize;
            this.norm = boss.norm;
            this.numerosityReduction = boss.numerosityReduction;
            this.SFAwords = boss.SFAwords;
            this.breakpoints = boss.breakpoints;
            this.bags = boss.bags;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public int getWordLength() {
            return this.wordLength;
        }

        public int getAlphabetSize() {
            return this.alphabetSize;
        }

        public boolean isNorm() {
            return this.norm;
        }

        public int[] getParameters() {
            return new int[]{this.wordLength, this.alphabetSize, this.windowSize};
        }

        public void clean() {
            this.SFAwords = null;
        }

        public static boolean serialiseFeatureSet(BOSSIndividual boss, String path, String dsetName, int fold) {
            File f = new File(path = path + classifierName + "/" + dsetName + "/fold" + fold + "/");
            if (!f.exists()) {
                f.mkdirs();
            }
            String filename = classifierName + "_" + dsetName + "_" + fold + "_" + boss.windowSize + "_" + boss.wordLength + "_" + boss.alphabetSize + "_" + boss.norm;
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(path + filename));
                out.writeObject(boss);
                out.close();
                return true;
            }
            catch (IOException e) {
                System.out.print("Error serialiszing to " + filename);
                e.printStackTrace();
                return false;
            }
        }

        public static BOSSIndividual loadFeatureSet(String path, String dsetName, int fold, String name, int windowSize, int wordLength, int alphabetSize, boolean norm) throws IOException, ClassNotFoundException {
            path = path + name + "/" + dsetName + "/fold" + fold + "/";
            String filename = name + "_" + dsetName + "_" + fold + "_" + windowSize + "_" + wordLength + "_" + alphabetSize + "_" + norm;
            BOSSIndividual boss = null;
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(path + filename));
                boss = (BOSSIndividual)in.readObject();
                in.close();
                return boss;
            }
            catch (IOException i) {
                throw i;
            }
            catch (ClassNotFoundException c) {
                System.out.println("BOSSWindow class not found");
                throw c;
            }
        }

        protected double[][] slidingWindow(double[] data) {
            int numWindows = data.length - this.windowSize + 1;
            double[][] subSequences = new double[numWindows][this.windowSize];
            for (int windowStart = 0; windowStart < numWindows; ++windowStart) {
                System.arraycopy(data, windowStart, subSequences[windowStart], 0, this.windowSize);
            }
            return subSequences;
        }

        protected double[][] performDFT(double[][] windows) {
            double[][] dfts = new double[windows.length][this.wordLength];
            for (int i = 0; i < windows.length; ++i) {
                dfts[i] = this.DFT(windows[i]);
            }
            return dfts;
        }

        protected double stdDev(double[] series) {
            double sum = 0.0;
            double squareSum = 0.0;
            for (int i = 0; i < this.windowSize; ++i) {
                sum += series[i];
                squareSum += series[i] * series[i];
            }
            double mean = sum / (double)series.length;
            double variance = squareSum / (double)series.length - mean * mean;
            return variance > 0.0 ? Math.sqrt(variance) : 1.0;
        }

        protected double[] DFT(double[] series) {
            int n = series.length;
            int outputLength = this.wordLength / 2;
            int start = this.norm ? 1 : 0;
            double normalisingFactor = this.inverseSqrtWindowSize / this.stdDev(series);
            double[] dft = new double[outputLength * 2];
            for (int k = start; k < start + outputLength; ++k) {
                float sumreal = 0.0f;
                float sumimag = 0.0f;
                for (int t = 0; t < n; ++t) {
                    sumreal = (float)((double)sumreal + series[t] * Math.cos(Math.PI * 2 * (double)t * (double)k / (double)n));
                    sumimag = (float)((double)sumimag + -series[t] * Math.sin(Math.PI * 2 * (double)t * (double)k / (double)n));
                }
                dft[(k - start) * 2] = (double)sumreal * normalisingFactor;
                dft[(k - start) * 2 + 1] = (double)sumimag * normalisingFactor;
            }
            return dft;
        }

        private double[] DFTunnormed(double[] series) {
            int n = series.length;
            int outputLength = this.wordLength / 2;
            int start = this.norm ? 1 : 0;
            double[] dft = new double[outputLength * 2];
            double twoPi = Math.PI * 2 / (double)n;
            for (int k = start; k < start + outputLength; ++k) {
                float sumreal = 0.0f;
                float sumimag = 0.0f;
                for (int t = 0; t < n; ++t) {
                    sumreal = (float)((double)sumreal + series[t] * Math.cos(twoPi * (double)t * (double)k));
                    sumimag = (float)((double)sumimag + -series[t] * Math.sin(twoPi * (double)t * (double)k));
                }
                dft[(k - start) * 2] = sumreal;
                dft[(k - start) * 2 + 1] = sumimag;
            }
            return dft;
        }

        private double[] normalizeDFT(double[] dft, double std) {
            double normalisingFactor = (std > 0.0 ? 1.0 / std : 1.0) * this.inverseSqrtWindowSize;
            int i = 0;
            while (i < dft.length) {
                int n = i++;
                dft[n] = dft[n] * normalisingFactor;
            }
            return dft;
        }

        private double[][] performMFT(double[] series) {
            int startOffset = this.norm ? 2 : 0;
            int l = this.wordLength;
            l += l % 2;
            double[] phis = new double[l];
            for (int u = 0; u < phis.length; u += 2) {
                double uHalve = -(u + startOffset) / 2;
                phis[u] = BOSSIndividual.realephi(uHalve, this.windowSize);
                phis[u + 1] = BOSSIndividual.complexephi(uHalve, this.windowSize);
            }
            int end = Math.max(1, series.length - this.windowSize + 1);
            double[] means = new double[end];
            double[] stds = new double[end];
            this.calcIncrementalMeanStddev(this.windowSize, series, means, stds);
            double[][] transformed = new double[end][];
            double[] mftData = null;
            for (int t = 0; t < end; ++t) {
                if (t > 0) {
                    for (int k = 0; k < l; k += 2) {
                        double real1 = mftData[k] + series[t + this.windowSize - 1] - series[t - 1];
                        double imag1 = mftData[k + 1];
                        double real = BOSSIndividual.complexMulReal(real1, imag1, phis[k], phis[k + 1]);
                        double imag = BOSSIndividual.complexMulImag(real1, imag1, phis[k], phis[k + 1]);
                        mftData[k] = real;
                        mftData[k + 1] = imag;
                    }
                } else {
                    mftData = Arrays.copyOf(series, this.windowSize);
                    mftData = this.DFTunnormed(mftData);
                }
                transformed[t] = this.normalizeDFT(Arrays.copyOf(mftData, l), stds[t]);
            }
            return transformed;
        }

        private void calcIncrementalMeanStddev(int windowLength, double[] series, double[] means, double[] stds) {
            double sum = 0.0;
            double squareSum = 0.0;
            double rWindowLength = 1.0 / (double)windowLength;
            double[] tsData = series;
            for (int ww = 0; ww < windowLength; ++ww) {
                sum += tsData[ww];
                squareSum += tsData[ww] * tsData[ww];
            }
            means[0] = sum * rWindowLength;
            double buf = squareSum * rWindowLength - means[0] * means[0];
            stds[0] = buf > 0.0 ? Math.sqrt(buf) : 0.0;
            int end = tsData.length - windowLength + 1;
            for (int w = 1; w < end; ++w) {
                means[w] = (sum += tsData[w + windowLength - 1] - tsData[w - 1]) * rWindowLength;
                buf = (squareSum += tsData[w + windowLength - 1] * tsData[w + windowLength - 1] - tsData[w - 1] * tsData[w - 1]) * rWindowLength - means[w] * means[w];
                stds[w] = buf > 0.0 ? Math.sqrt(buf) : 0.0;
            }
        }

        private static double complexMulReal(double r1, double im1, double r2, double im2) {
            return r1 * r2 - im1 * im2;
        }

        private static double complexMulImag(double r1, double im1, double r2, double im2) {
            return r1 * im2 + r2 * im1;
        }

        private static double realephi(double u, double M) {
            return Math.cos(Math.PI * 2 * u / M);
        }

        private static double complexephi(double u, double M) {
            return -Math.sin(Math.PI * 2 * u / M);
        }

        protected double[][] disjointWindows(double[] data) {
            int amount = (int)Math.ceil((double)data.length / (double)this.windowSize);
            double[][] subSequences = new double[amount][this.windowSize];
            for (int win = 0; win < amount; ++win) {
                int offset = Math.min(win * this.windowSize, data.length - this.windowSize);
                System.arraycopy(data, offset, subSequences[win], 0, this.windowSize);
            }
            return subSequences;
        }

        protected double[][] MCB(Instances data) {
            double[][][] dfts = new double[data.numInstances()][][];
            int sample = 0;
            for (Instance inst : data) {
                dfts[sample++] = this.performDFT(this.disjointWindows(BOSSIndividual.toArrayNoClass(inst)));
            }
            int numInsts = dfts.length;
            int numWindowsPerInst = dfts[0].length;
            int totalNumWindows = numInsts * numWindowsPerInst;
            this.breakpoints = new double[this.wordLength][this.alphabetSize];
            for (int letter = 0; letter < this.wordLength; ++letter) {
                double[] column = new double[totalNumWindows];
                for (int inst = 0; inst < numInsts; ++inst) {
                    for (int window = 0; window < numWindowsPerInst; ++window) {
                        column[inst * numWindowsPerInst + window] = (double)Math.round(dfts[inst][window][letter] * 100.0) / 100.0;
                    }
                }
                Arrays.sort(column);
                double binIndex = 0.0;
                double targetBinDepth = (double)totalNumWindows / (double)this.alphabetSize;
                for (int bp = 0; bp < this.alphabetSize - 1; ++bp) {
                    this.breakpoints[letter][bp] = column[(int)(binIndex += targetBinDepth)];
                }
                this.breakpoints[letter][this.alphabetSize - 1] = Double.MAX_VALUE;
            }
            return this.breakpoints;
        }

        protected Bag createBagSingle(double[][] dfts) {
            Bag bag = new Bag();
            BitWord lastWord = new BitWord();
            for (double[] d : dfts) {
                BitWord word = this.createWord(d);
                if (this.numerosityReduction && word.equals(lastWord)) continue;
                Integer val = (Integer)bag.get(word);
                if (val == null) {
                    val = 0;
                }
                val = val + 1;
                bag.put(word, val);
                lastWord = word;
            }
            return bag;
        }

        protected BitWord createWord(double[] dft) {
            BitWord word = new BitWord(this.wordLength);
            block0: for (int l = 0; l < this.wordLength; ++l) {
                for (int bp = 0; bp < this.alphabetSize; ++bp) {
                    if (!(dft[l] <= this.breakpoints[l][bp])) continue;
                    word.push(bp);
                    continue block0;
                }
            }
            return word;
        }

        protected static double[] toArrayNoClass(Instance inst) {
            int length = inst.numAttributes();
            if (inst.classIndex() >= 0) {
                --length;
            }
            double[] data = new double[length];
            int j = 0;
            for (int i = 0; i < inst.numAttributes(); ++i) {
                if (inst.classIndex() == i) continue;
                data[j++] = inst.value(i);
            }
            return data;
        }

        public Bag BOSSTransform(Instance inst) {
            double[][] mfts = this.performMFT(BOSSIndividual.toArrayNoClass(inst));
            Bag bag = this.createBagSingle(mfts);
            bag.setClassVal(inst.classValue());
            return bag;
        }

        public BOSSIndividual buildShortenedBags(int newWordLength) throws Exception {
            if (newWordLength == this.wordLength) {
                return this;
            }
            if (newWordLength > this.wordLength) {
                throw new Exception("Cannot incrementally INCREASE word length, current:" + this.wordLength + ", requested:" + newWordLength);
            }
            if (newWordLength < 2) {
                throw new Exception("Invalid wordlength requested, current:" + this.wordLength + ", requested:" + newWordLength);
            }
            BOSSIndividual newBoss = new BOSSIndividual(this, newWordLength);
            for (int i = 0; i < this.bags.size(); ++i) {
                Bag newBag = this.createBagFromWords(newWordLength, this.SFAwords[i]);
                newBag.setClassVal(this.bags.get(i).getClassVal());
                newBoss.bags.add(newBag);
            }
            return newBoss;
        }

        protected Bag createBagFromWords(int thisWordLength, BitWord[] words) {
            Bag bag = new Bag();
            BitWord lastWord = new BitWord();
            for (BitWord w : words) {
                BitWord word = new BitWord(w);
                if (this.wordLength != thisWordLength) {
                    word.shorten(16 - thisWordLength);
                }
                if (this.numerosityReduction && word.equals(lastWord)) continue;
                Integer val = (Integer)bag.get(word);
                if (val == null) {
                    val = 0;
                }
                val = val + 1;
                bag.put(word, val);
                lastWord = word;
            }
            return bag;
        }

        protected BitWord[] createSFAwords(Instance inst) throws Exception {
            double[][] dfts = this.performMFT(BOSSIndividual.toArrayNoClass(inst));
            BitWord[] words = new BitWord[dfts.length];
            for (int window = 0; window < dfts.length; ++window) {
                words[window] = this.createWord(dfts[window]);
            }
            return words;
        }

        @Override
        public void buildClassifier(Instances data) throws Exception {
            if (data.classIndex() != data.numAttributes() - 1) {
                throw new Exception("BOSS_BuildClassifier: Class attribute not set as last attribute in dataset");
            }
            this.breakpoints = this.MCB(data);
            this.SFAwords = new BitWord[data.numInstances()][];
            this.bags = new ArrayList(data.numInstances());
            for (int inst = 0; inst < data.numInstances(); ++inst) {
                this.SFAwords[inst] = this.createSFAwords(data.get(inst));
                Bag bag = this.createBagFromWords(this.wordLength, this.SFAwords[inst]);
                bag.setClassVal(data.get(inst).classValue());
                this.bags.add(bag);
            }
        }

        public double BOSSdistance(Bag instA, Bag instB) {
            double dist = 0.0;
            for (Map.Entry entry : instA.entrySet()) {
                Integer valA = (Integer)entry.getValue();
                Integer valB = (Integer)instB.get(entry.getKey());
                if (valB == null) {
                    valB = 0;
                }
                dist += (double)((valA - valB) * (valA - valB));
            }
            return dist;
        }

        public double BOSSdistance(Bag instA, Bag instB, double bestDist) {
            double dist = 0.0;
            for (Map.Entry entry : instA.entrySet()) {
                Integer valA = (Integer)entry.getValue();
                Integer valB = (Integer)instB.get(entry.getKey());
                if (valB == null) {
                    valB = 0;
                }
                if (!((dist += (double)((valA - valB) * (valA - valB))) > bestDist)) continue;
                return Double.MAX_VALUE;
            }
            return dist;
        }

        @Override
        public double classifyInstance(Instance instance) throws Exception {
            Bag testBag = this.BOSSTransform(instance);
            double bestDist = Double.MAX_VALUE;
            double nn = -1.0;
            for (int i = 0; i < this.bags.size(); ++i) {
                double dist = this.BOSSdistance(testBag, this.bags.get(i), bestDist);
                if (!(dist < bestDist)) continue;
                bestDist = dist;
                nn = this.bags.get(i).getClassVal();
            }
            return nn;
        }

        public double classifyInstance(int test) {
            double bestDist = Double.MAX_VALUE;
            double nn = -1.0;
            Bag testBag = this.bags.get(test);
            for (int i = 0; i < this.bags.size(); ++i) {
                double dist;
                if (i == test || !((dist = this.BOSSdistance(testBag, this.bags.get(i), bestDist)) < bestDist)) continue;
                bestDist = dist;
                nn = this.bags.get(i).getClassVal();
            }
            return nn;
        }

        @Override
        public double[] distributionForInstance(Instance instance) throws Exception {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Capabilities getCapabilities() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public static void detailedFold0Test(String dset) {
            System.out.println("BOSSIndividual DetailedTest\n");
            try {
                Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
                Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
                System.out.println(train.relationName());
                int windowSize = 10;
                int alphabetSize = 4;
                int wordLength = 43;
                boolean norm = true;
                BOSSIndividual boss = new BOSSIndividual(windowSize, alphabetSize, wordLength, norm);
                System.out.println(boss.getWordLength() + " " + boss.getAlphabetSize() + " " + boss.getWindowSize() + " " + boss.isNorm());
                System.out.println("Training starting");
                long start = System.nanoTime();
                boss.buildClassifier(train);
                double trainTime = (double)(System.nanoTime() - start) / 1.0E9;
                System.out.println("Training done (" + trainTime + "s)");
                System.out.println("Breakpoints: ");
                for (int i = 0; i < boss.breakpoints.length; ++i) {
                    System.out.print("Letter " + i + ": ");
                    for (int j = 0; j < boss.breakpoints[i].length; ++j) {
                        System.out.print(boss.breakpoints[i][j] + " ");
                    }
                    System.out.println("");
                }
                System.out.println("\nTesting starting");
                start = System.nanoTime();
                double acc = ClassifierTools.accuracy(test, boss);
                double testTime = (double)(System.nanoTime() - start) / 1.0E9;
                System.out.println("Testing done (" + testTime + "s)");
                System.out.println("\nACC: " + acc);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }

        public static class Bag
        extends HashMap<BitWord, Integer> {
            double classVal;

            public Bag() {
            }

            public Bag(int classValue) {
                this.classVal = classValue;
            }

            public double getClassVal() {
                return this.classVal;
            }

            public void setClassVal(double classVal) {
                this.classVal = classVal;
            }
        }
    }

    public static class BOSSWindow
    implements Comparable<BOSSWindow>,
    Serializable {
        private BOSSIndividual classifier;
        public double accuracy;
        public String filename;
        private static final long serialVersionUID = 2L;

        public BOSSWindow(String filename) {
            this.filename = filename;
        }

        public BOSSWindow(BOSSIndividual classifer, double accuracy, String dataset) {
            this.classifier = classifer;
            this.accuracy = accuracy;
            this.buildFileName(dataset);
        }

        public double classifyInstance(Instance inst) throws Exception {
            return this.classifier.classifyInstance(inst);
        }

        public double classifyInstance(int test) throws Exception {
            return this.classifier.classifyInstance(test);
        }

        private void buildFileName(String dataset) {
            this.filename = serFileLoc + dataset + "_" + this.classifier.windowSize + "_" + this.classifier.wordLength + "_" + this.classifier.alphabetSize + "_" + this.classifier.norm + ".ser";
        }

        public boolean storeAndClearClassifier() {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.filename));
                out.writeObject(this);
                out.close();
                this.clearClassifier();
                return true;
            }
            catch (IOException e) {
                System.out.print("Error serialising to " + this.filename);
                e.printStackTrace();
                return false;
            }
        }

        public boolean store() {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.filename));
                out.writeObject(this);
                out.close();
                return true;
            }
            catch (IOException e) {
                System.out.print("Error serialiszing to " + this.filename);
                e.printStackTrace();
                return false;
            }
        }

        public void clearClassifier() {
            this.classifier = null;
        }

        public boolean load() {
            BOSSWindow bw = null;
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.filename));
                bw = (BOSSWindow)in.readObject();
                in.close();
                this.accuracy = bw.accuracy;
                this.classifier = bw.classifier;
                return true;
            }
            catch (IOException i) {
                System.out.print("Error deserialiszing from " + this.filename);
                i.printStackTrace();
                return false;
            }
            catch (ClassNotFoundException c) {
                System.out.println("BOSSWindow class not found");
                c.printStackTrace();
                return false;
            }
        }

        public boolean deleteSerFile() {
            try {
                File f = new File(this.filename);
                return f.delete();
            }
            catch (SecurityException s) {
                System.out.println("Unable to delete, access denied: " + this.filename);
                s.printStackTrace();
                return false;
            }
        }

        public int[] getParameters() {
            return this.classifier.getParameters();
        }

        public int getWindowSize() {
            return this.classifier.getWindowSize();
        }

        public int getWordLength() {
            return this.classifier.getWordLength();
        }

        public int getAlphabetSize() {
            return this.classifier.getAlphabetSize();
        }

        public boolean isNorm() {
            return this.classifier.isNorm();
        }

        @Override
        public int compareTo(BOSSWindow other) {
            if (this.accuracy > other.accuracy) {
                return 1;
            }
            if (this.accuracy == other.accuracy) {
                return 0;
            }
            return -1;
        }
    }

    public static enum SerialiseOptions {
        NONE,
        STORE,
        STORE_LOAD;

    }
}

