/*
 * Decompiled with CFR 0.152.
 */
package statistics.tests;

import java.util.Arrays;
import statistics.distributions.NormalDistribution;
import statistics.distributions.StudentDistribution;
import statistics.tests.DataPoint;
import statistics.tests.OneSampleTests;
import statistics.tests.TestResults;
import statistics.tests.Tests;

public class TwoSampleTests
extends Tests {
    public String performTests(double[] a, double[] b) {
        int i;
        DataPoint[][] d = new DataPoint[][]{new DataPoint[a.length], new DataPoint[b.length]};
        for (i = 0; i < a.length; ++i) {
            d[0][i] = new DataPoint(a[i], 0, i);
        }
        for (i = 0; i < b.length; ++i) {
            d[1][i] = new DataPoint(b[i], 1, i);
        }
        TestResults t_test = new TestResults("T_Test");
        TwoSampleTests.studentT_Test(t_test, d, 0);
        t_test.findPValue();
        String str = "T_Test," + t_test.testStat + "," + t_test.pValue + "\n";
        TestResults mw = new TestResults("Mann_Whitney");
        TwoSampleTests.mannWhitney(mw, d);
        mw.findPValue();
        str = str + "Mann_Whitney," + mw.testStat + "," + mw.pValue + "\n";
        TestResults rrs = new TestResults("robustRankSum");
        TwoSampleTests.robustRankSum(rrs, d);
        rrs.findPValue();
        str = str + "robustRankSum," + rrs.testStat + "," + rrs.pValue + "\n";
        return str;
    }

    public static TestResults performTwoSampleTest(double[] a, double[] b, int testType) {
        int i;
        DataPoint[][] d = new DataPoint[][]{new DataPoint[a.length], new DataPoint[b.length]};
        for (i = 0; i < a.length; ++i) {
            d[0][i] = new DataPoint(a[i], 0, i);
        }
        for (i = 0; i < b.length; ++i) {
            d[1][i] = new DataPoint(b[i], 1, i);
        }
        TestResults testR = new TestResults("T_Test");
        switch (testType) {
            case 0: {
                TwoSampleTests.studentT_Test(testR, d, 0);
                break;
            }
            case 1: {
                TwoSampleTests.mannWhitney(testR, d);
                break;
            }
            case 2: {
                TwoSampleTests.robustRankSum(testR, d);
                break;
            }
            default: {
                System.out.println(" Test Not implemented: exit");
                System.exit(0);
            }
        }
        return testR;
    }

    public static double performTest(double[] a, double[] b, int testType, boolean returnPVal) {
        TestResults r = TwoSampleTests.performTwoSampleTest(a, b, testType);
        if (returnPVal) {
            r.findPValue();
            return r.pValue;
        }
        return r.testStat;
    }

    public static double studentT_PValue(double[] a, double[] b) {
        int i;
        DataPoint[][] d = new DataPoint[][]{new DataPoint[a.length], new DataPoint[b.length]};
        for (i = 0; i < a.length; ++i) {
            d[0][i] = new DataPoint(a[i], 0, i);
        }
        for (i = 0; i < b.length; ++i) {
            d[1][i] = new DataPoint(b[i], 1, i);
        }
        TestResults t_test = new TestResults("T_Test");
        TwoSampleTests.studentT_Test(t_test, d, 0);
        t_test.findPValue();
        return t_test.pValue;
    }

    public static double mw_PValue(double[] a, double[] b) {
        int i;
        DataPoint[][] d = new DataPoint[][]{new DataPoint[a.length], new DataPoint[b.length]};
        for (i = 0; i < a.length; ++i) {
            d[0][i] = new DataPoint(a[i], 0, i);
        }
        for (i = 0; i < b.length; ++i) {
            d[1][i] = new DataPoint(b[i], 1, i);
        }
        TestResults mw = new TestResults("Mann_Whitney");
        TwoSampleTests.mannWhitney(mw, d);
        mw.findPValue();
        return mw.pValue;
    }

    public static double rrs_PValue(double[] a, double[] b) {
        int i;
        DataPoint[][] d = new DataPoint[][]{new DataPoint[a.length], new DataPoint[b.length]};
        for (i = 0; i < a.length; ++i) {
            d[0][i] = new DataPoint(a[i], 0, i);
        }
        for (i = 0; i < b.length; ++i) {
            d[1][i] = new DataPoint(b[i], 1, i);
        }
        TestResults rrs = new TestResults("robustRankSum");
        TwoSampleTests.robustRankSum(rrs, d);
        rrs.findPValue();
        return rrs.pValue;
    }

    public static double studentT_TestStat(double[] a, double[] b) {
        int i;
        DataPoint[][] d = new DataPoint[][]{new DataPoint[a.length], new DataPoint[b.length]};
        for (i = 0; i < a.length; ++i) {
            d[0][i] = new DataPoint(a[i], 0, i);
        }
        for (i = 0; i < b.length; ++i) {
            d[1][i] = new DataPoint(b[i], 1, i);
        }
        TestResults t_test = new TestResults("T_Test");
        TwoSampleTests.studentT_Test(t_test, d, 0);
        return t_test.testStat;
    }

    public static double mw_TestStat(double[] a, double[] b) {
        int i;
        DataPoint[][] d = new DataPoint[][]{new DataPoint[a.length], new DataPoint[b.length]};
        for (i = 0; i < a.length; ++i) {
            d[0][i] = new DataPoint(a[i], 0, i);
        }
        for (i = 0; i < b.length; ++i) {
            d[1][i] = new DataPoint(b[i], 1, i);
        }
        TestResults mw = new TestResults("Mann_Whitney");
        TwoSampleTests.mannWhitney(mw, d);
        return mw.testStat;
    }

    public static double rrs_TestStat(double[] a, double[] b) {
        int i;
        DataPoint[][] d = new DataPoint[][]{new DataPoint[a.length], new DataPoint[b.length]};
        for (i = 0; i < a.length; ++i) {
            d[0][i] = new DataPoint(a[i], 0, i);
        }
        for (i = 0; i < b.length; ++i) {
            d[1][i] = new DataPoint(b[i], 1, i);
        }
        TestResults rrs = new TestResults("robustRankSum");
        TwoSampleTests.robustRankSum(rrs, d);
        return rrs.testStat;
    }

    public static void robustRankSum(TestResults t, DataPoint[][] d) {
        int i;
        int i2;
        int i3;
        Object[] mergedD = new DataPoint[d[0].length + d[1].length];
        for (i3 = 0; i3 < d[0].length; ++i3) {
            mergedD[i3] = d[0][i3];
        }
        for (i3 = 0; i3 < d[1].length; ++i3) {
            mergedD[d[0].length + i3] = d[1][i3];
        }
        Arrays.sort(mergedD);
        int[] p_YX = new int[d[0].length];
        int[] p_XY = new int[d[1].length];
        int m = p_YX.length;
        int n = p_XY.length;
        boolean j = false;
        int countA = 0;
        int countB = 0;
        double u_YX = 0.0;
        double u_XY = 0.0;
        for (i2 = 0; i2 < mergedD.length; ++i2) {
            if (((DataPoint)mergedD[i2]).sampleNumber() == 0) {
                p_YX[countA] = countB;
                u_YX += (double)p_YX[countA];
                ++countA;
                continue;
            }
            p_XY[countB] = countA;
            u_XY += (double)p_XY[countB];
            ++countB;
        }
        System.out.println(" Series A positions = ");
        for (i2 = 0; i2 < p_XY.length; ++i2) {
            System.out.print(p_XY[i2] + ",");
        }
        System.out.println(" Series B positions = ");
        for (i2 = 0; i2 < p_YX.length; ++i2) {
            System.out.print(p_YX[i2] + ",");
        }
        System.out.println(" u1 = " + u_XY + "  u2 = " + u_YX);
        System.out.println(" m*n = " + p_XY.length * p_YX.length + "  u1+u2 = " + (u_XY + u_YX));
        System.out.println(" U_A statistic = " + u_YX / (double)m);
        System.out.println(" U_B statistic = " + u_XY / (double)n);
        u_YX /= (double)m;
        u_XY /= (double)n;
        double Va = 0.0;
        double Vb = 0.0;
        for (i = 0; i < m; ++i) {
            Va += ((double)p_YX[i] - u_YX) * ((double)p_YX[i] - u_YX);
        }
        for (i = 0; i < n; ++i) {
            Va += ((double)p_XY[i] - u_XY) * ((double)p_XY[i] - u_XY);
        }
        double U = ((double)m * u_YX - (double)n * u_XY) / (2.0 * Math.sqrt(Va + Vb + u_YX * u_XY));
        t.dist = new NormalDistribution(0.0, 1.0);
        t.testStat = U;
        System.out.println(" U New = " + t.testStat);
    }

    public static void wilcoxonRankSum(TestResults t, DataPoint[][] d) {
        double U = TwoSampleTests.findU(d);
        t.testStat = U + 0.5 * (double)d[0].length * (double)(d[0].length + 1);
        System.out.println(" R statistic = " + t.testStat);
    }

    public static void mannWhitney(TestResults t, DataPoint[][] d) {
        t.testStat = TwoSampleTests.findU(d);
        double nA = d[0].length;
        double nB = d[1].length;
        double nullMean = 0.5 * nA * nB;
        double nullStDev = Math.sqrt(nA * nB * (nA + nB + 1.0) / 12.0);
        t.dist = new NormalDistribution(nullMean, nullStDev);
        System.out.println(" Null Mean =" + nullMean + " Null SD = " + nullStDev);
    }

    public static void studentT_Test(TestResults t, DataPoint[][] d, int type) {
        switch (type) {
            case 0: {
                TwoSampleTests.unequalVarianceStudentT_Test(t, d);
                break;
            }
            case 1: {
                TwoSampleTests.unequalVarianceStudentT_Test(t, d);
                break;
            }
        }
    }

    public static void unequalVarianceStudentT_Test(TestResults t, DataPoint[][] d) {
        double tStat;
        int i;
        double m1 = 0.0;
        double m2 = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        for (i = 0; i < d[0].length; ++i) {
            m1 += d[0][i].d;
        }
        for (i = 0; i < d[1].length; ++i) {
            m2 += d[1][i].d;
        }
        m1 /= (double)d[0].length;
        m2 /= (double)d[1].length;
        for (i = 0; i < d[0].length; ++i) {
            s1 += (d[0][i].d - m1) * (d[0][i].d - m1);
        }
        for (i = 0; i < d[1].length; ++i) {
            s2 += (d[1][i].d - m2) * (d[1][i].d - m2);
        }
        t.testStat = tStat = (m1 - m2) / Math.sqrt((s1 /= (double)(d[0].length - 1)) / (double)d[0].length + (s2 /= (double)(d[1].length - 1)) / (double)d[1].length);
        int n1 = d[0].length;
        int n2 = d[1].length;
        t.df1 = (int)Math.ceil((s1 / (double)n1 + s2 / (double)n2) * (s1 / (double)n1 + s2 / (double)n2) / (s1 / (double)n1 * (s1 / (double)n1) / (double)(n1 - 1) + s2 / (double)n2 * (s2 / (double)n2) / (double)(n2 - 1)));
        t.dist = new StudentDistribution(t.df1);
    }

    private static DataPoint[] mergeData(DataPoint[][] d) {
        int i;
        DataPoint[] md = new DataPoint[d[0].length + d[1].length];
        for (i = 0; i < d[0].length; ++i) {
            md[i] = d[0][i];
        }
        for (i = 0; i < d[1].length; ++i) {
            md[d[0].length + i] = d[1][i];
        }
        return md;
    }

    private static int findU(DataPoint[][] d, int a, int b) {
        int i;
        Object[] mergedD = new DataPoint[d[a].length + d[b].length];
        for (i = 0; i < d[a].length; ++i) {
            mergedD[i] = d[a][i];
        }
        for (i = 0; i < d[b].length; ++i) {
            mergedD[d[a].length + i] = d[b][i];
        }
        Arrays.sort(mergedD);
        int j = 0;
        int count = 0;
        int U = 0;
        for (int i2 = 0; i2 < mergedD.length && j < d[a].length; ++i2) {
            if (((DataPoint)mergedD[i2]).sampleNumber() == a) {
                U += count;
                ++j;
                continue;
            }
            ++count;
        }
        return U;
    }

    private static int findU(DataPoint[][] d) {
        if (d.length != 2) {
            System.out.println("Error, cannot use this for k!=2");
            System.exit(0);
        }
        return TwoSampleTests.findU(d, 0, 1);
    }

    public static void testTwoSamples() {
        int i;
        int n_a = 8;
        int n_b = 12;
        DataPoint[][] d = new DataPoint[][]{new DataPoint[n_a], new DataPoint[n_b]};
        double[] d1 = new double[]{3.0, 7.0, 15.0, 10.0, 4.0, 6.0, 4.0, 7.0};
        for (int i2 = 0; i2 < n_a; ++i2) {
            d[0][i2] = new DataPoint(d1[i2], 0, i2);
        }
        double[] d2 = new double[]{19.0, 11.0, 36.0, 8.0, 25.0, 23.0, 38.0, 14.0, 17.0, 41.0, 25.0, 21.0};
        TwoSampleTests ts = new TwoSampleTests();
        String str = ts.performTests(d1, d2);
        System.out.println(str + "\n");
        for (int i3 = 0; i3 < n_b; ++i3) {
            d[1][i3] = new DataPoint(d2[i3], 1, i3);
        }
        TestResults t = new TestResults("Mann Whittley");
        TwoSampleTests.studentT_Test(t, d, 0);
        TwoSampleTests.mannWhitney(t, d);
        TwoSampleTests.robustRankSum(t, d);
        int m = 7;
        int n = 8;
        double[] d3 = new double[]{5.025, 6.7, 6.725, 6.75, 7.05, 7.25, 8.375};
        double[] d4 = new double[]{4.875, 5.125, 5.225, 5.425, 5.55, 5.75, 5.925, 6.125};
        d = new DataPoint[][]{new DataPoint[m], new DataPoint[n]};
        for (i = 0; i < m; ++i) {
            d[0][i] = new DataPoint(d3[i], 0, i);
        }
        for (i = 0; i < n; ++i) {
            d[1][i] = new DataPoint(d4[i], 1, i);
        }
        TwoSampleTests.studentT_Test(t, d, 0);
        TwoSampleTests.mannWhitney(t, d);
        TwoSampleTests.robustRankSum(t, d);
        str = ts.performTests(d3, d4);
        System.out.println(str + "\n");
        System.exit(0);
    }

    public static void wilcoxonMatchedPairs(TestResults t, DataPoint[][] d) {
        if (d.length != 2) {
            System.out.println("Error, cannot use this for k!=2");
            System.exit(0);
        }
        if (d[0].length != d[1].length) {
            System.out.println("Error, cannot use this for unequal samples, they should be matched");
            System.exit(0);
        }
        DataPoint[] ranked = new DataPoint[d[0].length];
        for (int i = 0; i < ranked.length; ++i) {
            System.out.println(" Difference =" + (d[0][i].d - d[1][i].d));
            ranked[i] = new DataPoint(d[0][i].d - d[1][i].d, 0, d[0][i].position);
        }
        Tests.rank(ranked);
        OneSampleTests.wilcoxonSignRank(t, ranked);
    }

    public static void main(String[] args) {
        TwoSampleTests.testTwoSamples();
        System.exit(0);
        String fileName = "C:\\Users\\ajb\\Dropbox\\Results\\DebugFiles\\TwoSampleTest.csv";
        TestResults T = new TestResults("SSS");
        T.h0 = 0.0;
        T.level = 0.05;
        T.type = 0;
        TwoSampleTests.loadData(fileName);
        TwoSampleTests.wilcoxonMatchedPairs(T, dataByLevel);
        System.out.println(T);
    }
}

