/*
 * Decompiled with CFR 0.152.
 */
package statistics.tests;

import fileIO.OutFile;
import java.io.FileReader;
import java.util.Arrays;
import statistics.distributions.FisherDistribution;
import statistics.distributions.NormalDistribution;
import transformations.ArrayPair;
import transformations.LinearModel;
import transformations.MatrixSort;
import weka.classifiers.functions.LinearRegression;
import weka.core.Instance;
import weka.core.Instances;

public class ResidualTests {
    public static double goldfeldQuandt(double[][] X, double[] Y, int pos) {
        Object[] ms = new MatrixSort[Y.length];
        for (int i = 0; i < Y.length; ++i) {
            double[] x = new double[X.length];
            for (int j = 0; j < x.length; ++j) {
                x[j] = X[j][i];
            }
            ms[i] = new MatrixSort(x, Y[i], pos);
        }
        Arrays.sort(ms);
        int p = X.length - 1;
        int n = Y.length;
        int n2 = n / 3;
        int n1 = (n - n2) / 2;
        int n3 = n - n1 - n2;
        System.out.println("n1 = " + n1 + " n2 = " + n2 + " n3 = " + n3);
        double[][] newX = new double[X.length][n1];
        double[] newY = new double[n1];
        for (int i = 0; i < n1; ++i) {
            newY[i] = Y[i];
            for (int j = 0; j < X.length; ++j) {
                newX[j][i] = ((MatrixSort)ms[i]).x[j];
            }
        }
        LinearModel lm = new LinearModel(newX, newY);
        lm.fitModel();
        lm.findStats();
        double s1 = lm.getSSE();
        newX = new double[X.length][n3];
        newY = new double[n3];
        for (int i = n1 + n2; i < n; ++i) {
            newY[i - n1 - n2] = Y[i];
            for (int j = 0; j < X.length; ++j) {
                newX[j][i - n1 - n2] = ((MatrixSort)ms[i]).x[j];
            }
        }
        lm = new LinearModel(newX, newY);
        lm.fitModel();
        lm.findStats();
        double s3 = lm.getSSE();
        double q = (double)(n3 - p - 1) * s1 / ((double)(n1 - p - 1) * s3);
        System.out.println(" s1 = " + s1 + "  s3 = " + s3 + "  q = " + q + " s3/s1" + s3 / s1);
        FisherDistribution f = s1 > s3 ? new FisherDistribution(n3 - p - 1, n1 - p - 1) : new FisherDistribution(n3 - p - 1, n1 - p - 1);
        double prob = f.getCDF(q);
        double prob2 = f.getDensity(q);
        System.out.println(" prob = " + prob + " density = " + prob2);
        return q;
    }

    public static double runsTest(double[] pred, double[] residuals) {
        int i;
        double runsCount = 1.0;
        double p = 0.0;
        boolean positive = false;
        Object[] ap = new ArrayPair[pred.length];
        for (i = 0; i < pred.length; ++i) {
            ap[i] = new ArrayPair();
            ((ArrayPair)ap[i]).predicted = pred[i];
            ((ArrayPair)ap[i]).residual = residuals[i];
        }
        Arrays.sort(ap);
        if (((ArrayPair)ap[0]).residual > 0.0) {
            positive = true;
            p = 1.0;
        }
        for (i = 1; i < ap.length; ++i) {
            boolean currentPositive;
            if (((ArrayPair)ap[i]).residual > 0.0) {
                currentPositive = true;
                p += 1.0;
            } else {
                currentPositive = false;
            }
            if (currentPositive != positive) {
                runsCount += 1.0;
            }
            positive = currentPositive;
        }
        double n = ap.length;
        double m = 2.0 * p * (n - p) / (n - 1.0);
        double v = 2.0 * p * (n - p) * (2.0 * p * (n - p) - n) / (n * n * (n - 1.0));
        System.out.println("m = " + m + " v = " + v);
        double res = (runsCount - m) / Math.sqrt(v);
        return res;
    }

    public static double kolmogorovSmirnoff(double[] residuals) {
        return ResidualTests.kolmogorovSmirnoff(residuals, 1.0);
    }

    public static double kolmogorovSmirnoff(double[] residuals, double var) {
        int i;
        int n = residuals.length;
        double[] expected = new double[n];
        double[] observed = new double[n + 1];
        double[] residCopy = new double[residuals.length];
        System.arraycopy(residuals, 0, residCopy, 0, residuals.length);
        observed[n] = 1.0;
        NormalDistribution norm = new NormalDistribution(0.0, var);
        Arrays.sort(residCopy);
        for (i = 0; i < n; ++i) {
            expected[i] = (double)(i + 1) / (double)n;
        }
        for (i = 0; i < n; ++i) {
            observed[i] = norm.getCDF(residCopy[i]);
        }
        double max = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            if (!(Math.abs(expected[i2] - observed[i2 + 1]) > max)) continue;
            max = Math.abs(expected[i2] - observed[i2 + 1]);
        }
        return max;
    }

    public static double anscombeProcedure(double[] actual, double[] predicted) {
        return ResidualTests.testHeteroscadisity(actual, predicted);
    }

    public static double testHeteroscadisity(double[] actual, double[] predicted) {
        double[] absRes = new double[predicted.length];
        double meanPred = 0.0;
        double meanAbs = 0.0;
        for (int i = 0; i < predicted.length; ++i) {
            absRes[i] = Math.abs(actual[i] - predicted[i]);
            meanAbs += absRes[i];
            meanPred += predicted[i];
        }
        meanAbs /= (double)predicted.length;
        meanPred /= (double)predicted.length;
        double corr = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < predicted.length; ++i) {
            corr += (absRes[i] - meanAbs) * (predicted[i] - meanPred);
            x += (absRes[i] - meanAbs) * (absRes[i] - meanAbs);
            y += (predicted[i] - meanPred) * (predicted[i] - meanPred);
        }
        System.out.println(" Correlation = " + (corr /= Math.sqrt(x * y)));
        return corr;
    }

    public static void main(String[] args) {
        int s = 100;
        double[] data = new double[s];
        NormalDistribution n = new NormalDistribution(0.0, 3.0);
        for (int i = 0; i < s; ++i) {
            data[i] = n.simulate();
        }
        double x = ResidualTests.kolmogorovSmirnoff(data, 1.0);
        System.out.println(" KS stat = " + x);
    }

    public static void testHetero() {
        LinearRegression lg = new LinearRegression();
        try {
            FileReader r = new FileReader("C:/Research/Data/Gavin Competition/Weka Files/Temp Train.arff");
            Instances data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
            lg.buildClassifier(data);
            double[] predictions = new double[data.numInstances()];
            double[] actual = data.attributeToDoubleArray(data.numAttributes() - 1);
            for (int i = 0; i < predictions.length; ++i) {
                Instance inst = data.instance(i);
                predictions[i] = lg.classifyInstance(inst);
            }
            OutFile of = new OutFile("C:/Research/Data/Gavin Competition/Weka Files/CorrelationTest.csv");
            System.out.println(" t stat for homogeneity =" + ResidualTests.testHeteroscadisity(actual, predictions));
            for (int i = 0; i < predictions.length; ++i) {
                of.writeLine(actual[i] + "," + predictions[i]);
            }
        }
        catch (Exception e) {
            System.out.println(" Error in REsidual Test " + e);
        }
    }
}

