/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import statistics.distributions.Distribution;
import statistics.distributions.NormalDistribution;
import statistics.simulators.Model;

public class PolynomialModel
extends Model {
    double[] coefficients;
    double[] powers;
    static double defaultMin = -4.0;
    static double defaultMax = 4.0;

    private PolynomialModel() {
    }

    private PolynomialModel(double[] c, double[] p) {
        this.coefficients = c;
        this.powers = p;
        this.t = 0.0;
    }

    private PolynomialModel(double[] c, double[] p, Distribution e) {
        this.coefficients = c;
        this.powers = p;
        this.error = e;
        this.t = 0.0;
    }

    @Override
    public void setParameters(double[] p) {
        if (p.length % 2 != 0) {
            throw new UnsupportedOperationException("Error, the Polynomial model input must be of even length, first half the powers, second half coefficients,");
        }
        this.coefficients = new double[p.length / 2];
        this.powers = new double[p.length / 2];
        System.arraycopy(p, 0, this.powers, 0, p.length / 2);
        System.arraycopy(p, p.length / 2, this.coefficients, 0, p.length / 2);
        this.error = new NormalDistribution(0.0, 1.0);
        this.t = 0.0;
    }

    @Override
    public double generate(double x) {
        double p = this.generateDeterministic(x);
        this.t = x;
        return p += this.error.simulate();
    }

    @Override
    public double generate() {
        double p = this.generateDeterministic(this.t);
        this.t += 1.0;
        return p += this.error.simulate();
    }

    public double generateDeterministic(double x) {
        double p = 0.0;
        if (x == 0.0) {
            return 0.0;
        }
        for (int i = 0; i < this.powers.length; ++i) {
            p += this.coefficients[i] * Math.pow(x, this.powers[i]);
        }
        return p;
    }

    public void setTime(int t) {
        this.t = t;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public double[] getPowers() {
        return this.powers;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.powers.length; ++i) {
            str = str + this.coefficients[i] + "*x^" + this.powers[i] + "\t+\t";
        }
        str = str + this.error;
        return str;
    }

    public static PolynomialModel generateRandomModel(int r) {
        return PolynomialModel.generateRandomModel(r, defaultMin, defaultMax, defaultMin, defaultMax);
    }

    public static PolynomialModel generateRandomModel(int r, double min, double max) {
        return PolynomialModel.generateRandomModel(r, min, max, min, max);
    }

    public static PolynomialModel generateRandomModel(int r, double minC, double maxC, double minP, double maxP) {
        double[] coeffs = new double[r];
        double[] powers = new double[r];
        for (int i = 0; i < r; ++i) {
        }
        return new PolynomialModel(coeffs, powers, new NormalDistribution(0.0, 1.0));
    }

    public static void main(String[] args) {
        System.out.println(" Test Harness not implemented yet");
    }
}

