/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import java.util.Random;
import statistics.distributions.Distribution;
import statistics.distributions.NormalDistribution;

public abstract class Model {
    protected double t = 0.0;
    Distribution error;
    public static double defaultSigma = 1.0;
    static int seed = 1;
    static int count = 1;
    double variance = defaultSigma;
    public static Random rand = new Random(seed);

    public static void setDefaultSigma(double x) {
        defaultSigma = x;
    }

    public Model() {
        this.error = new NormalDistribution(0.0, this.variance);
        if (seed >= 0) {
            this.error.setRandomSeed(count * (seed + 1));
            ++count;
        }
    }

    public static void setGlobalRandomSeed(int s) {
        seed = s;
        rand = new Random(seed);
        count = 1;
    }

    public static int getRandomSeed() {
        return seed;
    }

    public void setVariance(double x) {
        this.variance = x;
        this.error = new NormalDistribution(0.0, this.variance);
    }

    public double getVariance() {
        return this.variance;
    }

    double generate(double x) {
        return this.error.simulate();
    }

    double generate() {
        return this.error.simulate();
    }

    public void reset() {
        this.t = 0.0;
    }

    public void setError(Distribution d) {
        this.error = d;
    }

    public double[] generateSeries(int n) {
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.generate();
        }
        return d;
    }

    public String getModelType() {
        return "RandomNoise";
    }

    public String getAttributeName() {
        return "t";
    }

    public String getHeader() {
        String header = "%" + this.getModelType();
        header = header + "%Error=" + this.error.getClass() + " Sigma = " + this.error.getVariance() + "\n";
        return header;
    }

    public abstract void setParameters(double[] var1);
}

