/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import statistics.simulators.DictionaryModel;
import statistics.simulators.Model;

public class ElasticModel
extends Model {
    private static double warpPercent = 0.1;
    private int seriesLength = 200;
    private static double base = -1.0;
    private static double amplitude = 2.0;
    private DictionaryModel.Shape baseShape;
    int start = 0;
    int end = this.seriesLength;

    public ElasticModel() {
        this.baseShape = new DictionaryModel.Shape();
        DictionaryModel.Shape.DEFAULTAMP = amplitude;
        DictionaryModel.Shape.DEFAULTBASE = base;
    }

    public void setSeriesLength(int n) {
        this.seriesLength = n;
    }

    public void setBaseShapeType(DictionaryModel.ShapeType st) {
        this.baseShape.setType(st);
    }

    public static void setWarpPercent(double b) {
        warpPercent = b;
    }

    public static void setBaseAndAmp(double b, double a) {
        amplitude = a;
        base = b;
        DictionaryModel.Shape.DEFAULTAMP = amplitude;
        DictionaryModel.Shape.DEFAULTBASE = base;
    }

    @Override
    public double generate() {
        double value = this.error.simulate();
        if (this.t >= (double)this.start && this.t < (double)this.end) {
            value += this.baseShape.generateWithinShapelet((int)(this.t - (double)this.start));
        }
        this.t += 1.0;
        return value;
    }

    @Override
    public double[] generateSeries(int n) {
        this.start = Model.rand.nextInt((int)(warpPercent * (double)this.seriesLength));
        this.end = this.seriesLength - Model.rand.nextInt((int)(warpPercent * (double)this.seriesLength));
        this.baseShape.setLength(this.end - this.start);
        double[] series = new double[n];
        this.t = 0.0;
        for (int i = 0; i < n; ++i) {
            series[i] = this.generate();
        }
        return series;
    }

    @Override
    public void setParameters(double[] p) {
        warpPercent = p[0];
    }

    public void randomiseShape(DictionaryModel.ShapeType m) {
        this.baseShape.randomiseShape();
        if (m != null) {
            while (this.baseShape.type == m) {
                this.baseShape.randomiseShape();
            }
        }
    }

    public void randomiseShape(ElasticModel m) {
        this.baseShape.randomiseShape();
        if (m != null) {
            while (this.baseShape.equals(m.baseShape)) {
                this.baseShape.randomiseShape();
            }
        }
    }

    public DictionaryModel.ShapeType getShape() {
        return this.baseShape.type;
    }

    public void setShape(DictionaryModel.ShapeType sh) {
        this.baseShape.type = sh;
    }

    public static void main(String[] args) {
    }

    public String toString() {
        return this.baseShape.toString() + " warp =" + warpPercent;
    }
}

